/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.rewrite;

import com.sun.source.tree.MethodTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class FindMissingOverride
extends TreePathScanner<Void, List<TreePath>> {
    private final Trees trees;
    private final Elements elements;
    private final Types types;
    private static final Logger LOG = Logger.getLogger("main");

    FindMissingOverride(JavacTask task) {
        this.trees = Trees.instance(task);
        this.elements = task.getElements();
        this.types = task.getTypes();
    }

    @Override
    public Void visitMethod(MethodTree t, List<TreePath> missing) {
        ExecutableElement method = (ExecutableElement)this.trees.getElement(this.getCurrentPath());
        List<Element> supers = this.overrides(method);
        if (!supers.isEmpty() && !this.hasOverrideAnnotation(method)) {
            Element overridesMethod = supers.get(0);
            Element overridesClass = overridesMethod.getEnclosingElement();
            LOG.info(String.format("...`%s` has no @Override annotation but overrides `%s.%s`", method, overridesClass, overridesMethod));
            missing.add(this.getCurrentPath());
        }
        return (Void)super.visitMethod(t, null);
    }

    private boolean hasOverrideAnnotation(ExecutableElement method) {
        for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
            DeclaredType type = annotationMirror.getAnnotationType();
            Element el = type.asElement();
            String name = el.toString();
            if (!name.equals("java.lang.Override")) continue;
            return true;
        }
        return false;
    }

    private List<Element> overrides(ExecutableElement method) {
        ArrayList<Element> missing = new ArrayList<Element>();
        TypeElement enclosingClass = (TypeElement)method.getEnclosingElement();
        TypeMirror enclosingType = enclosingClass.asType();
        for (TypeMirror typeMirror : this.types.directSupertypes(enclosingType)) {
            TypeElement e = (TypeElement)this.types.asElement(typeMirror);
            for (Element element : e.getEnclosedElements()) {
                if (!(element instanceof ExecutableElement) || !this.elements.overrides(method, (ExecutableElement)element, enclosingClass)) continue;
                missing.add(element);
            }
        }
        return missing;
    }
}

