/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.rewrite;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

class FindUsedImports
extends TreePathScanner<Void, Set<String>> {
    private final Trees trees;
    private final Set<String> imports = new HashSet<String>();

    FindUsedImports(JavacTask task) {
        this.trees = Trees.instance(task);
    }

    @Override
    public Void visitImport(ImportTree t, Set<String> references) {
        if (!t.isStatic()) {
            this.imports.add(Objects.toString(t.getQualifiedIdentifier(), ""));
        }
        return (Void)super.visitImport(t, references);
    }

    @Override
    public Void visitIdentifier(IdentifierTree t, Set<String> references) {
        Element e = this.trees.getElement(this.getCurrentPath());
        if (e instanceof TypeElement) {
            TypeElement type = (TypeElement)e;
            String qualifiedName = type.getQualifiedName().toString();
            String packageName = this.packageName(qualifiedName);
            String starImport = packageName + ".*";
            if (this.imports.contains(qualifiedName)) {
                references.add(qualifiedName);
            } else if (this.imports.contains(starImport)) {
                references.add(starImport);
            }
        }
        return null;
    }

    private String packageName(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot != -1) {
            return qualifiedName.substring(0, lastDot);
        }
        return "";
    }
}

