/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.rewrite;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.util.Trees;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;
import org.javacs.CompileTask;
import org.javacs.CompilerProvider;
import org.javacs.FindHelper;
import org.javacs.ParseTask;
import org.javacs.lsp.Position;
import org.javacs.lsp.Range;
import org.javacs.lsp.TextEdit;
import org.javacs.rewrite.EditHelper;
import org.javacs.rewrite.Rewrite;

public class ImplementAbstractMethods
implements Rewrite {
    final String className;
    private static final Logger LOG = Logger.getLogger("main");

    public ImplementAbstractMethods(String className) {
        this.className = className;
    }

    @Override
    public Map<Path, TextEdit[]> rewrite(CompilerProvider compiler) {
        Path file = compiler.findTypeDeclaration(this.className);
        StringJoiner insertText = new StringJoiner("\n");
        try (CompileTask task = compiler.compile(file);){
            Elements elements = task.task.getElements();
            Types types = task.task.getTypes();
            Trees trees = Trees.instance(task.task);
            TypeElement thisClass = elements.getTypeElement(this.className);
            DeclaredType thisType = (DeclaredType)thisClass.asType();
            ClassTree thisTree = trees.getTree(thisClass);
            int indent = EditHelper.indent(task.task, task.root(), thisTree) + 4;
            for (Element element : elements.getAllMembers(thisClass)) {
                if (element.getKind() != ElementKind.METHOD || !element.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                ExecutableElement method = (ExecutableElement)element;
                MethodTree source = this.findSource(compiler, task, method);
                if (source == null) {
                    LOG.warning("...couldn't find source for " + String.valueOf(method));
                }
                ExecutableType parameterizedType = (ExecutableType)types.asMemberOf(thisType, method);
                String text = EditHelper.printMethod(method, parameterizedType, source);
                text = text.replaceAll("\n", "\n" + " ".repeat(indent));
                insertText.add(text);
            }
            Position insert = EditHelper.insertAtEndOfClass(task.task, task.root(), thisTree);
            TextEdit[] textEditArray = new TextEdit[]{new TextEdit(new Range(insert, insert), String.valueOf(insertText) + "\n")};
            Map<Path, TextEdit[]> map = Map.of(file, textEditArray);
            return map;
        }
    }

    private MethodTree findSource(CompilerProvider compiler, CompileTask task, ExecutableElement method) {
        TypeElement superClass = (TypeElement)method.getEnclosingElement();
        String superClassName = superClass.getQualifiedName().toString();
        String methodName = method.getSimpleName().toString();
        String[] erasedParameterTypes = FindHelper.erasedParameterTypes(task, method);
        Optional<JavaFileObject> sourceFile = compiler.findAnywhere(superClassName);
        if (sourceFile.isEmpty()) {
            return null;
        }
        ParseTask parse = compiler.parse(sourceFile.get());
        return FindHelper.findMethod(parse, superClassName, methodName, erasedParameterTypes);
    }
}

