/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.rewrite;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;
import org.javacs.CompileTask;
import org.javacs.CompilerProvider;
import org.javacs.FindHelper;
import org.javacs.FindTypeDeclarationAt;
import org.javacs.ParseTask;
import org.javacs.lsp.Position;
import org.javacs.lsp.Range;
import org.javacs.lsp.TextEdit;
import org.javacs.rewrite.EditHelper;
import org.javacs.rewrite.Rewrite;

public class OverrideInheritedMethod
implements Rewrite {
    final String superClassName;
    final String methodName;
    final String[] erasedParameterTypes;
    final Path file;
    final int insertPosition;

    public OverrideInheritedMethod(String superClassName, String methodName, String[] erasedParameterTypes, Path file, int insertPosition) {
        this.superClassName = superClassName;
        this.methodName = methodName;
        this.erasedParameterTypes = erasedParameterTypes;
        this.file = file;
        this.insertPosition = insertPosition;
    }

    @Override
    public Map<Path, TextEdit[]> rewrite(CompilerProvider compiler) {
        Position insertPoint = this.insertNearCursor(compiler);
        String insertText = this.insertText(compiler);
        TextEdit[] edits = new TextEdit[]{new TextEdit(new Range(insertPoint, insertPoint), insertText)};
        return Map.of(this.file, edits);
    }

    private String insertText(CompilerProvider compiler) {
        try (CompileTask task = compiler.compile(this.file);){
            Types types = task.task.getTypes();
            Trees trees = Trees.instance(task.task);
            ExecutableElement superMethod = FindHelper.findMethod(task, this.superClassName, this.methodName, this.erasedParameterTypes);
            ClassTree thisTree = (ClassTree)new FindTypeDeclarationAt(task.task).scan(task.root(), Long.valueOf(this.insertPosition));
            TreePath thisPath = trees.getPath(task.root(), thisTree);
            TypeElement thisClass = (TypeElement)trees.getElement(thisPath);
            ExecutableType parameterizedType = (ExecutableType)types.asMemberOf((DeclaredType)thisClass.asType(), superMethod);
            int indent = EditHelper.indent(task.task, task.root(), thisTree) + 4;
            Optional<JavaFileObject> sourceFile = compiler.findAnywhere(this.superClassName);
            if (sourceFile.isEmpty()) {
                String string = "";
                return string;
            }
            ParseTask parse = compiler.parse(sourceFile.get());
            MethodTree source = FindHelper.findMethod(parse, this.superClassName, this.methodName, this.erasedParameterTypes);
            Object text = EditHelper.printMethod(superMethod, parameterizedType, source);
            text = ((String)text).replaceAll("\n", "\n" + " ".repeat(indent));
            Object object = text = (String)text + "\n\n";
            return object;
        }
    }

    private Position insertNearCursor(CompilerProvider compiler) {
        ClassTree parent;
        ParseTask task = compiler.parse(this.file);
        Position next = this.nextMember(task, parent = (ClassTree)new FindTypeDeclarationAt(task.task).scan(task.root, Long.valueOf(this.insertPosition)));
        if (next != Position.NONE) {
            return next;
        }
        return EditHelper.insertAtEndOfClass(task.task, task.root, parent);
    }

    private Position nextMember(ParseTask task, ClassTree parent) {
        SourcePositions pos = Trees.instance(task.task).getSourcePositions();
        for (Tree tree : parent.getMembers()) {
            long start = pos.getStartPosition(task.root, tree);
            if (start <= (long)this.insertPosition) continue;
            int line = (int)task.root.getLineMap().getLineNumber(start);
            return new Position(line - 1, 0);
        }
        return Position.NONE;
    }
}

