/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.rewrite;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.javacs.CompileTask;
import org.javacs.CompilerProvider;
import org.javacs.FindHelper;
import org.javacs.lsp.Position;
import org.javacs.lsp.Range;
import org.javacs.lsp.TextEdit;
import org.javacs.rewrite.Rewrite;

public class RemoveException
implements Rewrite {
    final String className;
    final String methodName;
    final String[] erasedParameterTypes;
    final String exceptionType;
    private static final Pattern THROWS = Pattern.compile("\\s*\\bthrows\\b");

    public RemoveException(String className, String methodName, String[] erasedParameterTypes, String exceptionType) {
        this.className = className;
        this.methodName = methodName;
        this.erasedParameterTypes = erasedParameterTypes;
        this.exceptionType = exceptionType;
    }

    @Override
    public Map<Path, TextEdit[]> rewrite(CompilerProvider compiler) {
        Path file = compiler.findTypeDeclaration(this.className);
        try (CompileTask task = compiler.compile(file);){
            ExecutableElement methodElement = FindHelper.findMethod(task, this.className, this.methodName, this.erasedParameterTypes);
            MethodTree methodTree = Trees.instance(task.task).getTree(methodElement);
            if (methodTree.getThrows().size() == 1) {
                TextEdit delete = this.removeEntireThrows(task.task, task.root(), methodTree);
                if (delete == TextEdit.NONE) {
                    Map map = CANCELLED;
                    return map;
                }
                TextEdit[] edits = new TextEdit[]{delete};
                Map<Path, TextEdit[]> map = Map.of(file, edits);
                return map;
            }
            TextEdit[] edits = new TextEdit[]{this.removeSingleException(task.task, task.root(), methodTree)};
            Map<Path, TextEdit[]> map = Map.of(file, edits);
            return map;
        }
    }

    private TextEdit removeEntireThrows(JavacTask task, CompilationUnitTree root, MethodTree method) {
        CharSequence contents;
        Trees trees = Trees.instance(task);
        SourcePositions pos = trees.getSourcePositions();
        int startMethod = (int)pos.getStartPosition(root, method);
        try {
            contents = root.getSourceFile().getCharContent(true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Matcher matcher = THROWS.matcher(contents);
        if (!matcher.find(startMethod)) {
            return TextEdit.NONE;
        }
        LineMap lines = root.getLineMap();
        int start = matcher.start();
        int startLine = (int)lines.getLineNumber(start);
        int startColumn = (int)lines.getColumnNumber(start);
        Position startPos = new Position(startLine - 1, startColumn - 1);
        ExpressionTree lastException = method.getThrows().get(method.getThrows().size() - 1);
        int end = (int)pos.getEndPosition(root, lastException);
        int endLine = (int)lines.getLineNumber(end);
        int endColumn = (int)lines.getColumnNumber(end);
        Position endPos = new Position(endLine - 1, endColumn - 1);
        return new TextEdit(new Range(startPos, endPos), "");
    }

    private TextEdit removeSingleException(JavacTask task, CompilationUnitTree root, MethodTree method) {
        int i = this.findNamedException(task, root, method);
        if (i == -1) {
            return TextEdit.NONE;
        }
        Trees trees = Trees.instance(task);
        SourcePositions pos = trees.getSourcePositions();
        ExpressionTree exn = method.getThrows().get(i);
        long start = pos.getStartPosition(root, exn);
        long end = pos.getEndPosition(root, exn);
        if (i == 0) {
            end = this.removeTrailingComma(root, end);
        } else {
            start = this.removeLeadingComma(root, start);
        }
        LineMap lines = root.getLineMap();
        int startLine = (int)lines.getLineNumber(start);
        int startColumn = (int)lines.getColumnNumber(start);
        Position startPos = new Position(startLine - 1, startColumn - 1);
        int endLine = (int)lines.getLineNumber(end);
        int endColumn = (int)lines.getColumnNumber(end);
        Position endPos = new Position(endLine - 1, endColumn - 1);
        return new TextEdit(new Range(startPos, endPos), "");
    }

    private int findNamedException(JavacTask task, CompilationUnitTree root, MethodTree method) {
        Trees trees = Trees.instance(task);
        for (int i = 0; i < method.getThrows().size(); ++i) {
            ExpressionTree e = method.getThrows().get(i);
            TreePath path = trees.getPath(root, e);
            DeclaredType type = (DeclaredType)trees.getTypeMirror(path);
            TypeElement el = (TypeElement)type.asElement();
            if (!el.getQualifiedName().contentEquals(this.exceptionType)) continue;
            return i;
        }
        return -1;
    }

    private int removeLeadingComma(CompilationUnitTree root, long start) {
        CharSequence contents = this.contents(root);
        for (int i = (int)start; i > 0; --i) {
            if (contents.charAt(i) != ',') continue;
            return i;
        }
        return -1;
    }

    private int removeTrailingComma(CompilationUnitTree root, long end) {
        CharSequence contents = this.contents(root);
        for (int i = (int)end; i < contents.length(); ++i) {
            if (contents.charAt(i) != ',') continue;
            if (contents.charAt(i + 1) == ' ') {
                return i + 2;
            }
            return i + 1;
        }
        return -1;
    }

    private CharSequence contents(CompilationUnitTree root) {
        try {
            return root.getSourceFile().getCharContent(true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

