/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.rewrite;

import java.nio.file.Path;
import java.util.Map;
import java.util.logging.Logger;
import org.javacs.CompileTask;
import org.javacs.CompilerProvider;
import org.javacs.lsp.TextEdit;
import org.javacs.rewrite.RenameHelper;
import org.javacs.rewrite.Rewrite;

public class RenameField
implements Rewrite {
    final String className;
    final String fieldName;
    final String newName;
    private static final Logger LOG = Logger.getLogger("main");

    public RenameField(String className, String fieldName, String newName) {
        this.className = className;
        this.fieldName = fieldName;
        this.newName = newName;
    }

    @Override
    public Map<Path, TextEdit[]> rewrite(CompilerProvider compiler) {
        LOG.info("Rewrite " + this.className + "#" + this.fieldName + " to " + this.newName + "...");
        Path[] paths = compiler.findMemberReferences(this.className, this.fieldName);
        if (paths.length == 0) {
            LOG.warning("...no references to " + this.className + "#" + this.fieldName);
            return Map.of();
        }
        LOG.info("...check " + paths.length + " files for references");
        try (CompileTask compile = compiler.compile(paths);){
            Map<Path, TextEdit[]> edits;
            RenameHelper helper = new RenameHelper(compile);
            Map<Path, TextEdit[]> map = edits = helper.renameField(compile.roots, this.className, this.fieldName, this.newName);
            return map;
        }
    }
}

