/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.rewrite;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.javacs.CompileTask;
import org.javacs.FindHelper;
import org.javacs.lsp.Position;
import org.javacs.lsp.Range;
import org.javacs.lsp.TextEdit;
import org.javacs.rewrite.FindFieldReferences;
import org.javacs.rewrite.FindMethodReferences;
import org.javacs.rewrite.FindReferences;

class RenameHelper {
    final CompileTask task;

    RenameHelper(CompileTask task) {
        this.task = task;
    }

    TextEdit[] renameVariable(CompilationUnitTree root, TreePath rename, String newName) {
        Trees trees = Trees.instance(this.task.task);
        Element target = trees.getElement(rename);
        List<TreePath> found = this.findVariableReferences(root, target);
        return this.replaceAll(found, newName);
    }

    Map<Path, TextEdit[]> renameMethod(List<CompilationUnitTree> roots, String className, String methodName, String[] erasedParameterTypes, String newName) {
        HashMap<Path, TextEdit[]> allEdits = new HashMap<Path, TextEdit[]>();
        ExecutableElement method = FindHelper.findMethod(this.task, className, methodName, erasedParameterTypes);
        for (CompilationUnitTree root : roots) {
            Path file = Paths.get(root.getSourceFile().toUri());
            List<TreePath> references = this.findMethodReferences(root, method);
            if (references.isEmpty()) continue;
            TextEdit[] fileEdits = this.replaceAll(references, newName);
            allEdits.put(file, fileEdits);
        }
        return allEdits;
    }

    Map<Path, TextEdit[]> renameField(List<CompilationUnitTree> roots, String className, String fieldName, String newName) {
        HashMap<Path, TextEdit[]> allEdits = new HashMap<Path, TextEdit[]>();
        for (CompilationUnitTree root : roots) {
            Path file = Paths.get(root.getSourceFile().toUri());
            List<TreePath> references = this.findFieldReferences(root, className, fieldName);
            if (references.isEmpty()) continue;
            TextEdit[] fileEdits = this.replaceAll(references, newName);
            allEdits.put(file, fileEdits);
        }
        return allEdits;
    }

    private List<TreePath> findVariableReferences(CompilationUnitTree root, Element target) {
        Trees trees = Trees.instance(this.task.task);
        ArrayList<TreePath> found = new ArrayList<TreePath>();
        Consumer<TreePath> forEach = path -> {
            Element candidate = trees.getElement((TreePath)path);
            if (target.equals(candidate)) {
                found.add((TreePath)path);
            }
        };
        new FindReferences().scan(root, forEach);
        return found;
    }

    private List<TreePath> findFieldReferences(CompilationUnitTree root, String className, String fieldName) {
        ArrayList<TreePath> found = new ArrayList<TreePath>();
        Consumer<TreePath> forEach = path -> {
            if (this.isFieldReference((TreePath)path, className, fieldName)) {
                found.add((TreePath)path);
            }
        };
        new FindFieldReferences().scan(root, forEach);
        return found;
    }

    private boolean isFieldReference(TreePath path, String className, String fieldName) {
        Trees trees = Trees.instance(this.task.task);
        Element candidate = trees.getElement(path);
        if (!(candidate instanceof VariableElement)) {
            return false;
        }
        VariableElement variable = (VariableElement)candidate;
        if (!variable.getSimpleName().contentEquals(fieldName)) {
            return false;
        }
        if (!(variable.getEnclosingElement() instanceof TypeElement)) {
            return false;
        }
        TypeElement parent = (TypeElement)variable.getEnclosingElement();
        return parent.getQualifiedName().contentEquals(className);
    }

    private List<TreePath> findMethodReferences(CompilationUnitTree root, ExecutableElement find) {
        Trees trees = Trees.instance(this.task.task);
        ArrayList<TreePath> found = new ArrayList<TreePath>();
        Consumer<TreePath> forEach = path -> {
            Element candidate = trees.getElement((TreePath)path);
            if (find.equals(candidate)) {
                found.add((TreePath)path);
            }
        };
        new FindMethodReferences().scan(root, forEach);
        return found;
    }

    private TextEdit[] replaceAll(List<TreePath> found, String newName) {
        Trees trees = Trees.instance(this.task.task);
        SourcePositions pos = trees.getSourcePositions();
        TextEdit[] edits = new TextEdit[found.size()];
        int i = 0;
        for (TreePath f : found) {
            ExpressionTree select;
            CompilationUnitTree root = f.getCompilationUnit();
            LineMap lines = root.getLineMap();
            long startPos = pos.getStartPosition(root, f.getLeaf());
            long endPos = pos.getEndPosition(root, f.getLeaf());
            if (f.getLeaf() instanceof VariableTree) {
                VariableTree variable = (VariableTree)f.getLeaf();
                startPos = this.findName(root, startPos, variable.getName());
                endPos = startPos + (long)variable.getName().length();
            }
            if (f.getLeaf() instanceof MethodTree) {
                MethodTree method = (MethodTree)f.getLeaf();
                startPos = pos.getEndPosition(root, method.getReturnType());
                startPos = this.findName(root, startPos, method.getName());
                endPos = startPos + (long)method.getName().length();
            }
            if (f.getLeaf() instanceof MemberReferenceTree) {
                select = (MemberReferenceTree)f.getLeaf();
                startPos = pos.getEndPosition(root, select.getQualifierExpression());
                startPos = this.findName(root, startPos, select.getName());
                endPos = startPos + (long)select.getName().length();
            }
            if (f.getLeaf() instanceof MemberSelectTree) {
                select = (MemberSelectTree)f.getLeaf();
                startPos = pos.getEndPosition(root, select.getExpression());
                startPos = this.findName(root, startPos, select.getIdentifier());
                endPos = startPos + (long)select.getIdentifier().length();
            }
            int startLine = (int)lines.getLineNumber(startPos);
            int startColumn = (int)lines.getColumnNumber(startPos);
            int endLine = (int)lines.getLineNumber(endPos);
            int endColumn = (int)lines.getColumnNumber(endPos);
            Range range = new Range(new Position(startLine - 1, startColumn - 1), new Position(endLine - 1, endColumn - 1));
            edits[i++] = new TextEdit(range, newName);
        }
        return edits;
    }

    private long findName(CompilationUnitTree root, long startPos, CharSequence name) {
        try {
            CharSequence contents = root.getSourceFile().getCharContent(true);
            Matcher matcher = Pattern.compile("\\b" + String.valueOf(name) + "\\b").matcher(contents);
            if (matcher.find((int)startPos)) {
                return matcher.start();
            }
            return startPos;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

