/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.rewrite;

import java.nio.file.Path;
import java.util.Map;
import java.util.logging.Logger;
import org.javacs.CompileTask;
import org.javacs.CompilerProvider;
import org.javacs.lsp.TextEdit;
import org.javacs.rewrite.RenameHelper;
import org.javacs.rewrite.Rewrite;

public class RenameMethod
implements Rewrite {
    final String className;
    final String methodName;
    final String[] erasedParameterTypes;
    final String newName;
    private static final Logger LOG = Logger.getLogger("main");

    public RenameMethod(String className, String methodName, String[] erasedParameterTypes, String newName) {
        this.className = className;
        this.methodName = methodName;
        this.erasedParameterTypes = erasedParameterTypes;
        this.newName = newName;
    }

    @Override
    public Map<Path, TextEdit[]> rewrite(CompilerProvider compiler) {
        LOG.info("Rewrite " + this.className + "#" + this.methodName + " to " + this.newName + "...");
        Path[] paths = compiler.findMemberReferences(this.className, this.methodName);
        if (paths.length == 0) {
            LOG.warning("...no references to " + this.className + "#" + this.methodName);
            return Map.of();
        }
        LOG.info("...check " + paths.length + " files for references");
        try (CompileTask compile = compiler.compile(paths);){
            Map<Path, TextEdit[]> edits;
            RenameHelper helper = new RenameHelper(compile);
            Map<Path, TextEdit[]> map = edits = helper.renameMethod(compile.roots, this.className, this.methodName, this.erasedParameterTypes, this.newName);
            return map;
        }
    }
}

