/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.rewrite;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.nio.file.Path;
import java.util.Map;
import org.javacs.CompileTask;
import org.javacs.CompilerProvider;
import org.javacs.lsp.TextEdit;
import org.javacs.rewrite.FindVariableAt;
import org.javacs.rewrite.RenameHelper;
import org.javacs.rewrite.Rewrite;

public class RenameVariable
implements Rewrite {
    final Path file;
    final int position;
    final String newName;

    public RenameVariable(Path file, int position, String newName) {
        this.file = file;
        this.position = position;
        this.newName = newName;
    }

    @Override
    public Map<Path, TextEdit[]> rewrite(CompilerProvider compiler) {
        try (CompileTask compile = compiler.compile(this.file);){
            Trees trees = Trees.instance(compile.task);
            CompilationUnitTree root = compile.root();
            VariableTree found = (VariableTree)new FindVariableAt(compile.task).scan(root, Integer.valueOf(this.position));
            if (found == null) {
                Map map = CANCELLED;
                return map;
            }
            TreePath rename = trees.getPath(root, found);
            TextEdit[] edits = new RenameHelper(compile).renameVariable(root, rename, this.newName);
            Map<Path, TextEdit[]> map = Map.of(this.file, edits);
            return map;
        }
    }
}

