/*
 * Decompiled with CFR 0.152.
 */
package org.javacs;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

class ClassHeader {
    final boolean isPublic;
    final boolean isFinal;
    final boolean isInterface;
    final boolean isAbstract;
    final boolean isAnnotation;
    final boolean isEnum;
    final boolean isModule;
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_FINAL = 16;
    private static final int ACC_SUPER = 32;
    private static final int ACC_INTERFACE = 512;
    private static final int ACC_ABSTRACT = 1024;
    private static final int ACC_SYNTHETIC = 4096;
    private static final int ACC_ANNOTATION = 8192;
    private static final int ACC_ENUM = 16384;
    private static final int ACC_MODULE = 32768;
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_Fieldref = 9;
    private static final int CONSTANT_Methodref = 10;
    private static final int CONSTANT_InterfaceMethodref = 11;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_NameAndType = 12;
    private static final int CONSTANT_Utf8 = 1;
    private static final int CONSTANT_MethodHandle = 15;
    private static final int CONSTANT_MethodType = 16;
    private static final int CONSTANT_InvokeDynamic = 18;
    private static final int CONSTANT_Module = 19;
    private static final int CONSTANT_Package = 20;

    static ClassHeader of(InputStream in) {
        return new ClassHeader(new DataInputStream(in));
    }

    private ClassHeader(DataInputStream in) {
        try {
            byte[] magic = in.readNBytes(4);
            int minorVersion = in.readUnsignedShort();
            int majorVersion = in.readUnsignedShort();
            int constantPoolCount = in.readUnsignedShort();
            Constant[] constants = new Constant[constantPoolCount];
            for (int i = 0; i < constantPoolCount - 1; i += this.slots(constants[i])) {
                constants[i] = this.readConstant(in);
            }
            int accessFlags = in.readUnsignedShort();
            this.isPublic = (accessFlags & 1) != 0;
            this.isFinal = (accessFlags & 0x10) != 0;
            this.isInterface = (accessFlags & 0x200) != 0;
            this.isAbstract = (accessFlags & 0x400) != 0;
            this.isAnnotation = (accessFlags & 0x2000) != 0;
            this.isEnum = (accessFlags & 0x4000) != 0;
            this.isModule = (accessFlags & 0x8000) != 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Constant readConstant(DataInputStream in) throws IOException {
        short tag = in.readByte();
        switch (tag) {
            case 7: 
            case 8: 
            case 16: {
                byte[] info = in.readNBytes(2);
                return new Constant(tag, info);
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: {
                byte[] info = in.readNBytes(4);
                return new Constant(tag, info);
            }
            case 5: 
            case 6: {
                byte[] info = in.readNBytes(8);
                return new Constant(tag, info);
            }
            case 1: {
                int length = in.readUnsignedShort();
                byte[] string = in.readNBytes(length);
                return new Constant(tag, string);
            }
            case 15: 
            case 19: 
            case 20: {
                byte[] info = in.readNBytes(3);
                return new Constant(tag, info);
            }
        }
        throw new RuntimeException("Don't know what to do with " + tag);
    }

    private int slots(Constant c) {
        switch (c.tag) {
            case 5: 
            case 6: {
                return 2;
            }
        }
        return 1;
    }

    private static class Constant {
        final short tag;
        final byte[] info;

        Constant(short tag, byte[] info) {
            this.tag = tag;
            this.info = info;
        }
    }
}

