/*
 * Decompiled with CFR 0.152.
 */
package org.javacs;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import org.javacs.StringSearch;
import org.javacs.VersionedContent;
import org.javacs.lsp.DidChangeTextDocumentParams;
import org.javacs.lsp.DidCloseTextDocumentParams;
import org.javacs.lsp.DidOpenTextDocumentParams;
import org.javacs.lsp.Range;
import org.javacs.lsp.TextDocumentContentChangeEvent;
import org.javacs.lsp.TextDocumentItem;
import org.javacs.lsp.VersionedTextDocumentIdentifier;

public class FileStore {
    private static final Set<Path> workspaceRoots = new HashSet<Path>();
    private static final Map<Path, VersionedContent> activeDocuments = new HashMap<Path, VersionedContent>();
    private static final TreeMap<Path, Info> javaSources = new TreeMap();
    private static final Logger LOG = Logger.getLogger("main");

    static void setWorkspaceRoots(Set<Path> newRoots) {
        newRoots = FileStore.normalize(newRoots);
        for (Path root : workspaceRoots) {
            if (newRoots.contains(root)) continue;
            workspaceRoots.removeIf(f -> f.startsWith(root));
        }
        for (Path root : newRoots) {
            if (workspaceRoots.contains(root)) continue;
            FileStore.addFiles(root);
        }
        workspaceRoots.clear();
        workspaceRoots.addAll(newRoots);
    }

    private static Set<Path> normalize(Set<Path> newRoots) {
        HashSet<Path> normalize = new HashSet<Path>();
        for (Path root : newRoots) {
            normalize.add(root.toAbsolutePath().normalize());
        }
        return normalize;
    }

    private static void addFiles(Path root) {
        try {
            Files.walkFileTree(root, new FindJavaSources());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static Collection<Path> all() {
        return javaSources.keySet();
    }

    static List<Path> list(String packageName) {
        ArrayList<Path> list = new ArrayList<Path>();
        for (Path file : javaSources.keySet()) {
            if (!FileStore.javaSources.get((Object)file).packageName.equals(packageName)) continue;
            list.add(file);
        }
        return list;
    }

    public static Set<Path> sourceRoots() {
        HashSet<Path> roots = new HashSet<Path>();
        for (Path file : javaSources.keySet()) {
            Path root = FileStore.sourceRoot(file);
            if (root == null) continue;
            roots.add(root);
        }
        return roots;
    }

    private static Path sourceRoot(Path file) {
        Info info = javaSources.get(file);
        String[] parts = info.packageName.split("\\.");
        Path dir = file.getParent();
        for (int i = parts.length - 1; i >= 0; --i) {
            String end = parts[i];
            if (!dir.endsWith(end)) {
                return null;
            }
            dir = dir.getParent();
        }
        return dir;
    }

    static boolean contains(Path file) {
        return FileStore.isJavaFile(file) && javaSources.containsKey(file);
    }

    static Instant modified(Path file) {
        if (activeDocuments.containsKey(file)) {
            return FileStore.activeDocuments.get((Object)file).modified;
        }
        if (!javaSources.containsKey(file)) {
            FileStore.readInfoFromDisk(file);
        }
        return FileStore.javaSources.get((Object)file).modified;
    }

    static String packageName(Path file) {
        if (!javaSources.containsKey(file)) {
            FileStore.readInfoFromDisk(file);
        }
        return FileStore.javaSources.get((Object)file).packageName;
    }

    public static String suggestedPackageName(Path file) {
        for (Path dir = file.getParent(); dir != null; dir = dir.getParent()) {
            for (Path sibling : FileStore.javaSourcesIn(dir)) {
                Object packageName;
                if (sibling.equals(file) || ((String)(packageName = FileStore.packageName(sibling))).isBlank()) continue;
                Path relativePath = dir.relativize(file.getParent());
                String relativePackage = relativePath.toString().replace(File.separatorChar, '.');
                if (!relativePackage.isEmpty()) {
                    packageName = (String)packageName + "." + relativePackage;
                }
                return packageName;
            }
        }
        return "";
    }

    private static List<Path> javaSourcesIn(Path dir) {
        Path file;
        NavigableMap<Path, Info> tail = javaSources.tailMap(dir, false);
        ArrayList<Path> list = new ArrayList<Path>();
        Iterator iterator = tail.keySet().iterator();
        while (iterator.hasNext() && (file = (Path)iterator.next()).startsWith(dir)) {
            list.add(file);
        }
        return list;
    }

    static void externalCreate(Path file) {
        FileStore.readInfoFromDisk(file);
    }

    static void externalChange(Path file) {
        FileStore.readInfoFromDisk(file);
    }

    static void externalDelete(Path file) {
        javaSources.remove(file);
    }

    private static void readInfoFromDisk(Path file) {
        try {
            Instant time = Files.getLastModifiedTime(file, new LinkOption[0]).toInstant();
            String packageName = StringSearch.packageName(file);
            javaSources.put(file, new Info(time, packageName));
        }
        catch (NoSuchFileException e) {
            LOG.warning(e.getMessage());
            javaSources.remove(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void open(DidOpenTextDocumentParams params) {
        if (!FileStore.isJavaFile(params.textDocument.uri)) {
            return;
        }
        TextDocumentItem document = params.textDocument;
        Path file = Paths.get(document.uri);
        activeDocuments.put(file, new VersionedContent(document.text, document.version));
    }

    static void change(DidChangeTextDocumentParams params) {
        if (!FileStore.isJavaFile(params.textDocument.uri)) {
            return;
        }
        VersionedTextDocumentIdentifier document = params.textDocument;
        Path file = Paths.get(document.uri);
        VersionedContent existing = activeDocuments.get(file);
        if (document.version <= existing.version) {
            LOG.warning("Ignored change with version " + document.version + " <= " + existing.version);
            return;
        }
        String newText = existing.content;
        for (TextDocumentContentChangeEvent change : params.contentChanges) {
            if (change.range == null) {
                newText = change.text;
                continue;
            }
            newText = FileStore.patch(newText, change);
        }
        activeDocuments.put(file, new VersionedContent(newText, document.version));
    }

    static void close(DidCloseTextDocumentParams params) {
        if (!FileStore.isJavaFile(params.textDocument.uri)) {
            return;
        }
        Path file = Paths.get(params.textDocument.uri);
        activeDocuments.remove(file);
    }

    static Set<Path> activeDocuments() {
        return activeDocuments.keySet();
    }

    public static String contents(Path file) {
        if (!FileStore.isJavaFile(file)) {
            throw new RuntimeException(String.valueOf(file) + " is not a java file");
        }
        if (activeDocuments.containsKey(file)) {
            return FileStore.activeDocuments.get((Object)file).content;
        }
        try {
            return Files.readString(file);
        }
        catch (NoSuchFileException e) {
            LOG.warning(e.getMessage());
            return "";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static InputStream inputStream(Path file) {
        URI uri = file.toUri();
        if (activeDocuments.containsKey(uri)) {
            String string = FileStore.activeDocuments.get((Object)uri).content;
            byte[] bytes = string.getBytes();
            return new ByteArrayInputStream(bytes);
        }
        try {
            return Files.newInputStream(file, new OpenOption[0]);
        }
        catch (NoSuchFileException e) {
            LOG.warning(e.getMessage());
            byte[] bs = new byte[]{};
            return new ByteArrayInputStream(bs);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static BufferedReader bufferedReader(Path file) {
        URI uri = file.toUri();
        if (activeDocuments.containsKey(uri)) {
            String string = FileStore.activeDocuments.get((Object)uri).content;
            return new BufferedReader(new StringReader(string));
        }
        try {
            return Files.newBufferedReader(file);
        }
        catch (NoSuchFileException e) {
            LOG.warning(e.getMessage());
            return new BufferedReader(new StringReader(""));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static BufferedReader lines(Path file) {
        return FileStore.bufferedReader(file);
    }

    static int offset(String contents, int line, int column) {
        --line;
        --column;
        int cursor = 0;
        while (line > 0) {
            if (contents.charAt(cursor) == '\n') {
                --line;
            }
            ++cursor;
        }
        return cursor + column;
    }

    private static String patch(String sourceText, TextDocumentContentChangeEvent change) {
        try {
            Range range = change.range;
            BufferedReader reader = new BufferedReader(new StringReader(sourceText));
            StringWriter writer = new StringWriter();
            for (int line = 0; line < range.start.line; ++line) {
                writer.write(reader.readLine() + "\n");
            }
            for (int character = 0; character < range.start.character; ++character) {
                writer.write(reader.read());
            }
            writer.write(change.text);
            if (change.range.start.line == change.range.end.line) {
                int chars = change.range.end.character - change.range.start.character;
                reader.skip(chars);
            } else {
                int lines = change.range.end.line - change.range.start.line;
                int chars = change.range.end.character;
                for (int lineSkip = 0; lineSkip < lines; ++lineSkip) {
                    reader.readLine();
                }
                reader.skip(chars);
            }
            while (true) {
                int next;
                if ((next = reader.read()) == -1) {
                    return writer.toString();
                }
                writer.write(next);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isJavaFile(Path file) {
        String name = file.getFileName().toString();
        return name.endsWith(".java") && !Files.isDirectory(file, new LinkOption[0]) && !name.equals("module-info.java");
    }

    static boolean isJavaFile(URI uri) {
        return uri.getScheme().equals("file") && FileStore.isJavaFile(Paths.get(uri));
    }

    static Optional<Path> findDeclaringFile(TypeElement el) {
        String qualifiedName = el.getQualifiedName().toString();
        String packageName = StringSearch.mostName(qualifiedName);
        String className = StringSearch.lastName(qualifiedName);
        for (Path f : FileStore.list(packageName)) {
            if (!f.getFileName().toString().equals(className) || !StringSearch.containsType(f, el)) continue;
            return Optional.of(f);
        }
        for (Path f : FileStore.list(packageName)) {
            if (!StringSearch.containsType(f, el)) continue;
            return Optional.of(f);
        }
        return Optional.empty();
    }

    static class FindJavaSources
    extends SimpleFileVisitor<Path> {
        FindJavaSources() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            if (attrs.isSymbolicLink()) {
                LOG.warning("Don't check " + String.valueOf(dir) + " for java sources");
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes _attrs) {
            if (FileStore.isJavaFile(file)) {
                FileStore.readInfoFromDisk(file);
            }
            return FileVisitResult.CONTINUE;
        }
    }

    private static class Info {
        final Instant modified;
        final String packageName;

        Info(Instant modified, String packageName) {
            this.modified = modified;
            this.packageName = packageName;
        }
    }
}

