/*
 * Decompiled with CFR 0.152.
 */
package org.javacs;

import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.javacs.CompileTask;
import org.javacs.FindTypeDeclarationNamed;
import org.javacs.ParseTask;
import org.javacs.lsp.Location;
import org.javacs.lsp.Position;
import org.javacs.lsp.Range;

public class FindHelper {
    public static String[] erasedParameterTypes(CompileTask task, ExecutableElement method) {
        Types types = task.task.getTypes();
        String[] erasedParameterTypes = new String[method.getParameters().size()];
        for (int i = 0; i < erasedParameterTypes.length; ++i) {
            TypeMirror p = method.getParameters().get(i).asType();
            erasedParameterTypes[i] = types.erasure(p).toString();
        }
        return erasedParameterTypes;
    }

    public static MethodTree findMethod(ParseTask task, String className, String methodName, String[] erasedParameterTypes) {
        ClassTree classTree = FindHelper.findType(task, className);
        for (Tree tree : classTree.getMembers()) {
            MethodTree method;
            if (tree.getKind() != Tree.Kind.METHOD || !(method = (MethodTree)tree).getName().contentEquals(methodName) || !FindHelper.isSameMethodType(method, erasedParameterTypes)) continue;
            return method;
        }
        throw new RuntimeException("no method");
    }

    public static VariableTree findField(ParseTask task, String className, String memberName) {
        ClassTree classTree = FindHelper.findType(task, className);
        for (Tree tree : classTree.getMembers()) {
            VariableTree variable;
            if (tree.getKind() != Tree.Kind.VARIABLE || !(variable = (VariableTree)tree).getName().contentEquals(memberName)) continue;
            return variable;
        }
        throw new RuntimeException("no variable");
    }

    public static ClassTree findType(ParseTask task, String className) {
        return (ClassTree)new FindTypeDeclarationNamed().scan(task.root, className);
    }

    public static ExecutableElement findMethod(CompileTask task, String className, String methodName, String[] erasedParameterTypes) {
        TypeElement type = task.task.getElements().getTypeElement(className);
        for (Element element : type.getEnclosedElements()) {
            ExecutableElement method;
            if (element.getKind() != ElementKind.METHOD || !FindHelper.isSameMethod(task, method = (ExecutableElement)element, className, methodName, erasedParameterTypes)) continue;
            return method;
        }
        return null;
    }

    private static boolean isSameMethod(CompileTask task, ExecutableElement method, String className, String methodName, String[] erasedParameterTypes) {
        Types types = task.task.getTypes();
        TypeElement parent = (TypeElement)method.getEnclosingElement();
        if (!parent.getQualifiedName().contentEquals(className)) {
            return false;
        }
        if (!method.getSimpleName().contentEquals(methodName)) {
            return false;
        }
        if (method.getParameters().size() != erasedParameterTypes.length) {
            return false;
        }
        for (int i = 0; i < erasedParameterTypes.length; ++i) {
            TypeMirror erasure = types.erasure(method.getParameters().get(i).asType());
            boolean same = erasure.toString().equals(erasedParameterTypes[i]);
            if (same) continue;
            return false;
        }
        return true;
    }

    private static boolean isSameMethodType(MethodTree candidate, String[] erasedParameterTypes) {
        if (candidate.getParameters().size() != erasedParameterTypes.length) {
            return false;
        }
        for (int i = 0; i < candidate.getParameters().size(); ++i) {
            if (FindHelper.typeMatches(candidate.getParameters().get(i).getType(), erasedParameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean typeMatches(Tree candidate, String erasedType) {
        if (candidate instanceof ParameterizedTypeTree) {
            ParameterizedTypeTree parameterized = (ParameterizedTypeTree)candidate;
            return FindHelper.typeMatches(parameterized.getType(), erasedType);
        }
        if (candidate instanceof PrimitiveTypeTree) {
            return candidate.toString().equals(erasedType);
        }
        if (candidate instanceof IdentifierTree) {
            String simpleName = candidate.toString();
            return erasedType.endsWith(simpleName);
        }
        if (candidate instanceof MemberSelectTree) {
            return candidate.toString().equals(erasedType);
        }
        if (candidate instanceof ArrayTypeTree) {
            ArrayTypeTree array = (ArrayTypeTree)candidate;
            if (!erasedType.endsWith("[]")) {
                return false;
            }
            String erasedElement = erasedType.substring(0, erasedType.length() - "[]".length());
            return FindHelper.typeMatches(array.getType(), erasedElement);
        }
        return true;
    }

    public static Location location(CompileTask task, TreePath path) {
        return FindHelper.location(task, path, "");
    }

    public static Location location(CompileTask task, TreePath path, CharSequence name) {
        LineMap lines = path.getCompilationUnit().getLineMap();
        SourcePositions pos = Trees.instance(task.task).getSourcePositions();
        int start = (int)pos.getStartPosition(path.getCompilationUnit(), path.getLeaf());
        int end = (int)pos.getEndPosition(path.getCompilationUnit(), path.getLeaf());
        if (name.length() > 0) {
            start = FindHelper.findNameIn(path.getCompilationUnit(), name, start, end);
            end = start + name.length();
        }
        int startLine = (int)lines.getLineNumber(start);
        int startColumn = (int)lines.getColumnNumber(start);
        Position startPos = new Position(startLine - 1, startColumn - 1);
        int endLine = (int)lines.getLineNumber(end);
        int endColumn = (int)lines.getColumnNumber(end);
        Position endPos = new Position(endLine - 1, endColumn - 1);
        Range range = new Range(startPos, endPos);
        URI uri = path.getCompilationUnit().getSourceFile().toUri();
        return new Location(uri, range);
    }

    public static int findNameIn(CompilationUnitTree root, CharSequence name, int start, int end) {
        CharSequence contents;
        try {
            contents = root.getSourceFile().getCharContent(true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Matcher matcher = Pattern.compile("\\b" + String.valueOf(name) + "\\b").matcher(contents);
        matcher.region(start, end);
        if (matcher.find()) {
            return matcher.start();
        }
        return -1;
    }
}

