/*
 * Decompiled with CFR 0.152.
 */
package org.javacs;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import javax.lang.model.element.Name;
import org.javacs.CompileTask;
import org.javacs.FindHelper;

public class FindNameAt
extends TreePathScanner<TreePath, Long> {
    private final JavacTask task;
    private CompilationUnitTree root;
    private ClassTree surroundingClass;

    public FindNameAt(CompileTask task) {
        this.task = task.task;
    }

    @Override
    public TreePath visitCompilationUnit(CompilationUnitTree t, Long find) {
        this.root = t;
        return (TreePath)super.visitCompilationUnit(t, find);
    }

    @Override
    public TreePath visitClass(ClassTree t, Long find) {
        ClassTree push = this.surroundingClass;
        this.surroundingClass = t;
        if (this.contains(t, t.getSimpleName(), find)) {
            this.surroundingClass = push;
            return this.getCurrentPath();
        }
        TreePath result = (TreePath)super.visitClass(t, find);
        this.surroundingClass = push;
        return result;
    }

    @Override
    public TreePath visitMethod(MethodTree t, Long find) {
        Name name = t.getName();
        if (name.contentEquals("<init>")) {
            name = this.surroundingClass.getSimpleName();
        }
        if (this.contains(t, name, find)) {
            return this.getCurrentPath();
        }
        return (TreePath)super.visitMethod(t, find);
    }

    @Override
    public TreePath visitIdentifier(IdentifierTree t, Long find) {
        if (this.contains(t, t.getName(), find)) {
            return this.getCurrentPath();
        }
        return (TreePath)super.visitIdentifier(t, find);
    }

    @Override
    public TreePath visitMemberSelect(MemberSelectTree t, Long find) {
        if (this.contains(t, t.getIdentifier(), find)) {
            return this.getCurrentPath();
        }
        return (TreePath)super.visitMemberSelect(t, find);
    }

    @Override
    public TreePath visitMemberReference(MemberReferenceTree t, Long find) {
        if (this.contains(t, t.getName(), find)) {
            return this.getCurrentPath();
        }
        return (TreePath)super.visitMemberReference(t, find);
    }

    @Override
    public TreePath visitVariable(VariableTree t, Long find) {
        if (this.contains(t, t.getName(), find)) {
            return this.getCurrentPath();
        }
        return (TreePath)super.visitVariable(t, find);
    }

    @Override
    public TreePath visitNewClass(NewClassTree t, Long find) {
        long start = Trees.instance(this.task).getSourcePositions().getStartPosition(this.root, t);
        long end = start + (long)"new".length();
        if (start <= find && find < end) {
            return this.getCurrentPath();
        }
        return (TreePath)super.visitNewClass(t, find);
    }

    @Override
    public TreePath reduce(TreePath r1, TreePath r2) {
        if (r1 != null) {
            return r1;
        }
        return r2;
    }

    private boolean contains(Tree t, CharSequence name, long find) {
        SourcePositions pos = Trees.instance(this.task).getSourcePositions();
        int start = (int)pos.getStartPosition(this.root, t);
        int end = (int)pos.getEndPosition(this.root, t);
        if (start == -1 || end == -1) {
            return false;
        }
        start = FindHelper.findNameIn(this.root, name, start, end);
        end = start + name.length();
        if (start == -1 || end == -1) {
            return false;
        }
        return (long)start <= find && find < (long)end;
    }
}

