/*
 * Decompiled with CFR 0.152.
 */
package org.javacs;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreeScanner;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class FindTypeDeclarationNamed
extends TreeScanner<ClassTree, String> {
    private List<CharSequence> qualifiedName = new ArrayList<CharSequence>();

    FindTypeDeclarationNamed() {
    }

    @Override
    public ClassTree visitCompilationUnit(CompilationUnitTree t, String find) {
        String name = Objects.toString(t.getPackageName(), "");
        this.qualifiedName.add(name);
        return (ClassTree)super.visitCompilationUnit(t, find);
    }

    @Override
    public ClassTree visitClass(ClassTree t, String find) {
        this.qualifiedName.add(t.getSimpleName());
        if (String.join((CharSequence)".", this.qualifiedName).equals(find)) {
            return t;
        }
        ClassTree recurse = (ClassTree)super.visitClass(t, find);
        this.qualifiedName.remove(this.qualifiedName.size() - 1);
        return recurse;
    }

    @Override
    public ClassTree reduce(ClassTree a, ClassTree b) {
        if (a != null) {
            return a;
        }
        return b;
    }
}

