/*
 * Decompiled with CFR 0.152.
 */
package org.javacs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

class JavaHomeHelper {
    static final Path NOT_FOUND = Paths.get("", new String[0]);

    JavaHomeHelper() {
    }

    static Path javaHome() {
        String fromEnv = System.getenv("JAVA_HOME");
        if (fromEnv != null) {
            return Paths.get(fromEnv, new String[0]);
        }
        String osName = System.getProperty("os.name");
        if (JavaHomeHelper.isWindows(osName)) {
            return JavaHomeHelper.windowsJavaHome();
        }
        if (JavaHomeHelper.isMac(osName)) {
            return JavaHomeHelper.macJavaHome();
        }
        if (JavaHomeHelper.isLinux(osName)) {
            return JavaHomeHelper.linuxJavaHome();
        }
        throw new RuntimeException("Unrecognized os.name " + osName);
    }

    private static Path windowsJavaHome() {
        for (File root : File.listRoots()) {
            String x64 = root.toPath().resolve("Program Files/Java").toString();
            String x86 = root.toPath().resolve("Program Files (x86)/Java").toString();
            Path found = JavaHomeHelper.check(x64, x86);
            if (found == NOT_FOUND) continue;
            return found;
        }
        return NOT_FOUND;
    }

    private static Path macJavaHome() {
        if (Files.isExecutable(Paths.get("/usr/libexec/java_home", new String[0]))) {
            return JavaHomeHelper.execJavaHome();
        }
        String[] homes = new String[]{"/Library/Java/JavaVirtualMachines/Home", "/System/Library/Java/JavaVirtualMachines/Home", "/Library/Java/JavaVirtualMachines/Contents/Home", "/System/Library/Java/JavaVirtualMachines/Contents/Home"};
        return JavaHomeHelper.check(homes);
    }

    private static Path linuxJavaHome() {
        String[] homes = new String[]{"/usr/java", "/opt/java", "/usr/lib/jvm"};
        return JavaHomeHelper.check(homes);
    }

    private static Path execJavaHome() {
        try {
            Process process = new ProcessBuilder(new String[0]).command("/usr/libexec/java_home").start();
            BufferedReader out = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = out.readLine();
            process.waitFor(5L, TimeUnit.SECONDS);
            return Paths.get(line, new String[0]);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static Path check(String ... roots) {
        for (String root : roots) {
            List list;
            try {
                list = Files.list(Paths.get(root, new String[0])).collect(Collectors.toList());
            }
            catch (NoSuchFileException e) {
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (Path jdk : list) {
                if (!Files.exists(jdk.resolve("bin/javac"), new LinkOption[0]) && !Files.exists(jdk.resolve("bin/javac.exe"), new LinkOption[0])) continue;
                return jdk;
            }
        }
        return NOT_FOUND;
    }

    private static boolean isWindows(String osName) {
        return osName.toLowerCase().startsWith("windows");
    }

    private static boolean isMac(String osName) {
        return osName.toLowerCase().startsWith("mac");
    }

    private static boolean isLinux(String osName) {
        return osName.toLowerCase().startsWith("linux");
    }
}

