/*
 * Decompiled with CFR 0.152.
 */
package org.javacs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.javacs.CompileTask;
import org.javacs.FileStore;
import org.javacs.InferConfig;
import org.javacs.JavaCompilerService;
import org.javacs.JsonHelper;
import org.javacs.action.CodeActionProvider;
import org.javacs.completion.CompletionProvider;
import org.javacs.completion.SignatureProvider;
import org.javacs.hover.HoverProvider;
import org.javacs.lsp.CodeAction;
import org.javacs.lsp.CodeActionParams;
import org.javacs.lsp.CompletionItem;
import org.javacs.lsp.CompletionList;
import org.javacs.lsp.DidChangeConfigurationParams;
import org.javacs.lsp.DidChangeTextDocumentParams;
import org.javacs.lsp.DidCloseTextDocumentParams;
import org.javacs.lsp.DidOpenTextDocumentParams;
import org.javacs.lsp.DidSaveTextDocumentParams;
import org.javacs.lsp.Hover;
import org.javacs.lsp.InitializeParams;
import org.javacs.lsp.InitializeResult;
import org.javacs.lsp.JavaReportProgressParams;
import org.javacs.lsp.JavaStartProgressParams;
import org.javacs.lsp.LanguageClient;
import org.javacs.lsp.LanguageServer;
import org.javacs.lsp.MarkedString;
import org.javacs.lsp.PublishDiagnosticsParams;
import org.javacs.lsp.SignatureHelp;
import org.javacs.lsp.TextDocumentPositionParams;
import org.javacs.markup.ErrorProvider;

public class JavaLanguageServer
extends LanguageServer {
    private Path workspaceRoot;
    private final LanguageClient client;
    private JavaCompilerService cacheCompiler;
    private JsonObject cacheSettings;
    private JsonObject settings = new JsonObject();
    private boolean modifiedBuild = true;
    private static final String[] watchFiles = new String[]{"**/*.java", "**/pom.xml"};
    private boolean uncheckedChanges = false;
    private Path lastEdited = Paths.get("", new String[0]);
    private static final Logger LOG = Logger.getLogger("main");

    JavaCompilerService compiler() {
        if (this.needsCompiler()) {
            this.cacheCompiler = this.createCompiler();
            this.cacheSettings = this.settings;
            this.modifiedBuild = false;
        }
        return this.cacheCompiler;
    }

    private boolean needsCompiler() {
        if (this.modifiedBuild) {
            return true;
        }
        if (!this.settings.equals((Object)this.cacheSettings)) {
            LOG.info("Settings\n\t" + String.valueOf(this.settings) + "\nis different than\n\t" + String.valueOf(this.cacheSettings));
            return true;
        }
        return false;
    }

    void lint(Collection<Path> files) {
        if (files.isEmpty()) {
            return;
        }
        LOG.info("Lint " + files.size() + " files...");
        try (CompileTask task = this.compiler().compile((Path[])files.toArray(Path[]::new));){
            for (PublishDiagnosticsParams errs : new ErrorProvider(task).errors()) {
                this.client.publishDiagnostics(errs);
            }
            LOG.info("... published");
        }
    }

    void singleLint(Path file) {
        LOG.info("Lint - single file ...");
        try (CompileTask task = this.compiler().compile(file);){
            for (PublishDiagnosticsParams errs : new ErrorProvider(task).errors()) {
                this.client.publishDiagnostics(errs);
            }
        }
    }

    private void javaStartProgress(JavaStartProgressParams params) {
        this.client.customNotification("java/startProgress", JsonHelper.GSON.toJsonTree((Object)params));
    }

    private void javaReportProgress(JavaReportProgressParams params) {
        this.client.customNotification("java/reportProgress", JsonHelper.GSON.toJsonTree((Object)params));
    }

    private void javaEndProgress() {
        this.client.customNotification("java/endProgress", (JsonElement)JsonNull.INSTANCE);
    }

    private JavaCompilerService createCompiler() {
        Objects.requireNonNull(this.workspaceRoot, "Can't create compiler because workspaceRoot has not been initialized");
        this.javaStartProgress(new JavaStartProgressParams("Configure javac"));
        this.javaReportProgress(new JavaReportProgressParams("Finding source roots"));
        Set<String> externalDependencies = this.externalDependencies();
        Set<Path> classPath = this.classPath();
        Set<String> addExports = this.addExports();
        if (!classPath.isEmpty()) {
            this.javaEndProgress();
            return new JavaCompilerService(classPath, this.docPath(), addExports);
        }
        InferConfig infer = new InferConfig(this.workspaceRoot, externalDependencies);
        this.javaReportProgress(new JavaReportProgressParams("Inferring class path"));
        classPath = infer.classPath();
        this.javaReportProgress(new JavaReportProgressParams("Inferring doc path"));
        Set<Path> docPath = infer.buildDocPath();
        this.javaEndProgress();
        return new JavaCompilerService(classPath, docPath, addExports);
    }

    private Set<String> externalDependencies() {
        if (!this.settings.has("externalDependencies")) {
            return Set.of();
        }
        JsonArray array = this.settings.getAsJsonArray("externalDependencies");
        HashSet<String> strings = new HashSet<String>();
        for (JsonElement each : array) {
            strings.add(each.getAsString());
        }
        return strings;
    }

    private Set<Path> classPath() {
        if (!this.settings.has("classPath")) {
            return Set.of();
        }
        JsonArray array = this.settings.getAsJsonArray("classPath");
        HashSet<Path> paths = new HashSet<Path>();
        for (JsonElement each : array) {
            paths.add(Paths.get(each.getAsString(), new String[0]).toAbsolutePath());
        }
        return paths;
    }

    private Set<Path> docPath() {
        if (!this.settings.has("docPath")) {
            return Set.of();
        }
        JsonArray array = this.settings.getAsJsonArray("docPath");
        HashSet<Path> paths = new HashSet<Path>();
        for (JsonElement each : array) {
            paths.add(Paths.get(each.getAsString(), new String[0]).toAbsolutePath());
        }
        return paths;
    }

    private Set<String> addExports() {
        if (!this.settings.has("addExports")) {
            return Set.of();
        }
        JsonArray array = this.settings.getAsJsonArray("addExports");
        HashSet<String> strings = new HashSet<String>();
        for (JsonElement each : array) {
            strings.add(each.getAsString());
        }
        return strings;
    }

    @Override
    public InitializeResult initialize(InitializeParams params) {
        this.workspaceRoot = Paths.get(params.rootUri);
        FileStore.setWorkspaceRoots(Set.of(Paths.get(params.rootUri)));
        JsonObject c = new JsonObject();
        c.addProperty("textDocumentSync", (Number)2);
        c.addProperty("hoverProvider", Boolean.valueOf(true));
        JsonObject completionOptions = new JsonObject();
        completionOptions.addProperty("resolveProvider", Boolean.valueOf(true));
        JsonArray triggerCharacters = new JsonArray();
        triggerCharacters.add(".");
        completionOptions.add("triggerCharacters", (JsonElement)triggerCharacters);
        c.add("completionProvider", (JsonElement)completionOptions);
        JsonObject signatureHelpOptions = new JsonObject();
        JsonArray signatureTrigger = new JsonArray();
        signatureTrigger.add("(");
        signatureTrigger.add(",");
        signatureHelpOptions.add("triggerCharacters", (JsonElement)signatureTrigger);
        c.add("signatureHelpProvider", (JsonElement)signatureHelpOptions);
        JsonObject renameOptions = new JsonObject();
        renameOptions.addProperty("prepareProvider", Boolean.valueOf(true));
        c.add("renameProvider", (JsonElement)renameOptions);
        return new InitializeResult(c);
    }

    @Override
    public void initialized() {
        this.client.registerCapability("workspace/didChangeWatchedFiles", (JsonElement)this.watchFiles(watchFiles));
    }

    private JsonObject watchFiles(String ... globPatterns) {
        JsonObject options = new JsonObject();
        JsonArray watchers = new JsonArray();
        for (String p : globPatterns) {
            JsonObject config = new JsonObject();
            config.addProperty("globPattern", p);
            watchers.add((JsonElement)config);
        }
        options.add("watchers", (JsonElement)watchers);
        return options;
    }

    @Override
    public void shutdown() {
    }

    public JavaLanguageServer(LanguageClient client) {
        this.client = client;
    }

    @Override
    public void didChangeConfiguration(DidChangeConfigurationParams change) {
        JsonElement java = change.settings.getAsJsonObject().get("java");
        LOG.info("Received java settings " + String.valueOf(java));
        this.settings = java.getAsJsonObject();
    }

    @Override
    public Optional<CompletionList> completion(TextDocumentPositionParams params) {
        if (!FileStore.isJavaFile(params.textDocument.uri)) {
            return Optional.empty();
        }
        Path file = Paths.get(params.textDocument.uri);
        CompletionProvider provider = new CompletionProvider(this.compiler());
        CompletionList list = provider.complete(file, params.position.line + 1, params.position.character + 1);
        if (list == CompletionProvider.NOT_SUPPORTED) {
            return Optional.empty();
        }
        return Optional.of(list);
    }

    @Override
    public CompletionItem resolveCompletionItem(CompletionItem unresolved) {
        new HoverProvider(this.compiler()).resolveCompletionItem(unresolved);
        return unresolved;
    }

    @Override
    public Optional<Hover> hover(TextDocumentPositionParams position) {
        URI uri = position.textDocument.uri;
        int line = position.position.line + 1;
        int column = position.position.character + 1;
        if (!FileStore.isJavaFile(uri)) {
            return Optional.empty();
        }
        Path file = Paths.get(uri);
        List<MarkedString> list = new HoverProvider(this.compiler()).hover(file, line, column);
        if (list == HoverProvider.NOT_SUPPORTED) {
            return Optional.empty();
        }
        return Optional.of(new Hover(list));
    }

    @Override
    public Optional<SignatureHelp> signatureHelp(TextDocumentPositionParams params) {
        if (!FileStore.isJavaFile(params.textDocument.uri)) {
            return Optional.empty();
        }
        Path file = Paths.get(params.textDocument.uri);
        int line = params.position.line + 1;
        int column = params.position.character + 1;
        SignatureHelp help = new SignatureProvider(this.compiler()).signatureHelp(file, line, column);
        if (help == SignatureProvider.NOT_SUPPORTED) {
            return Optional.empty();
        }
        return Optional.of(help);
    }

    @Override
    public void didOpenTextDocument(DidOpenTextDocumentParams params) {
        FileStore.open(params);
        if (!FileStore.isJavaFile(params.textDocument.uri)) {
            return;
        }
        this.lastEdited = Paths.get(params.textDocument.uri);
        this.uncheckedChanges = true;
    }

    @Override
    public void didChangeTextDocument(DidChangeTextDocumentParams params) {
        FileStore.change(params);
        this.lastEdited = Paths.get(params.textDocument.uri);
        this.uncheckedChanges = true;
    }

    @Override
    public void didCloseTextDocument(DidCloseTextDocumentParams params) {
        FileStore.close(params);
        if (FileStore.isJavaFile(params.textDocument.uri)) {
            this.client.publishDiagnostics(new PublishDiagnosticsParams(params.textDocument.uri, List.of()));
        }
    }

    @Override
    public List<CodeAction> codeAction(CodeActionParams params) {
        CodeActionProvider provider = new CodeActionProvider(this.compiler());
        if (params.context.diagnostics.isEmpty()) {
            return provider.codeActionsForCursor(params);
        }
        return provider.codeActionForDiagnostics(params);
    }

    @Override
    public void didSaveTextDocument(DidSaveTextDocumentParams params) {
        if (FileStore.isJavaFile(params.textDocument.uri)) {
            this.lint(FileStore.activeDocuments());
        }
    }

    @Override
    public void doAsyncWork() {
        if (this.uncheckedChanges && FileStore.activeDocuments().contains(this.lastEdited)) {
            this.singleLint(this.lastEdited);
            this.uncheckedChanges = false;
        }
    }
}

