/*
 * Decompiled with CFR 0.152.
 */
package org.javacs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormat
extends Formatter {
    private final String format = "%1$tT.%1$tL\t%4$s\t%2$s\t%5$s%6$s%n";
    private final Date date = new Date();

    @Override
    public synchronized String format(LogRecord record) {
        Object source;
        this.date.setTime(record.getMillis());
        if (record.getSourceClassName() != null) {
            source = this.last(record.getSourceClassName());
            if (record.getSourceMethodName() != null) {
                source = (String)source + " " + record.getSourceMethodName();
            }
        } else {
            source = record.getLoggerName();
        }
        String message = this.formatMessage(record);
        String throwable = "";
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println();
            record.getThrown().printStackTrace(pw);
            pw.close();
            throwable = sw.toString();
        }
        return String.format("%1$tT.%1$tL\t%4$s\t%2$s\t%5$s%6$s%n", this.date, source, record.getLoggerName(), record.getLevel().getLocalizedName(), message, throwable);
    }

    private String last(String className) {
        int dot = className.lastIndexOf(46);
        if (dot == -1) {
            return className;
        }
        return className.substring(dot + 1);
    }
}

