/*
 * Decompiled with CFR 0.152.
 */
package org.javacs;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.javacs.guava.ClassPath;

class ScanClassPath {
    static String[] JDK_MODULES = new String[]{"java.activation", "java.base", "java.compiler", "java.corba", "java.datatransfer", "java.desktop", "java.instrument", "java.jnlp", "java.logging", "java.management", "java.management.rmi", "java.naming", "java.net.http", "java.prefs", "java.rmi", "java.scripting", "java.se", "java.se.ee", "java.security.jgss", "java.security.sasl", "java.smartcardio", "java.sql", "java.sql.rowset", "java.transaction", "java.transaction.xa", "java.xml", "java.xml.bind", "java.xml.crypto", "java.xml.ws", "java.xml.ws.annotation", "javafx.base", "javafx.controls", "javafx.fxml", "javafx.graphics", "javafx.media", "javafx.swing", "javafx.web", "jdk.accessibility", "jdk.aot", "jdk.attach", "jdk.charsets", "jdk.compiler", "jdk.crypto.cryptoki", "jdk.crypto.ec", "jdk.dynalink", "jdk.editpad", "jdk.hotspot.agent", "jdk.httpserver", "jdk.incubator.httpclient", "jdk.internal.ed", "jdk.internal.jvmstat", "jdk.internal.le", "jdk.internal.opt", "jdk.internal.vm.ci", "jdk.internal.vm.compiler", "jdk.internal.vm.compiler.management", "jdk.jartool", "jdk.javadoc", "jdk.jcmd", "jdk.jconsole", "jdk.jdeps", "jdk.jdi", "jdk.jdwp.agent", "jdk.jfr", "jdk.jlink", "jdk.jshell", "jdk.jsobject", "jdk.jstatd", "jdk.localedata", "jdk.management", "jdk.management.agent", "jdk.management.cmm", "jdk.management.jfr", "jdk.management.resource", "jdk.naming.dns", "jdk.naming.rmi", "jdk.net", "jdk.pack", "jdk.packager.services", "jdk.rmic", "jdk.scripting.nashorn", "jdk.scripting.nashorn.shell", "jdk.sctp", "jdk.security.auth", "jdk.security.jgss", "jdk.snmp", "jdk.unsupported", "jdk.unsupported.desktop", "jdk.xml.dom", "jdk.zipfs"};
    private static final Logger LOG = Logger.getLogger("main");

    ScanClassPath() {
    }

    static Set<String> jdkTopLevelClasses() {
        LOG.info("Searching for top-level classes in the JDK");
        HashSet<String> classes = new HashSet<String>();
        FileSystem fs = FileSystems.getFileSystem(URI.create("jrt:/"));
        for (String m : JDK_MODULES) {
            Path moduleRoot = fs.getPath(String.format("/modules/%s/", m), new String[0]);
            try (Stream<Path> stream = Files.walk(moduleRoot, new FileVisitOption[0]);){
                Iterator it = stream.iterator();
                while (it.hasNext()) {
                    Path classFile = (Path)it.next();
                    String relative = moduleRoot.relativize(classFile).toString();
                    if (!relative.endsWith(".class") || relative.contains("$")) continue;
                    String trim = relative.substring(0, relative.length() - ".class".length());
                    String qualifiedName = trim.replace(File.separatorChar, '.');
                    classes.add(qualifiedName);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        LOG.info(String.format("Found %d classes in the java platform", classes.size()));
        return classes;
    }

    static Set<String> classPathTopLevelClasses(Set<Path> classPath) {
        ClassPath scanner;
        LOG.info(String.format("Searching for top-level classes in %d classpath locations", classPath.size()));
        URL[] urls = (URL[])classPath.stream().map(ScanClassPath::toUrl).toArray(URL[]::new);
        URLClassLoader classLoader = new URLClassLoader(urls, null);
        try {
            scanner = ClassPath.from(classLoader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashSet<String> classes = new HashSet<String>();
        for (ClassPath.ClassInfo c : scanner.getTopLevelClasses()) {
            classes.add(c.getName());
        }
        LOG.info(String.format("Found %d classes in classpath", classes.size()));
        return classes;
    }

    private static URL toUrl(Path p) {
        try {
            return p.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

