/*
 * Decompiled with CFR 0.152.
 */
package org.javacs;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.TypeElement;
import org.javacs.Cache;
import org.javacs.FileStore;

public class StringSearch {
    private final byte[] pattern;
    private final int[] badCharSkip = new int[256];
    private final int[] goodSuffixSkip;
    private static final ByteBuffer SEARCH_BUFFER = ByteBuffer.allocateDirect(0x100000);
    private static Cache<String, Boolean> cacheContainsClass = new Cache();
    private static Cache<String, Boolean> cacheContainsInterface = new Cache();
    private static final Logger LOG = Logger.getLogger("main");

    StringSearch(String patternSting) {
        int i;
        this.pattern = patternSting.getBytes();
        this.goodSuffixSkip = new int[this.pattern.length];
        int last = this.pattern.length - 1;
        Arrays.fill(this.badCharSkip, this.pattern.length);
        for (int i2 = 0; i2 < last; ++i2) {
            this.badCharSkip[this.pattern[i2] + 128] = last - i2;
        }
        int lastPrefix = last;
        for (i = last; i >= 0; --i) {
            if (this.hasPrefix(this.pattern, new Slice(this.pattern, i + 1))) {
                lastPrefix = i + 1;
            }
            this.goodSuffixSkip[i] = lastPrefix + last - i;
        }
        for (i = 0; i < last; ++i) {
            int lenSuffix = this.longestCommonSuffix(this.pattern, new Slice(this.pattern, 1, i + 1));
            if (this.pattern[i - lenSuffix] == this.pattern[last - lenSuffix]) continue;
            this.goodSuffixSkip[last - lenSuffix] = lenSuffix + last - i;
        }
    }

    int next(String text) {
        return this.next(text.getBytes());
    }

    private int next(byte[] text) {
        return this.next(ByteBuffer.wrap(text));
    }

    private int next(ByteBuffer text) {
        return this.next(text, 0);
    }

    private int next(ByteBuffer text, int startingAfter) {
        int j;
        for (int i = startingAfter + this.pattern.length - 1; i < text.limit(); i += Math.max(this.badCharSkip[text.get(i) + 128], this.goodSuffixSkip[j])) {
            for (j = this.pattern.length - 1; j >= 0 && text.get(i) == this.pattern[j]; --j) {
                --i;
            }
            if (j >= 0) continue;
            return i + 1;
        }
        return -1;
    }

    private boolean isWordChar(byte b) {
        char c = (char)(b + 128);
        return Character.isAlphabetic(c) || Character.isDigit(c) || c == '$' || c == '_';
    }

    private boolean startsWord(ByteBuffer text, int offset) {
        if (offset == 0) {
            return true;
        }
        return !this.isWordChar(text.get(offset - 1));
    }

    private boolean endsWord(ByteBuffer text, int offset) {
        if (offset + 1 >= text.limit()) {
            return true;
        }
        return !this.isWordChar(text.get(offset + 1));
    }

    private boolean isWord(ByteBuffer text, int offset) {
        return this.startsWord(text, offset) && this.endsWord(text, offset + this.pattern.length - 1);
    }

    int nextWord(String text) {
        return this.nextWord(text.getBytes());
    }

    private int nextWord(byte[] text) {
        return this.nextWord(ByteBuffer.wrap(text));
    }

    private int nextWord(ByteBuffer text) {
        int i = 0;
        while ((i = this.next(text, i)) != -1) {
            if (this.isWord(text, i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean hasPrefix(byte[] s, Slice prefix) {
        for (int i = 0; i < prefix.length(); ++i) {
            if (s[i] == prefix.get(i)) continue;
            return false;
        }
        return true;
    }

    private int longestCommonSuffix(byte[] a, Slice b) {
        int i;
        for (i = 0; i < a.length && i < b.length() && a[a.length - 1 - i] == b.get(b.length() - 1 - i); ++i) {
        }
        return i;
    }

    static boolean containsWordMatching(Path java, String query) {
        boolean bl;
        block10: {
            if (FileStore.activeDocuments().contains(java)) {
                String text = FileStore.contents(java);
                return StringSearch.matchesTitleCase(text, query);
            }
            FileChannel channel = FileChannel.open(java, new OpenOption[0]);
            try {
                int limit = Math.min((int)channel.size(), SEARCH_BUFFER.capacity());
                SEARCH_BUFFER.position(0);
                SEARCH_BUFFER.limit(limit);
                channel.read(SEARCH_BUFFER);
                SEARCH_BUFFER.position(0);
                CharBuffer chars = StandardCharsets.UTF_8.decode(SEARCH_BUFFER);
                bl = StringSearch.matchesTitleCase(chars, query);
                if (channel == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    LOG.warning(e.getMessage());
                    return false;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            channel.close();
        }
        return bl;
    }

    static boolean containsWord(Path java, String query) {
        boolean bl;
        block10: {
            StringSearch search = new StringSearch(query);
            if (FileStore.activeDocuments().contains(java)) {
                byte[] text = FileStore.contents(java).getBytes();
                return search.nextWord(text) != -1;
            }
            FileChannel channel = FileChannel.open(java, new OpenOption[0]);
            try {
                int limit = Math.min((int)channel.size(), SEARCH_BUFFER.capacity());
                SEARCH_BUFFER.position(0);
                SEARCH_BUFFER.limit(limit);
                channel.read(SEARCH_BUFFER);
                SEARCH_BUFFER.position(0);
                boolean bl2 = bl = search.nextWord(SEARCH_BUFFER) != -1;
                if (channel == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    LOG.warning(e.getMessage());
                    return false;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            channel.close();
        }
        return bl;
    }

    private static boolean containsString(Path java, String query) {
        boolean bl;
        block10: {
            StringSearch search = new StringSearch(query);
            if (FileStore.activeDocuments().contains(java)) {
                byte[] text = FileStore.contents(java).getBytes();
                return search.next(text) != -1;
            }
            FileChannel channel = FileChannel.open(java, new OpenOption[0]);
            try {
                int limit = Math.min((int)channel.size(), SEARCH_BUFFER.capacity());
                SEARCH_BUFFER.position(0);
                SEARCH_BUFFER.limit(limit);
                channel.read(SEARCH_BUFFER);
                SEARCH_BUFFER.position(0);
                boolean bl2 = bl = search.next(SEARCH_BUFFER) != -1;
                if (channel == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    LOG.warning(e.getMessage());
                    return false;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            channel.close();
        }
        return bl;
    }

    public static boolean matchesTitleCase(CharSequence candidate, String find) {
        Objects.requireNonNull(candidate, "candidate is null");
        int i = 0;
        block0: while (i < candidate.length()) {
            i = StringSearch.startOfToken(candidate, i);
            for (char f : find.toCharArray()) {
                if (i >= candidate.length()) {
                    return false;
                }
                if (Character.toLowerCase(f) == Character.toLowerCase(candidate.charAt(i))) {
                    ++i;
                    continue;
                }
                while (i < candidate.length()) {
                    boolean isMatch;
                    char c = candidate.charAt(i);
                    if (!StringSearch.isWordChar(c)) continue block0;
                    boolean isStartOfWord = Character.isUpperCase(c);
                    boolean bl = isMatch = Character.toLowerCase(f) == Character.toLowerCase(c);
                    if (isStartOfWord && isMatch) {
                        ++i;
                        break;
                    }
                    ++i;
                }
                if (i < candidate.length()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static int startOfToken(CharSequence candidate, int offset) {
        char c;
        while (offset < candidate.length() && !StringSearch.isWordChar(c = candidate.charAt(offset))) {
            ++offset;
        }
        return offset;
    }

    private static boolean isWordChar(char c) {
        return Character.isAlphabetic(c) || Character.isDigit(c) || c == '_' || c == '$';
    }

    static boolean containsType(Path file, TypeElement el) {
        switch (el.getKind()) {
            case INTERFACE: {
                return StringSearch.containsInterface(file, el.getSimpleName().toString());
            }
            case CLASS: {
                return StringSearch.containsClass(file, el.getSimpleName().toString());
            }
        }
        throw new RuntimeException("Don't know what to do with " + String.valueOf((Object)el.getKind()));
    }

    private static boolean containsClass(Path file, String simpleName) {
        if (cacheContainsClass.needs(file, simpleName)) {
            cacheContainsClass.load(file, simpleName, StringSearch.containsString(file, "class " + simpleName));
        }
        return cacheContainsClass.get(file, simpleName);
    }

    private static boolean containsInterface(Path file, String simpleName) {
        if (cacheContainsInterface.needs(file, simpleName)) {
            cacheContainsInterface.load(file, simpleName, StringSearch.containsString(file, "interface " + simpleName));
        }
        return cacheContainsInterface.get(file, simpleName);
    }

    static String mostName(String name) {
        int lastDot = name.lastIndexOf(46);
        return lastDot == -1 ? "" : name.substring(0, lastDot);
    }

    static String lastName(String name) {
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return name;
        }
        return name.substring(i + 1);
    }

    static String fileName(URI uri) {
        String[] parts = uri.toString().split("/");
        if (parts.length == 0) {
            return "";
        }
        return parts[parts.length - 1];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String packageName(Path file) {
        Pattern packagePattern = Pattern.compile("^package +(.*);");
        Pattern startOfClass = Pattern.compile("^[\\w ]*class +\\w+");
        try (BufferedReader lines = FileStore.lines(file);){
            String line = lines.readLine();
            while (line != null) {
                if (startOfClass.matcher(line).find()) {
                    String string = "";
                    return string;
                }
                Matcher matchPackage = packagePattern.matcher(line);
                if (matchPackage.matches()) {
                    String id;
                    String string = id = matchPackage.group(1);
                    return string;
                }
                line = lines.readLine();
            }
            return "";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean matchesPartialName(CharSequence candidate, CharSequence partialName) {
        if (candidate.length() < partialName.length()) {
            return false;
        }
        for (int i = 0; i < partialName.length(); ++i) {
            if (candidate.charAt(i) == partialName.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static class Slice {
        private final byte[] target;
        private int from;
        private int until;

        int length() {
            return this.until - this.from;
        }

        byte get(int i) {
            return this.target[this.from + i];
        }

        Slice(byte[] target, int from) {
            this(target, from, target.length);
        }

        Slice(byte[] target, int from, int until) {
            this.target = target;
            this.from = from;
            this.until = until;
        }
    }
}

