/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.completion;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTrees;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.tools.JavaFileObject;
import org.javacs.CompileTask;
import org.javacs.CompilerProvider;
import org.javacs.FindHelper;
import org.javacs.MarkdownHelper;
import org.javacs.ParseTask;
import org.javacs.completion.FindInvocationAt;
import org.javacs.completion.ScopeHelper;
import org.javacs.hover.ShortTypePrinter;
import org.javacs.lsp.ParameterInformation;
import org.javacs.lsp.SignatureHelp;
import org.javacs.lsp.SignatureInformation;

public class SignatureProvider {
    private final CompilerProvider compiler;
    public static final SignatureHelp NOT_SUPPORTED = new SignatureHelp(List.of(), -1, -1);

    public SignatureProvider(CompilerProvider compiler) {
        this.compiler = compiler;
    }

    public SignatureHelp signatureHelp(Path file, int line, int column) {
        try (CompileTask task = this.compiler.compile(file);){
            long cursor = task.root().getLineMap().getPosition(line, column);
            TreePath path = (TreePath)new FindInvocationAt(task.task).scan(task.root(), Long.valueOf(cursor));
            if (path == null) {
                SignatureHelp signatureHelp = NOT_SUPPORTED;
                return signatureHelp;
            }
            if (path.getLeaf() instanceof MethodInvocationTree) {
                Object info;
                MethodInvocationTree invoke = (MethodInvocationTree)path.getLeaf();
                List<ExecutableElement> overloads = this.methodOverloads(task, invoke);
                ArrayList<SignatureInformation> signatures = new ArrayList<SignatureInformation>();
                for (ExecutableElement method : overloads) {
                    info = this.info(method);
                    this.addSourceInfo(task, method, (SignatureInformation)info);
                    this.addFancyLabel((SignatureInformation)info);
                    signatures.add((SignatureInformation)info);
                }
                int activeSignature = this.activeSignature(task, path, invoke.getArguments(), overloads);
                int activeParameter = this.activeParameter(task, invoke.getArguments(), cursor);
                info = new SignatureHelp(signatures, activeSignature, activeParameter);
                return info;
            }
            if (path.getLeaf() instanceof NewClassTree) {
                NewClassTree invoke = (NewClassTree)path.getLeaf();
                List<ExecutableElement> overloads = this.constructorOverloads(task, invoke);
                ArrayList<SignatureInformation> signatures = new ArrayList<SignatureInformation>();
                for (ExecutableElement method : overloads) {
                    SignatureInformation info = this.info(method);
                    this.addSourceInfo(task, method, info);
                    this.addFancyLabel(info);
                    signatures.add(info);
                }
                int activeSignature = this.activeSignature(task, path, invoke.getArguments(), overloads);
                int activeParameter = this.activeParameter(task, invoke.getArguments(), cursor);
                SignatureHelp signatureHelp = new SignatureHelp(signatures, activeSignature, activeParameter);
                return signatureHelp;
            }
            SignatureHelp signatureHelp = NOT_SUPPORTED;
            return signatureHelp;
        }
    }

    private List<ExecutableElement> methodOverloads(CompileTask task, MethodInvocationTree method) {
        if (method.getMethodSelect() instanceof IdentifierTree) {
            IdentifierTree id = (IdentifierTree)method.getMethodSelect();
            return this.scopeOverloads(task, id);
        }
        if (method.getMethodSelect() instanceof MemberSelectTree) {
            MemberSelectTree select = (MemberSelectTree)method.getMethodSelect();
            return this.memberOverloads(task, select);
        }
        throw new RuntimeException(method.getMethodSelect().toString());
    }

    private List<ExecutableElement> scopeOverloads(CompileTask task, IdentifierTree method) {
        Trees trees = Trees.instance(task.task);
        TreePath path = trees.getPath(task.root(), method);
        Scope scope = trees.getScope(path);
        ArrayList<ExecutableElement> list = new ArrayList<ExecutableElement>();
        Predicate<CharSequence> filter = name -> method.getName().contentEquals((CharSequence)name);
        for (Element member : ScopeHelper.scopeMembers(task, scope, filter)) {
            if (member.getKind() != ElementKind.METHOD) continue;
            list.add((ExecutableElement)member);
        }
        return list;
    }

    private List<ExecutableElement> memberOverloads(CompileTask task, MemberSelectTree method) {
        Trees trees = Trees.instance(task.task);
        TreePath path = trees.getPath(task.root(), method.getExpression());
        boolean isStatic = trees.getElement(path) instanceof TypeElement;
        Scope scope = trees.getScope(path);
        TypeElement type = this.typeElement(trees.getTypeMirror(path));
        if (type == null) {
            return List.of();
        }
        ArrayList<ExecutableElement> list = new ArrayList<ExecutableElement>();
        for (Element element : task.task.getElements().getAllMembers(type)) {
            if (element.getKind() != ElementKind.METHOD || !element.getSimpleName().contentEquals(method.getIdentifier()) || isStatic != element.getModifiers().contains((Object)Modifier.STATIC) || !trees.isAccessible(scope, element, (DeclaredType)type.asType())) continue;
            list.add((ExecutableElement)element);
        }
        return list;
    }

    private TypeElement typeElement(TypeMirror type) {
        if (type instanceof DeclaredType) {
            DeclaredType declared = (DeclaredType)type;
            return (TypeElement)declared.asElement();
        }
        if (type instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type;
            return this.typeElement(variable.getUpperBound());
        }
        return null;
    }

    private List<ExecutableElement> constructorOverloads(CompileTask task, NewClassTree method) {
        Trees trees = Trees.instance(task.task);
        TreePath path = trees.getPath(task.root(), method.getIdentifier());
        Scope scope = trees.getScope(path);
        TypeElement type = (TypeElement)trees.getElement(path);
        ArrayList<ExecutableElement> list = new ArrayList<ExecutableElement>();
        for (Element element : task.task.getElements().getAllMembers(type)) {
            if (element.getKind() != ElementKind.CONSTRUCTOR || !trees.isAccessible(scope, element, (DeclaredType)type.asType())) continue;
            list.add((ExecutableElement)element);
        }
        return list;
    }

    private SignatureInformation info(ExecutableElement method) {
        SignatureInformation info = new SignatureInformation();
        info.label = method.getSimpleName().toString();
        if (method.getKind() == ElementKind.CONSTRUCTOR) {
            info.label = method.getEnclosingElement().getSimpleName().toString();
        }
        info.parameters = this.parameters(method);
        return info;
    }

    private List<ParameterInformation> parameters(ExecutableElement method) {
        ArrayList<ParameterInformation> list = new ArrayList<ParameterInformation>();
        for (VariableElement variableElement : method.getParameters()) {
            list.add(this.parameter(variableElement));
        }
        return list;
    }

    private ParameterInformation parameter(VariableElement p) {
        ParameterInformation info = new ParameterInformation();
        info.label = ShortTypePrinter.NO_PACKAGE.print(p.asType());
        return info;
    }

    private void addSourceInfo(CompileTask task, ExecutableElement method, SignatureInformation info) {
        TypeElement type = (TypeElement)method.getEnclosingElement();
        String className = type.getQualifiedName().toString();
        String methodName = method.getSimpleName().toString();
        String[] erasedParameterTypes = FindHelper.erasedParameterTypes(task, method);
        Optional<JavaFileObject> file = this.compiler.findAnywhere(className);
        if (file.isEmpty()) {
            return;
        }
        ParseTask parse = this.compiler.parse(file.get());
        MethodTree source = FindHelper.findMethod(parse, className, methodName, erasedParameterTypes);
        TreePath path = Trees.instance(task.task).getPath(parse.root, source);
        DocCommentTree docTree = DocTrees.instance(task.task).getDocCommentTree(path);
        if (docTree != null) {
            info.documentation = MarkdownHelper.asMarkupContent(docTree);
        }
        info.parameters = this.parametersFromSource(source);
    }

    private void addFancyLabel(SignatureInformation info) {
        StringJoiner join = new StringJoiner(", ");
        for (ParameterInformation p : info.parameters) {
            join.add(p.label);
        }
        info.label = info.label + "(" + String.valueOf(join) + ")";
    }

    private List<ParameterInformation> parametersFromSource(MethodTree source) {
        ArrayList<ParameterInformation> list = new ArrayList<ParameterInformation>();
        for (VariableTree variableTree : source.getParameters()) {
            ParameterInformation info = new ParameterInformation();
            info.label = String.valueOf(variableTree.getType()) + " " + String.valueOf(variableTree.getName());
            list.add(info);
        }
        return list;
    }

    private int activeParameter(CompileTask task, List<? extends ExpressionTree> arguments, long cursor) {
        SourcePositions pos = Trees.instance(task.task).getSourcePositions();
        CompilationUnitTree root = task.root();
        for (int i = 0; i < arguments.size(); ++i) {
            long end = pos.getEndPosition(root, arguments.get(i));
            if (cursor > end) continue;
            return i;
        }
        return arguments.size();
    }

    private int activeSignature(CompileTask task, TreePath invocation, List<? extends ExpressionTree> arguments, List<ExecutableElement> overloads) {
        for (int i = 0; i < overloads.size(); ++i) {
            if (!this.isCompatible(task, invocation, arguments, overloads.get(i))) continue;
            return i;
        }
        return 0;
    }

    private boolean isCompatible(CompileTask task, TreePath invocation, List<? extends ExpressionTree> arguments, ExecutableElement overload) {
        if (arguments.size() > overload.getParameters().size()) {
            return false;
        }
        for (int i = 0; i < arguments.size(); ++i) {
            TypeMirror parameterType;
            ExpressionTree argument = arguments.get(i);
            TypeMirror argumentType = Trees.instance(task.task).getTypeMirror(new TreePath(invocation, argument));
            if (this.isCompatible(task, argumentType, parameterType = overload.getParameters().get(i).asType())) continue;
            return false;
        }
        return true;
    }

    private boolean isCompatible(CompileTask task, TypeMirror argument, TypeMirror parameter) {
        if (argument instanceof ErrorType) {
            return true;
        }
        if (argument instanceof PrimitiveType) {
            argument = task.task.getTypes().boxedClass((PrimitiveType)argument).asType();
        }
        if (parameter instanceof PrimitiveType) {
            parameter = task.task.getTypes().boxedClass((PrimitiveType)parameter).asType();
        }
        if (argument instanceof ArrayType) {
            if (!(parameter instanceof ArrayType)) {
                return false;
            }
            ArrayType argumentA = (ArrayType)argument;
            ArrayType parameterA = (ArrayType)parameter;
            return this.isCompatible(task, argumentA.getComponentType(), parameterA.getComponentType());
        }
        if (argument instanceof DeclaredType) {
            if (!(parameter instanceof DeclaredType)) {
                return false;
            }
            argument = task.task.getTypes().erasure(argument);
            parameter = task.task.getTypes().erasure(parameter);
            return argument.toString().equals(parameter.toString());
        }
        return true;
    }
}

