/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.debug.proto;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javacs.debug.proto.AttachRequest;
import org.javacs.debug.proto.BreakpointEvent;
import org.javacs.debug.proto.BreakpointEventBody;
import org.javacs.debug.proto.ContinueRequest;
import org.javacs.debug.proto.DebugClient;
import org.javacs.debug.proto.DebugServer;
import org.javacs.debug.proto.DisconnectRequest;
import org.javacs.debug.proto.ErrorResponse;
import org.javacs.debug.proto.EvaluateRequest;
import org.javacs.debug.proto.EvaluateResponse;
import org.javacs.debug.proto.Event;
import org.javacs.debug.proto.ExitedEvent;
import org.javacs.debug.proto.ExitedEventBody;
import org.javacs.debug.proto.InitializeRequest;
import org.javacs.debug.proto.InitializeResponse;
import org.javacs.debug.proto.InitializedEvent;
import org.javacs.debug.proto.LaunchRequest;
import org.javacs.debug.proto.NextRequest;
import org.javacs.debug.proto.OutputEvent;
import org.javacs.debug.proto.OutputEventBody;
import org.javacs.debug.proto.ProtocolMessage;
import org.javacs.debug.proto.Request;
import org.javacs.debug.proto.Response;
import org.javacs.debug.proto.RunInTerminalRequest;
import org.javacs.debug.proto.RunInTerminalResponse;
import org.javacs.debug.proto.RunInTerminalResponseBody;
import org.javacs.debug.proto.ScopesRequest;
import org.javacs.debug.proto.ScopesResponse;
import org.javacs.debug.proto.SetBreakpointsRequest;
import org.javacs.debug.proto.SetBreakpointsResponse;
import org.javacs.debug.proto.SetExceptionBreakpointsRequest;
import org.javacs.debug.proto.SetFunctionBreakpointsRequest;
import org.javacs.debug.proto.SetFunctionBreakpointsResponse;
import org.javacs.debug.proto.StackTraceRequest;
import org.javacs.debug.proto.StackTraceResponse;
import org.javacs.debug.proto.StepInRequest;
import org.javacs.debug.proto.StepOutRequest;
import org.javacs.debug.proto.StoppedEvent;
import org.javacs.debug.proto.StoppedEventBody;
import org.javacs.debug.proto.TerminateRequest;
import org.javacs.debug.proto.TerminatedEvent;
import org.javacs.debug.proto.TerminatedEventBody;
import org.javacs.debug.proto.ThreadsResponse;
import org.javacs.debug.proto.VariablesRequest;
import org.javacs.debug.proto.VariablesResponse;

public class DebugAdapter {
    private static final Gson gson = new Gson();
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final JsonObject END_OF_STREAM = new JsonObject();
    private final OutputStream send;
    private final InputStream receive;
    private final DebugClient client;
    private final DebugServer server;
    private ArrayBlockingQueue<JsonObject> pending = new ArrayBlockingQueue(10);
    private Map<Integer, CompletableFuture<RunInTerminalResponseBody>> runInTerminalResponse = new ConcurrentHashMap<Integer, CompletableFuture<RunInTerminalResponseBody>>();
    private int respCounter = 0;
    private static final Logger LOG = Logger.getLogger("debug");

    private static String readHeader(InputStream client) {
        StringBuilder line = new StringBuilder();
        char next = DebugAdapter.read(client);
        while (true) {
            if (next == '\r') {
                char last = DebugAdapter.read(client);
                assert (last == '\n');
                break;
            }
            line.append(next);
            next = DebugAdapter.read(client);
        }
        return line.toString();
    }

    private static int parseHeader(String header) {
        String contentLength = "Content-Length: ";
        if (header.startsWith(contentLength)) {
            String tail = header.substring(contentLength.length());
            int length = Integer.parseInt(tail);
            return length;
        }
        return -1;
    }

    private static char read(InputStream client) {
        try {
            int c = client.read();
            if (c == -1) {
                LOG.warning("Stream from client has been closed, throwing kill exception...");
                throw new EndOfStream();
            }
            return (char)c;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String readLength(InputStream client, int byteLength) {
        try {
            return new String(client.readNBytes(byteLength), StandardCharsets.UTF_8).stripLeading();
        }
        catch (IOException e) {
            throw new RuntimeException("An error occurred during the reading of client data", e);
        }
    }

    static String nextToken(InputStream client) {
        int contentLength = -1;
        String line;
        while (!(line = DebugAdapter.readHeader(client)).isEmpty()) {
            int maybeLength = DebugAdapter.parseHeader(line);
            if (maybeLength == -1) continue;
            contentLength = maybeLength;
        }
        return DebugAdapter.readLength(client, contentLength);
    }

    static JsonObject parseMessage(String token) {
        return (JsonObject)gson.fromJson(token, JsonObject.class);
    }

    static String toJson(Object message) {
        return gson.toJson(message);
    }

    private void send(ProtocolMessage message) {
        String jsonText = DebugAdapter.toJson(message);
        byte[] messageBytes = jsonText.getBytes(UTF_8);
        String headerText = String.format("Content-Length: %d\r\n\r\n", messageBytes.length);
        byte[] headerBytes = headerText.getBytes(UTF_8);
        try {
            this.send.write(headerBytes);
            this.send.write(messageBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DebugAdapter(Function<DebugClient, DebugServer> serverFactory, InputStream receive, OutputStream send) {
        this.receive = receive;
        this.send = send;
        this.client = new RealClient();
        this.server = serverFactory.apply(this.client);
    }

    public void run() {
        Thread reader = new Thread((Runnable)new ReceiveDebugClientEvents(), "receive-client");
        reader.setDaemon(true);
        reader.start();
        LOG.info("Reading messages from queue...");
        while (true) {
            JsonObject json;
            try {
                json = this.pending.poll(200L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
                continue;
            }
            if (json == END_OF_STREAM) {
                LOG.warning("Stream from client has been closed, exiting...");
                return;
            }
            if (json == null) continue;
            this.receive(json);
        }
    }

    private void receive(JsonObject json) {
        ProtocolMessage msg = (ProtocolMessage)gson.fromJson((JsonElement)json, ProtocolMessage.class);
        switch (msg.type) {
            case "request": {
                this.processRequest(json);
                break;
            }
            case "response": {
                throw new RuntimeException("Response should have been handled by reader thread");
            }
            case "event": {
                this.processEvent(json);
                break;
            }
            default: {
                throw new RuntimeException("Unknown message type " + msg.type);
            }
        }
    }

    private void processRequest(JsonObject json) {
        Request req = (Request)gson.fromJson((JsonElement)json, Request.class);
        try {
            switch (req.command) {
                case "initialize": {
                    InitializeResponse resp = new InitializeResponse();
                    resp.type = "response";
                    resp.command = req.command;
                    resp.request_seq = req.seq;
                    resp.seq = this.respCounter++;
                    resp.success = true;
                    resp.body = this.server.initialize(((InitializeRequest)DebugAdapter.gson.fromJson((JsonElement)json, InitializeRequest.class)).arguments);
                    this.send(resp);
                    break;
                }
                case "configurationDone": {
                    this.server.configurationDone();
                    this.ack(req);
                    break;
                }
                case "launch": {
                    this.server.launch(((LaunchRequest)DebugAdapter.gson.fromJson((JsonElement)json, LaunchRequest.class)).arguments);
                    this.ack(req);
                    break;
                }
                case "attach": {
                    this.server.attach(((AttachRequest)DebugAdapter.gson.fromJson((JsonElement)json, AttachRequest.class)).arguments);
                    this.ack(req);
                    break;
                }
                case "disconnect": {
                    this.server.disconnect(((DisconnectRequest)DebugAdapter.gson.fromJson((JsonElement)json, DisconnectRequest.class)).arguments);
                    this.ack(req);
                    break;
                }
                case "terminate": {
                    this.server.terminate(((TerminateRequest)DebugAdapter.gson.fromJson((JsonElement)json, TerminateRequest.class)).arguments);
                    this.ack(req);
                    break;
                }
                case "setBreakpoints": {
                    SetBreakpointsResponse resp = new SetBreakpointsResponse();
                    resp.type = "response";
                    resp.type = "response";
                    resp.command = req.command;
                    resp.request_seq = req.seq;
                    resp.seq = this.respCounter++;
                    resp.success = true;
                    resp.body = this.server.setBreakpoints(((SetBreakpointsRequest)DebugAdapter.gson.fromJson((JsonElement)json, SetBreakpointsRequest.class)).arguments);
                    this.send(resp);
                    break;
                }
                case "setFunctionBreakpoints": {
                    SetFunctionBreakpointsResponse resp = new SetFunctionBreakpointsResponse();
                    resp.type = "response";
                    resp.type = "response";
                    resp.command = req.command;
                    resp.request_seq = req.seq;
                    resp.seq = this.respCounter++;
                    resp.success = true;
                    resp.body = this.server.setFunctionBreakpoints(((SetFunctionBreakpointsRequest)DebugAdapter.gson.fromJson((JsonElement)json, SetFunctionBreakpointsRequest.class)).arguments);
                    this.send(resp);
                    break;
                }
                case "setExceptionBreakpoints": {
                    this.server.setExceptionBreakpoints(((SetExceptionBreakpointsRequest)DebugAdapter.gson.fromJson((JsonElement)json, SetExceptionBreakpointsRequest.class)).arguments);
                    this.ack(req);
                    break;
                }
                case "continue": {
                    this.server.continue_(((ContinueRequest)DebugAdapter.gson.fromJson((JsonElement)json, ContinueRequest.class)).arguments);
                    this.ack(req);
                    break;
                }
                case "next": {
                    this.server.next(((NextRequest)DebugAdapter.gson.fromJson((JsonElement)json, NextRequest.class)).arguments);
                    this.ack(req);
                    break;
                }
                case "stepIn": {
                    this.server.stepIn(((StepInRequest)DebugAdapter.gson.fromJson((JsonElement)json, StepInRequest.class)).arguments);
                    this.ack(req);
                    break;
                }
                case "stepOut": {
                    this.server.stepOut(((StepOutRequest)DebugAdapter.gson.fromJson((JsonElement)json, StepOutRequest.class)).arguments);
                    this.ack(req);
                    break;
                }
                case "threads": {
                    ThreadsResponse resp = new ThreadsResponse();
                    resp.type = "response";
                    resp.command = req.command;
                    resp.request_seq = req.seq;
                    resp.seq = this.respCounter++;
                    resp.success = true;
                    resp.body = this.server.threads();
                    this.send(resp);
                    break;
                }
                case "stackTrace": {
                    StackTraceResponse resp = new StackTraceResponse();
                    resp.type = "response";
                    resp.command = req.command;
                    resp.request_seq = req.seq;
                    resp.seq = this.respCounter++;
                    resp.success = true;
                    resp.body = this.server.stackTrace(((StackTraceRequest)DebugAdapter.gson.fromJson((JsonElement)json, StackTraceRequest.class)).arguments);
                    this.send(resp);
                    break;
                }
                case "scopes": {
                    ScopesResponse resp = new ScopesResponse();
                    resp.type = "response";
                    resp.command = req.command;
                    resp.request_seq = req.seq;
                    resp.seq = this.respCounter++;
                    resp.success = true;
                    resp.body = this.server.scopes(((ScopesRequest)DebugAdapter.gson.fromJson((JsonElement)json, ScopesRequest.class)).arguments);
                    this.send(resp);
                    break;
                }
                case "variables": {
                    VariablesResponse resp = new VariablesResponse();
                    resp.type = "response";
                    resp.command = req.command;
                    resp.request_seq = req.seq;
                    resp.seq = this.respCounter++;
                    resp.success = true;
                    resp.body = this.server.variables(((VariablesRequest)DebugAdapter.gson.fromJson((JsonElement)json, VariablesRequest.class)).arguments);
                    this.send(resp);
                    break;
                }
                case "evaluate": {
                    EvaluateResponse resp = new EvaluateResponse();
                    resp.type = "response";
                    resp.command = req.command;
                    resp.request_seq = req.seq;
                    resp.seq = this.respCounter++;
                    resp.success = true;
                    resp.body = this.server.evaluate(((EvaluateRequest)DebugAdapter.gson.fromJson((JsonElement)json, EvaluateRequest.class)).arguments);
                    this.send(resp);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            ErrorResponse resp = new ErrorResponse();
            resp.type = "response";
            resp.command = req.command;
            resp.request_seq = req.seq;
            resp.seq = this.respCounter++;
            resp.success = false;
            resp.message = e.getMessage();
            this.send(resp);
        }
    }

    private void ack(Request req) {
        Response resp = new Response();
        resp.type = "response";
        resp.command = req.command;
        resp.request_seq = req.seq;
        resp.seq = this.respCounter++;
        resp.success = true;
        this.send(resp);
    }

    private void processEvent(JsonObject json) {
        Event evt = (Event)gson.fromJson((JsonElement)json, Event.class);
        Objects.requireNonNull(evt.event);
    }

    private static class EndOfStream
    extends RuntimeException {
        private EndOfStream() {
        }
    }

    class RealClient
    implements DebugClient {
        RealClient() {
        }

        @Override
        public void initialized() {
            InitializedEvent wrapper = new InitializedEvent();
            wrapper.seq = DebugAdapter.this.respCounter++;
            wrapper.type = "event";
            wrapper.event = "initialized";
            DebugAdapter.this.send(wrapper);
        }

        @Override
        public void stopped(StoppedEventBody evt) {
            StoppedEvent wrapper = new StoppedEvent();
            wrapper.seq = DebugAdapter.this.respCounter++;
            wrapper.type = "event";
            wrapper.event = "stopped";
            wrapper.body = evt;
            DebugAdapter.this.send(wrapper);
        }

        @Override
        public void exited(ExitedEventBody evt) {
            ExitedEvent wrapper = new ExitedEvent();
            wrapper.seq = DebugAdapter.this.respCounter++;
            wrapper.type = "event";
            wrapper.event = "exited";
            wrapper.body = evt;
            DebugAdapter.this.send(wrapper);
        }

        @Override
        public void terminated(TerminatedEventBody evt) {
            TerminatedEvent wrapper = new TerminatedEvent();
            wrapper.seq = DebugAdapter.this.respCounter++;
            wrapper.type = "event";
            wrapper.event = "terminated";
            wrapper.body = evt;
            DebugAdapter.this.send(wrapper);
        }

        @Override
        public void output(OutputEventBody evt) {
            OutputEvent wrapper = new OutputEvent();
            wrapper.seq = DebugAdapter.this.respCounter++;
            wrapper.type = "event";
            wrapper.event = "output";
            wrapper.body = evt;
            DebugAdapter.this.send(wrapper);
        }

        @Override
        public void breakpoint(BreakpointEventBody evt) {
            BreakpointEvent wrapper = new BreakpointEvent();
            wrapper.seq = DebugAdapter.this.respCounter++;
            wrapper.type = "event";
            wrapper.event = "breakpoint";
            wrapper.body = evt;
            DebugAdapter.this.send(wrapper);
        }

        @Override
        public RunInTerminalResponseBody runInTerminal(RunInTerminalRequest req) {
            CompletableFuture wait = new CompletableFuture();
            DebugAdapter.this.runInTerminalResponse.put(req.seq, wait);
            DebugAdapter.this.send(req);
            try {
                return (RunInTerminalResponseBody)wait.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
                throw new RuntimeException(e);
            }
        }
    }

    class ReceiveDebugClientEvents
    implements Runnable {
        ReceiveDebugClientEvents() {
        }

        @Override
        public void run() {
            LOG.info("Placing incoming messages on queue...");
            block12: while (true) {
                try {
                    String token = DebugAdapter.nextToken(DebugAdapter.this.receive);
                    JsonObject json = DebugAdapter.parseMessage(token);
                    ProtocolMessage msg = (ProtocolMessage)gson.fromJson((JsonElement)json, ProtocolMessage.class);
                    switch (msg.type) {
                        case "request": 
                        case "event": {
                            DebugAdapter.this.pending.put(json);
                            continue block12;
                        }
                        case "response": {
                            this.processResponse(json);
                            continue block12;
                        }
                    }
                    throw new RuntimeException("Unknown message type " + msg.type);
                }
                catch (EndOfStream __) {
                    if (!this.kill()) continue;
                    return;
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, e.getMessage(), e);
                    continue;
                }
                break;
            }
        }

        void processResponse(JsonObject json) {
            String cmd;
            switch (cmd = ((Response)DebugAdapter.gson.fromJson((JsonElement)json, Response.class)).command) {
                case "runInTerminal": {
                    RunInTerminalResponse resp = (RunInTerminalResponse)gson.fromJson((JsonElement)json, RunInTerminalResponse.class);
                    CompletableFuture<RunInTerminalResponseBody> wait = DebugAdapter.this.runInTerminalResponse.remove(resp.request_seq);
                    wait.complete(resp.body);
                    break;
                }
                default: {
                    throw new RuntimeException("Don't know what to do with response to command " + cmd);
                }
            }
        }

        private boolean kill() {
            LOG.info("Read stream has been closed, putting kill message onto queue...");
            try {
                DebugAdapter.this.pending.put(END_OF_STREAM);
                return true;
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to put kill message onto queue, will try again...", e);
                return false;
            }
        }
    }
}

