/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.guava;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ClassPath {
    private static final Logger logger = Logger.getLogger(ClassPath.class.getName());
    private static final String CLASS_FILE_NAME_EXTENSION = ".class";
    private final Set<ResourceInfo> resources;

    private ClassPath(Set<ResourceInfo> resources) {
        this.resources = resources;
    }

    public static ClassPath from(ClassLoader classloader) throws IOException {
        DefaultScanner scanner = new DefaultScanner();
        scanner.scan(classloader);
        return new ClassPath(scanner.getResources());
    }

    public Set<ResourceInfo> getResources() {
        return this.resources;
    }

    private Stream<ClassInfo> filterClassInfo(Object any) {
        if (any instanceof ClassInfo) {
            return Stream.of((ClassInfo)any);
        }
        return Stream.empty();
    }

    public Set<ClassInfo> getAllClasses() {
        return this.resources.stream().flatMap(this::filterClassInfo).collect(Collectors.toSet());
    }

    private boolean isTopLevel(ClassInfo info) {
        return info.className.indexOf(36) == -1;
    }

    public Set<ClassInfo> getTopLevelClasses() {
        return this.resources.stream().flatMap(this::filterClassInfo).filter(this::isTopLevel).collect(Collectors.toSet());
    }

    public Set<ClassInfo> getTopLevelClasses(String packageName) {
        assert (packageName != null);
        HashSet<ClassInfo> builder = new HashSet<ClassInfo>();
        for (ClassInfo classInfo : this.getTopLevelClasses()) {
            if (!classInfo.getPackageName().equals(packageName)) continue;
            builder.add(classInfo);
        }
        return builder;
    }

    public Set<ClassInfo> getTopLevelClassesRecursive(String packageName) {
        assert (packageName != null);
        String packagePrefix = packageName + ".";
        HashSet<ClassInfo> builder = new HashSet<ClassInfo>();
        for (ClassInfo classInfo : this.getTopLevelClasses()) {
            if (!classInfo.getName().startsWith(packagePrefix)) continue;
            builder.add(classInfo);
        }
        return builder;
    }

    static String getClassName(String filename) {
        int classNameEnd = filename.length() - CLASS_FILE_NAME_EXTENSION.length();
        return filename.substring(0, classNameEnd).replace('/', '.');
    }

    static File toFile(URL url) {
        assert (url.getProtocol().equals("file"));
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
    }

    static final class DefaultScanner
    extends Scanner {
        private final Map<ClassLoader, Set<String>> resources = new HashMap<ClassLoader, Set<String>>();

        DefaultScanner() {
        }

        Set<ResourceInfo> getResources() {
            HashSet<ResourceInfo> builder = new HashSet<ResourceInfo>();
            for (Map.Entry<ClassLoader, Set<String>> entry : this.resources.entrySet()) {
                for (String value : entry.getValue()) {
                    builder.add(ResourceInfo.of(value, entry.getKey()));
                }
            }
            return Collections.unmodifiableSet(builder);
        }

        @Override
        protected void scanJarFile(ClassLoader classloader, JarFile file) {
            Enumeration<JarEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || entry.getName().equals("META-INF/MANIFEST.MF")) continue;
                this.resources.computeIfAbsent(classloader, __ -> new LinkedHashSet()).add(entry.getName());
            }
        }

        @Override
        protected void scanDirectory(ClassLoader classloader, File directory) throws IOException {
            HashSet<File> currentPath = new HashSet<File>();
            currentPath.add(directory.getCanonicalFile());
            this.scanDirectory(directory, classloader, "", currentPath);
        }

        private void scanDirectory(File directory, ClassLoader classloader, String packagePrefix, Set<File> currentPath) throws IOException {
            File[] files = directory.listFiles();
            if (files == null) {
                logger.warning("Cannot read directory " + String.valueOf(directory));
                return;
            }
            for (File f : files) {
                String name = f.getName();
                if (f.isDirectory()) {
                    File deref = f.getCanonicalFile();
                    if (!currentPath.add(deref)) continue;
                    this.scanDirectory(deref, classloader, packagePrefix + name + "/", currentPath);
                    currentPath.remove(deref);
                    continue;
                }
                String resourceName = packagePrefix + name;
                if (resourceName.equals("META-INF/MANIFEST.MF")) continue;
                this.resources.computeIfAbsent(classloader, __ -> new LinkedHashSet()).add(resourceName);
            }
        }
    }

    public static final class ClassInfo
    extends ResourceInfo {
        private final String className;

        ClassInfo(String resourceName, ClassLoader loader) {
            super(resourceName, loader);
            this.className = ClassPath.getClassName(resourceName);
        }

        public String getPackageName() {
            int lastDot = this.className.lastIndexOf(46);
            return lastDot < 0 ? "" : this.className.substring(0, lastDot);
        }

        public String getSimpleName() {
            int lastDollarSign = this.className.lastIndexOf(36);
            if (lastDollarSign != -1) {
                int prefix;
                String innerClassName = this.className.substring(lastDollarSign + 1);
                for (prefix = 0; prefix < innerClassName.length() && Character.isDigit(innerClassName.charAt(prefix)); ++prefix) {
                }
                return innerClassName.substring(prefix);
            }
            String packageName = this.getPackageName();
            if (packageName.isEmpty()) {
                return this.className;
            }
            return this.className.substring(packageName.length() + 1);
        }

        public String getName() {
            return this.className;
        }

        public Class<?> load() {
            try {
                return this.loader.loadClass(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public String toString() {
            return this.className;
        }
    }

    static abstract class Scanner {
        private final Set<File> scannedUris = new HashSet<File>();

        Scanner() {
        }

        public final void scan(ClassLoader classloader) throws IOException {
            for (Map.Entry<File, ClassLoader> entry : Scanner.getClassPathEntries(classloader).entrySet()) {
                this.scan(entry.getKey(), entry.getValue());
            }
        }

        final void scan(File file, ClassLoader classloader) throws IOException {
            if (this.scannedUris.add(file.getCanonicalFile())) {
                this.scanFrom(file, classloader);
            }
        }

        protected abstract void scanDirectory(ClassLoader var1, File var2) throws IOException;

        protected abstract void scanJarFile(ClassLoader var1, JarFile var2) throws IOException;

        private void scanFrom(File file, ClassLoader classloader) throws IOException {
            try {
                if (!file.exists()) {
                    return;
                }
            }
            catch (SecurityException e) {
                logger.warning("Cannot access " + String.valueOf(file) + ": " + String.valueOf(e));
                return;
            }
            if (file.isDirectory()) {
                this.scanDirectory(classloader, file);
            } else {
                this.scanJar(file, classloader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanJar(File file, ClassLoader classloader) throws IOException {
            JarFile jarFile;
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException e) {
                return;
            }
            try {
                for (File path : Scanner.getClassPathFromManifest(file, jarFile.getManifest())) {
                    this.scan(path, classloader);
                }
                this.scanJarFile(classloader, jarFile);
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }

        static Set<File> getClassPathFromManifest(File jarFile, Manifest manifest) {
            if (manifest == null) {
                return Set.of();
            }
            HashSet<File> builder = new HashSet<File>();
            String classpathAttribute = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH.toString());
            if (classpathAttribute != null) {
                for (String path : classpathAttribute.split(" ")) {
                    URL url;
                    if (path.isEmpty()) continue;
                    try {
                        url = Scanner.getClassPathEntry(jarFile, path);
                    }
                    catch (MalformedURLException e) {
                        logger.warning("Invalid Class-Path entry: " + path);
                        continue;
                    }
                    if (!url.getProtocol().equals("file")) continue;
                    builder.add(ClassPath.toFile(url));
                }
            }
            return Collections.unmodifiableSet(builder);
        }

        static Map<File, ClassLoader> getClassPathEntries(ClassLoader classloader) {
            LinkedHashMap<File, ClassLoader> entries = new LinkedHashMap<File, ClassLoader>();
            ClassLoader parent = classloader.getParent();
            if (parent != null) {
                entries.putAll(Scanner.getClassPathEntries(parent));
            }
            for (URL url : Scanner.getClassLoaderUrls(classloader)) {
                File file;
                if (!url.getProtocol().equals("file") || entries.containsKey(file = ClassPath.toFile(url))) continue;
                entries.put(file, classloader);
            }
            return Collections.unmodifiableMap(entries);
        }

        private static List<URL> getClassLoaderUrls(ClassLoader classloader) {
            if (classloader instanceof URLClassLoader) {
                return List.of(((URLClassLoader)classloader).getURLs());
            }
            if (classloader.equals(ClassLoader.getSystemClassLoader())) {
                return Scanner.parseJavaClassPath();
            }
            return List.of();
        }

        static List<URL> parseJavaClassPath() {
            ArrayList<URL> urls = new ArrayList<URL>();
            String classPath = System.getProperty("java.class.path");
            String sep = System.getProperty("path.separator");
            for (String entry : classPath.split(sep)) {
                try {
                    try {
                        urls.add(new File(entry).toURI().toURL());
                    }
                    catch (SecurityException e) {
                        urls.add(new URL("file", null, new File(entry).getAbsolutePath()));
                    }
                }
                catch (MalformedURLException e) {
                    logger.log(Level.WARNING, "malformed classpath entry: " + entry, e);
                }
            }
            return Collections.unmodifiableList(urls);
        }

        static URL getClassPathEntry(File jarFile, String path) throws MalformedURLException {
            return new URL(jarFile.toURI().toURL(), path);
        }
    }

    public static class ResourceInfo {
        private final String resourceName;
        final ClassLoader loader;

        static ResourceInfo of(String resourceName, ClassLoader loader) {
            if (resourceName.endsWith(ClassPath.CLASS_FILE_NAME_EXTENSION)) {
                return new ClassInfo(resourceName, loader);
            }
            return new ResourceInfo(resourceName, loader);
        }

        ResourceInfo(String resourceName, ClassLoader loader) {
            assert (resourceName != null);
            assert (loader != null);
            this.resourceName = resourceName;
            this.loader = loader;
        }

        public final URL url() {
            URL url = this.loader.getResource(this.resourceName);
            if (url == null) {
                throw new NoSuchElementException(this.resourceName);
            }
            return url;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public int hashCode() {
            return this.resourceName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ResourceInfo) {
                ResourceInfo that = (ResourceInfo)obj;
                return this.resourceName.equals(that.resourceName) && this.loader == that.loader;
            }
            return false;
        }

        public String toString() {
            return this.resourceName;
        }
    }
}

