/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.hover;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import javax.lang.model.element.Element;

class FindHoverElement
extends TreePathScanner<Element, Long> {
    private final JavacTask task;
    private CompilationUnitTree root;

    FindHoverElement(JavacTask task) {
        this.task = task;
    }

    @Override
    public Element visitCompilationUnit(CompilationUnitTree t, Long find) {
        this.root = t;
        return (Element)super.visitCompilationUnit(t, find);
    }

    @Override
    public Element visitIdentifier(IdentifierTree t, Long find) {
        SourcePositions pos = Trees.instance(this.task).getSourcePositions();
        long start = pos.getStartPosition(this.root, t);
        long end = pos.getEndPosition(this.root, t);
        if (start <= find && find < end) {
            return Trees.instance(this.task).getElement(this.getCurrentPath());
        }
        return (Element)super.visitIdentifier(t, find);
    }

    @Override
    public Element visitMemberSelect(MemberSelectTree t, Long find) {
        SourcePositions pos = Trees.instance(this.task).getSourcePositions();
        long start = pos.getEndPosition(this.root, t.getExpression()) + 1L;
        long end = pos.getEndPosition(this.root, t);
        if (start <= find && find < end) {
            return Trees.instance(this.task).getElement(this.getCurrentPath());
        }
        return (Element)super.visitMemberSelect(t, find);
    }

    @Override
    public Element visitMemberReference(MemberReferenceTree t, Long find) {
        SourcePositions pos = Trees.instance(this.task).getSourcePositions();
        long start = pos.getStartPosition(this.root, t.getQualifierExpression()) + 2L;
        long end = pos.getEndPosition(this.root, t);
        if (start <= find && find < end) {
            return Trees.instance(this.task).getElement(this.getCurrentPath());
        }
        return (Element)super.visitMemberReference(t, find);
    }

    @Override
    public Element reduce(Element a, Element b) {
        if (a != null) {
            return a;
        }
        return b;
    }
}

