/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.hover;

import com.google.gson.JsonNull;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTrees;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.JavaFileObject;
import org.javacs.CompileTask;
import org.javacs.CompilerProvider;
import org.javacs.CompletionData;
import org.javacs.FindHelper;
import org.javacs.JsonHelper;
import org.javacs.MarkdownHelper;
import org.javacs.ParseTask;
import org.javacs.hover.FindHoverElement;
import org.javacs.hover.ShortTypePrinter;
import org.javacs.lsp.CompletionItem;
import org.javacs.lsp.MarkedString;

public class HoverProvider {
    final CompilerProvider compiler;
    public static final List<MarkedString> NOT_SUPPORTED = List.of();
    private static final Logger LOG = Logger.getLogger("main");

    public HoverProvider(CompilerProvider compiler) {
        this.compiler = compiler;
    }

    public List<MarkedString> hover(Path file, int line, int column) {
        try (CompileTask task = this.compiler.compile(file);){
            long position = task.root().getLineMap().getPosition(line, column);
            Element element = (Element)new FindHoverElement(task.task).scan(task.root(), Long.valueOf(position));
            if (element == null) {
                List<MarkedString> list = NOT_SUPPORTED;
                return list;
            }
            ArrayList<MarkedString> list = new ArrayList<MarkedString>();
            String code = this.printType(element);
            list.add(new MarkedString("java", code));
            String docs = this.docs(task, element);
            if (!docs.isEmpty()) {
                list.add(new MarkedString(docs));
            }
            ArrayList<MarkedString> arrayList = list;
            return arrayList;
        }
    }

    public void resolveCompletionItem(CompletionItem item) {
        if (item.data == null || item.data == JsonNull.INSTANCE) {
            return;
        }
        CompletionData data = (CompletionData)JsonHelper.GSON.fromJson(item.data, CompletionData.class);
        Optional<JavaFileObject> source = this.compiler.findAnywhere(data.className);
        if (source.isEmpty()) {
            return;
        }
        ParseTask task = this.compiler.parse(source.get());
        Tree tree = this.findItem(task, data);
        this.resolveDetail(item, data, tree);
        TreePath path = Trees.instance(task.task).getPath(task.root, tree);
        DocCommentTree docTree = DocTrees.instance(task.task).getDocCommentTree(path);
        if (docTree == null) {
            return;
        }
        item.documentation = MarkdownHelper.asMarkupContent(docTree);
    }

    private void resolveDetail(CompletionItem item, CompletionData data, Tree tree) {
        if (tree instanceof MethodTree) {
            MethodTree method = (MethodTree)tree;
            StringJoiner parameters = new StringJoiner(", ");
            for (VariableTree variableTree : method.getParameters()) {
                parameters.add(String.valueOf(variableTree.getType()) + " " + String.valueOf(variableTree.getName()));
            }
            item.detail = String.valueOf(method.getReturnType()) + " " + String.valueOf(method.getName()) + "(" + String.valueOf(parameters) + ")";
            if (!method.getThrows().isEmpty()) {
                StringJoiner exceptions = new StringJoiner(", ");
                for (ExpressionTree expressionTree : method.getThrows()) {
                    exceptions.add(expressionTree.toString());
                }
                item.detail = item.detail + " throws " + String.valueOf(exceptions);
            }
            if (data.plusOverloads != 0) {
                item.detail = item.detail + " (+" + data.plusOverloads + " overloads)";
            }
        }
    }

    private Tree findItem(ParseTask task, CompletionData data) {
        if (data.erasedParameterTypes != null) {
            return FindHelper.findMethod(task, data.className, data.memberName, data.erasedParameterTypes);
        }
        if (data.memberName != null) {
            return FindHelper.findField(task, data.className, data.memberName);
        }
        if (data.className != null) {
            return FindHelper.findType(task, data.className);
        }
        throw new RuntimeException("no className");
    }

    private String docs(CompileTask task, Element element) {
        if (element instanceof TypeElement) {
            TypeElement type = (TypeElement)element;
            String className = type.getQualifiedName().toString();
            Optional<JavaFileObject> file = this.compiler.findAnywhere(className);
            if (file.isEmpty()) {
                return "";
            }
            ParseTask parse = this.compiler.parse(file.get());
            ClassTree tree = FindHelper.findType(parse, className);
            return this.docs(parse, tree);
        }
        if (element.getKind() == ElementKind.FIELD) {
            VariableElement field = (VariableElement)element;
            TypeElement type = (TypeElement)field.getEnclosingElement();
            String className = type.getQualifiedName().toString();
            Optional<JavaFileObject> file = this.compiler.findAnywhere(className);
            if (file.isEmpty()) {
                return "";
            }
            ParseTask parse = this.compiler.parse(file.get());
            ClassTree tree = FindHelper.findType(parse, className);
            return this.docs(parse, tree);
        }
        if (element instanceof ExecutableElement) {
            ExecutableElement method = (ExecutableElement)element;
            TypeElement type = (TypeElement)method.getEnclosingElement();
            String className = type.getQualifiedName().toString();
            String methodName = method.getSimpleName().toString();
            String[] erasedParameterTypes = FindHelper.erasedParameterTypes(task, method);
            Optional<JavaFileObject> file = this.compiler.findAnywhere(className);
            if (file.isEmpty()) {
                return "";
            }
            ParseTask parse = this.compiler.parse(file.get());
            MethodTree tree = FindHelper.findMethod(parse, className, methodName, erasedParameterTypes);
            return this.docs(parse, tree);
        }
        return "";
    }

    private String docs(ParseTask task, Tree tree) {
        TreePath path = Trees.instance(task.task).getPath(task.root, tree);
        DocCommentTree docTree = DocTrees.instance(task.task).getDocCommentTree(path);
        if (docTree == null) {
            return "";
        }
        return MarkdownHelper.asMarkdown(docTree);
    }

    private String printType(Element e) {
        if (e instanceof ExecutableElement) {
            ExecutableElement m = (ExecutableElement)e;
            return ShortTypePrinter.DEFAULT.printMethod(m);
        }
        if (e instanceof VariableElement) {
            VariableElement v = (VariableElement)e;
            return ShortTypePrinter.DEFAULT.print(v.asType()) + " " + String.valueOf(v);
        }
        if (e instanceof TypeElement) {
            TypeElement t = (TypeElement)e;
            StringJoiner lines = new StringJoiner("\n");
            lines.add(this.hoverTypeDeclaration(t) + " {");
            for (Element element : t.getEnclosedElements()) {
                if (element instanceof ExecutableElement || element instanceof VariableElement) {
                    lines.add("  " + this.printType(element) + ";");
                    continue;
                }
                if (!(element instanceof TypeElement)) continue;
                lines.add("  " + this.hoverTypeDeclaration((TypeElement)element) + " { /* removed */ }");
            }
            lines.add("}");
            return lines.toString();
        }
        return e.toString();
    }

    private String hoverTypeDeclaration(TypeElement t) {
        String superType;
        StringBuilder result = new StringBuilder();
        switch (t.getKind()) {
            case ANNOTATION_TYPE: {
                result.append("@interface");
                break;
            }
            case INTERFACE: {
                result.append("interface");
                break;
            }
            case CLASS: {
                result.append("class");
                break;
            }
            case ENUM: {
                result.append("enum");
                break;
            }
            default: {
                LOG.warning("Don't know what to call type element " + String.valueOf(t));
                result.append("_");
            }
        }
        result.append(" ").append(ShortTypePrinter.DEFAULT.print(t.asType()));
        switch (superType = ShortTypePrinter.DEFAULT.print(t.getSuperclass())) {
            case "Object": 
            case "none": {
                break;
            }
            default: {
                result.append(" extends ").append(superType);
            }
        }
        return result.toString();
    }
}

