/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.hover;

import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractTypeVisitor8;

public class ShortTypePrinter
extends AbstractTypeVisitor8<String, Void> {
    public static final ShortTypePrinter DEFAULT = new ShortTypePrinter("");
    public static final ShortTypePrinter NO_PACKAGE = new ShortTypePrinter("*");
    private final String packageContext;

    private ShortTypePrinter(String packageContext) {
        this.packageContext = packageContext;
    }

    public String print(TypeMirror type) {
        return type.accept(new ShortTypePrinter(this.packageContext), null);
    }

    @Override
    public String visitIntersection(IntersectionType t, Void aVoid) {
        return t.getBounds().stream().map(this::print).collect(Collectors.joining(" & "));
    }

    @Override
    public String visitUnion(UnionType t, Void aVoid) {
        return t.getAlternatives().stream().map(this::print).collect(Collectors.joining(" | "));
    }

    @Override
    public String visitPrimitive(PrimitiveType t, Void aVoid) {
        return t.toString();
    }

    @Override
    public String visitNull(NullType t, Void aVoid) {
        return t.toString();
    }

    @Override
    public String visitArray(ArrayType t, Void aVoid) {
        return this.print(t.getComponentType()) + "[]";
    }

    @Override
    public String visitDeclared(DeclaredType t, Void aVoid) {
        Object result = t.asElement().toString();
        if (!t.getTypeArguments().isEmpty()) {
            String params = t.getTypeArguments().stream().map(this::print).collect(Collectors.joining(", "));
            result = (String)result + "<" + params + ">";
        }
        if (this.packageContext.equals("*")) {
            return ((String)result).substring(((String)result).lastIndexOf(46) + 1);
        }
        if (((String)result).startsWith("java.lang")) {
            return ((String)result).substring("java.lang.".length());
        }
        if (((String)result).startsWith("java.util")) {
            return ((String)result).substring("java.util.".length());
        }
        if (((String)result).startsWith(this.packageContext)) {
            return ((String)result).substring(this.packageContext.length());
        }
        return result;
    }

    @Override
    public String visitError(ErrorType t, Void aVoid) {
        return "_";
    }

    @Override
    public String visitTypeVariable(TypeVariable t, Void aVoid) {
        String result = t.asElement().toString();
        return result;
    }

    @Override
    public String visitWildcard(WildcardType t, Void aVoid) {
        Object result = "?";
        if (t.getSuperBound() != null) {
            result = (String)result + " super " + this.print(t.getSuperBound());
        }
        if (t.getExtendsBound() != null) {
            result = (String)result + " extends " + this.print(t.getExtendsBound());
        }
        return result;
    }

    @Override
    public String visitExecutable(ExecutableType t, Void aVoid) {
        return t.toString();
    }

    @Override
    public String visitNoType(NoType t, Void aVoid) {
        return t.toString();
    }

    public static boolean missingParamNames(ExecutableElement e) {
        return e.getParameters().stream().allMatch(p -> p.getSimpleName().toString().matches("arg\\d+"));
    }

    private String printArguments(ExecutableElement e) {
        StringJoiner result = new StringJoiner(", ");
        boolean missingParamNames = ShortTypePrinter.missingParamNames(e);
        for (VariableElement variableElement : e.getParameters()) {
            StringBuilder s = new StringBuilder();
            s.append(this.print(variableElement.asType()));
            if (!missingParamNames) {
                s.append(" ").append(variableElement.getSimpleName());
            }
            result.add(s);
        }
        return result.toString();
    }

    String printMethod(ExecutableElement m) {
        if (m.getSimpleName().contentEquals("<init>")) {
            return String.valueOf(m.getEnclosingElement().getSimpleName()) + "(" + this.printArguments(m) + ")";
        }
        StringBuilder result = new StringBuilder();
        if (m.getModifiers().contains((Object)Modifier.STATIC)) {
            result.append("static ");
        }
        result.append(this.print(m.getReturnType())).append(" ");
        result.append(m.getSimpleName());
        result.append("(").append(this.printArguments(m)).append(")");
        if (!m.getThrownTypes().isEmpty()) {
            result.append(" throws ");
            StringJoiner types = new StringJoiner(", ");
            for (TypeMirror typeMirror : m.getThrownTypes()) {
                types.add(this.print(typeMirror));
            }
            result.append(types);
        }
        return result.toString();
    }
}

