/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.index;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.List;
import java.util.Objects;
import org.javacs.ParseTask;
import org.javacs.StringSearch;
import org.javacs.lsp.Location;
import org.javacs.lsp.Position;
import org.javacs.lsp.Range;
import org.javacs.lsp.SymbolInformation;

class FindSymbolsMatching
extends TreePathScanner<Void, List<SymbolInformation>> {
    private final ParseTask task;
    private final String query;
    private CompilationUnitTree root;
    private CharSequence containerName;

    FindSymbolsMatching(ParseTask task, String query) {
        this.task = task;
        this.query = query;
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree t, List<SymbolInformation> list) {
        this.root = t;
        this.containerName = Objects.toString(t.getPackageName(), "");
        return (Void)super.visitCompilationUnit(t, list);
    }

    @Override
    public Void visitClass(ClassTree t, List<SymbolInformation> list) {
        if (StringSearch.matchesTitleCase(t.getSimpleName(), this.query)) {
            SymbolInformation info = new SymbolInformation();
            info.name = t.getSimpleName().toString();
            info.kind = FindSymbolsMatching.asSymbolKind(t.getKind());
            info.location = this.location(t);
            info.containerName = this.containerName.toString();
            list.add(info);
        }
        CharSequence push = this.containerName;
        this.containerName = t.getSimpleName();
        super.visitClass(t, list);
        this.containerName = push;
        return null;
    }

    @Override
    public Void visitMethod(MethodTree t, List<SymbolInformation> list) {
        if (StringSearch.matchesTitleCase(t.getName(), this.query)) {
            SymbolInformation info = new SymbolInformation();
            info.name = t.getName().toString();
            info.kind = FindSymbolsMatching.asSymbolKind(t.getKind());
            info.location = this.location(t);
            info.containerName = this.containerName.toString();
            list.add(info);
        }
        CharSequence push = this.containerName;
        this.containerName = t.getName();
        super.visitMethod(t, list);
        this.containerName = push;
        return null;
    }

    @Override
    public Void visitVariable(VariableTree t, List<SymbolInformation> list) {
        if (this.getCurrentPath().getParentPath().getLeaf() instanceof ClassTree && StringSearch.matchesTitleCase(t.getName(), this.query)) {
            SymbolInformation info = new SymbolInformation();
            info.name = t.getName().toString();
            info.kind = FindSymbolsMatching.asSymbolKind(t.getKind());
            info.location = this.location(t);
            info.containerName = this.containerName.toString();
            list.add(info);
        }
        CharSequence push = this.containerName;
        this.containerName = t.getName();
        super.visitVariable(t, list);
        this.containerName = push;
        return null;
    }

    private static Integer asSymbolKind(Tree.Kind k) {
        switch (k) {
            case ANNOTATION_TYPE: 
            case CLASS: {
                return 5;
            }
            case ENUM: {
                return 10;
            }
            case INTERFACE: {
                return 11;
            }
            case METHOD: {
                return 6;
            }
            case TYPE_PARAMETER: {
                return 26;
            }
            case VARIABLE: {
                return 8;
            }
        }
        return null;
    }

    private Location location(Tree t) {
        Trees trees = Trees.instance(this.task.task);
        SourcePositions pos = trees.getSourcePositions();
        LineMap lines = this.task.root.getLineMap();
        long start = pos.getStartPosition(this.root, t);
        long end = pos.getEndPosition(this.root, t);
        int startLine = (int)lines.getLineNumber(start);
        int startColumn = (int)lines.getColumnNumber(start);
        int endLine = (int)lines.getLineNumber(end);
        int endColumn = (int)lines.getColumnNumber(end);
        Range range = new Range(new Position(startLine - 1, startColumn - 1), new Position(endLine - 1, endColumn - 1));
        return new Location(this.root.getSourceFile().toUri(), range);
    }
}

