/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.markup;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.javacs.CompileTask;
import org.javacs.FileStore;
import org.javacs.lsp.Position;
import org.javacs.lsp.PublishDiagnosticsParams;
import org.javacs.lsp.Range;
import org.javacs.markup.RangeHelper;
import org.javacs.markup.WarnNotThrown;
import org.javacs.markup.WarnUnused;

public class ErrorProvider {
    final CompileTask task;

    public ErrorProvider(CompileTask task) {
        this.task = task;
    }

    public PublishDiagnosticsParams[] errors() {
        PublishDiagnosticsParams[] result = new PublishDiagnosticsParams[this.task.roots.size()];
        for (int i = 0; i < this.task.roots.size(); ++i) {
            CompilationUnitTree root = this.task.roots.get(i);
            result[i] = new PublishDiagnosticsParams();
            result[i].uri = root.getSourceFile().toUri();
            result[i].diagnostics.addAll(this.compilerErrors(root));
            result[i].diagnostics.addAll(this.unusedWarnings(root));
            result[i].diagnostics.addAll(this.notThrownWarnings(root));
        }
        return result;
    }

    private List<org.javacs.lsp.Diagnostic> compilerErrors(CompilationUnitTree root) {
        ArrayList<org.javacs.lsp.Diagnostic> result = new ArrayList<org.javacs.lsp.Diagnostic>();
        for (Diagnostic<? extends JavaFileObject> d : this.task.diagnostics) {
            if (d.getSource() == null || !d.getSource().toUri().equals(root.getSourceFile().toUri()) || d.getStartPosition() == -1L || d.getEndPosition() == -1L) continue;
            result.add(this.lspDiagnostic(d, root.getLineMap()));
        }
        return result;
    }

    private List<org.javacs.lsp.Diagnostic> unusedWarnings(CompilationUnitTree root) {
        ArrayList<org.javacs.lsp.Diagnostic> result = new ArrayList<org.javacs.lsp.Diagnostic>();
        WarnUnused warnUnused = new WarnUnused(this.task.task);
        warnUnused.scan((Tree)root, null);
        for (Element unusedEl : warnUnused.notUsed()) {
            result.add(this.warnUnused(unusedEl));
        }
        return result;
    }

    private List<org.javacs.lsp.Diagnostic> notThrownWarnings(CompilationUnitTree root) {
        ArrayList<org.javacs.lsp.Diagnostic> result = new ArrayList<org.javacs.lsp.Diagnostic>();
        HashMap notThrown = new HashMap();
        new WarnNotThrown(this.task.task).scan(root, notThrown);
        for (TreePath location : notThrown.keySet()) {
            result.add(this.warnNotThrown((String)notThrown.get(location), location));
        }
        return result;
    }

    private org.javacs.lsp.Diagnostic lspDiagnostic(Diagnostic<? extends JavaFileObject> d, LineMap lines) {
        long start = d.getStartPosition();
        long end = d.getEndPosition();
        int startLine = (int)lines.getLineNumber(start);
        int startColumn = (int)lines.getColumnNumber(start);
        int endLine = (int)lines.getLineNumber(end);
        int endColumn = (int)lines.getColumnNumber(end);
        int severity = this.severity(d.getKind());
        String code = d.getCode();
        String message = d.getMessage(null);
        org.javacs.lsp.Diagnostic result = new org.javacs.lsp.Diagnostic();
        result.severity = severity;
        result.code = code;
        result.message = message;
        result.range = new Range(new Position(startLine - 1, startColumn - 1), new Position(endLine - 1, endColumn - 1));
        return result;
    }

    private int severity(Diagnostic.Kind kind) {
        switch (kind) {
            case ERROR: {
                return 1;
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                return 2;
            }
            case NOTE: {
                return 3;
            }
        }
        return 4;
    }

    private org.javacs.lsp.Diagnostic warnNotThrown(String name, TreePath path) {
        Trees trees = Trees.instance(this.task.task);
        SourcePositions pos = trees.getSourcePositions();
        CompilationUnitTree root = path.getCompilationUnit();
        long start = pos.getStartPosition(root, path.getLeaf());
        long end = pos.getEndPosition(root, path.getLeaf());
        org.javacs.lsp.Diagnostic d = new org.javacs.lsp.Diagnostic();
        d.message = String.format("'%s' is not thrown in the body of the method", name);
        d.range = RangeHelper.range(root, start, end);
        d.code = "unused_throws";
        d.severity = 3;
        d.tags = List.of(Integer.valueOf(1));
        return d;
    }

    private org.javacs.lsp.Diagnostic warnUnused(Element unusedEl) {
        int severity;
        String code;
        VariableTree v;
        int offset;
        Trees trees = Trees.instance(this.task.task);
        TreePath path = trees.getPath(unusedEl);
        if (path == null) {
            throw new RuntimeException(String.valueOf(unusedEl) + " has no path");
        }
        CompilationUnitTree root = path.getCompilationUnit();
        Tree leaf = path.getLeaf();
        SourcePositions pos = trees.getSourcePositions();
        int start = (int)pos.getStartPosition(root, leaf);
        int end = (int)pos.getEndPosition(root, leaf);
        if (leaf instanceof VariableTree && (offset = (int)pos.getEndPosition(root, (v = (VariableTree)leaf).getType())) != -1) {
            start = offset;
        }
        Path file = Paths.get(root.getSourceFile().toUri());
        String contents = FileStore.contents(file);
        Name name = unusedEl.getSimpleName();
        if (name.contentEquals("<init>")) {
            name = unusedEl.getEnclosingElement().getSimpleName();
        }
        CharSequence region = contents.subSequence(start, (long)end == -1L ? contents.length() : end);
        Matcher matcher = Pattern.compile("\\b" + String.valueOf(name) + "\\b").matcher(region);
        if (matcher.find()) {
            end = (start += matcher.start()) + name.length();
        }
        String message = String.format("'%s' is not used", name);
        if (leaf instanceof VariableTree) {
            Tree parent = path.getParentPath().getLeaf();
            if (parent instanceof MethodTree) {
                code = "unused_param";
                severity = 4;
            } else if (parent instanceof BlockTree) {
                code = "unused_local";
                severity = 3;
            } else if (parent instanceof ClassTree) {
                code = "unused_field";
                severity = 3;
            } else {
                code = "unused_other";
                severity = 4;
            }
        } else if (leaf instanceof MethodTree) {
            code = "unused_method";
            severity = 3;
        } else if (leaf instanceof ClassTree) {
            code = "unused_class";
            severity = 3;
        } else {
            code = "unused_other";
            severity = 3;
        }
        return ErrorProvider.lspWarnUnused(severity, code, message, start, end, root);
    }

    private static org.javacs.lsp.Diagnostic lspWarnUnused(int severity, String code, String message, int start, int end, CompilationUnitTree root) {
        org.javacs.lsp.Diagnostic result = new org.javacs.lsp.Diagnostic();
        result.severity = severity;
        result.code = code;
        result.message = message;
        result.tags = List.of(Integer.valueOf(1));
        result.range = RangeHelper.range(root, start, end);
        return result;
    }
}

