/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.markup;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

class WarnNotThrown
extends TreePathScanner<Void, Map<TreePath, String>> {
    private final JavacTask task;
    private CompilationUnitTree root;
    private Map<String, TreePath> declaredExceptions = new HashMap<String, TreePath>();
    private Set<String> observedExceptions = new HashSet<String>();

    WarnNotThrown(JavacTask task) {
        this.task = task;
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree t, Map<TreePath, String> notThrown) {
        this.root = t;
        return (Void)super.visitCompilationUnit(t, notThrown);
    }

    @Override
    public Void visitMethod(MethodTree t, Map<TreePath, String> notThrown) {
        Map<String, TreePath> pushDeclared = this.declaredExceptions;
        Set<String> pushObserved = this.observedExceptions;
        this.declaredExceptions = this.declared(t);
        this.observedExceptions = new HashSet<String>();
        super.visitMethod(t, notThrown);
        for (String exception : this.declaredExceptions.keySet()) {
            if (this.observedExceptions.contains(exception)) continue;
            notThrown.put(this.declaredExceptions.get(exception), exception);
        }
        this.declaredExceptions = pushDeclared;
        this.observedExceptions = pushObserved;
        return null;
    }

    private Map<String, TreePath> declared(MethodTree t) {
        Trees trees = Trees.instance(this.task);
        HashMap<String, TreePath> names = new HashMap<String, TreePath>();
        for (ExpressionTree expressionTree : t.getThrows()) {
            TreePath path = new TreePath(this.getCurrentPath(), expressionTree);
            Element to = trees.getElement(path);
            if (!(to instanceof TypeElement)) continue;
            TypeElement type = (TypeElement)to;
            String name = type.getQualifiedName().toString();
            names.put(name, path);
        }
        return names;
    }

    @Override
    public Void visitThrow(ThrowTree t, Map<TreePath, String> notThrown) {
        TreePath path = new TreePath(this.getCurrentPath(), t.getExpression());
        TypeMirror type = Trees.instance(this.task).getTypeMirror(path);
        this.addThrown(type);
        return (Void)super.visitThrow(t, notThrown);
    }

    @Override
    public Void visitNewClass(NewClassTree t, Map<TreePath, String> notThrown) {
        Trees trees = Trees.instance(this.task);
        Element target = trees.getElement(this.getCurrentPath());
        if (target instanceof ExecutableElement) {
            ExecutableElement method = (ExecutableElement)target;
            for (TypeMirror typeMirror : method.getThrownTypes()) {
                this.addThrown(typeMirror);
            }
        }
        return (Void)super.visitNewClass(t, notThrown);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree t, Map<TreePath, String> notThrown) {
        Trees trees = Trees.instance(this.task);
        Element target = trees.getElement(this.getCurrentPath());
        if (target instanceof ExecutableElement) {
            ExecutableElement method = (ExecutableElement)target;
            for (TypeMirror typeMirror : method.getThrownTypes()) {
                this.addThrown(typeMirror);
            }
        }
        return (Void)super.visitMethodInvocation(t, notThrown);
    }

    private void addThrown(TypeMirror type) {
        if (type instanceof DeclaredType) {
            DeclaredType declared = (DeclaredType)type;
            TypeElement el = (TypeElement)declared.asElement();
            String name = el.getQualifiedName().toString();
            this.observedExceptions.add(name);
        }
    }
}

