/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.markup;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;

class WarnUnused
extends TreeScanner<Void, Void> {
    private TreePath path;
    private final Trees trees;
    private final Map<Element, TreePath> privateDeclarations = new HashMap<Element, TreePath>();
    private final Map<Element, TreePath> localVariables = new HashMap<Element, TreePath>();
    private final Set<Element> used = new HashSet<Element>();

    private void scanPath(TreePath path) {
        TreePath prev = this.path;
        this.path = path;
        try {
            path.getLeaf().accept(this, null);
        }
        finally {
            this.path = prev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void scan(Tree tree, Void p) {
        if (tree == null) {
            return null;
        }
        TreePath prev = this.path;
        this.path = new TreePath(this.path, tree);
        try {
            Void void_ = tree.accept(this, p);
            return void_;
        }
        finally {
            this.path = prev;
        }
    }

    WarnUnused(JavacTask task) {
        this.trees = Trees.instance(task);
    }

    Set<Element> notUsed() {
        HashSet<Element> unused = new HashSet<Element>();
        unused.addAll(this.privateDeclarations.keySet());
        unused.addAll(this.localVariables.keySet());
        unused.removeAll(this.used);
        unused.removeIf(Objects::isNull);
        unused.removeIf(i -> i.toString().equals("<error>"));
        return unused;
    }

    private void foundPrivateDeclaration() {
        this.privateDeclarations.put(this.trees.getElement(this.path), this.path);
    }

    private void foundLocalVariable() {
        this.localVariables.put(this.trees.getElement(this.path), this.path);
    }

    private void foundReference() {
        Element toEl = this.trees.getElement(this.path);
        if (toEl == null) {
            return;
        }
        if (toEl.asType().getKind() == TypeKind.ERROR) {
            this.foundPseudoReference(toEl);
            return;
        }
        this.sweep(toEl);
    }

    private void foundPseudoReference(Element toEl) {
        Element parent = toEl.getEnclosingElement();
        if (!(parent instanceof TypeElement)) {
            return;
        }
        Name memberName = toEl.getSimpleName();
        TypeElement type = (TypeElement)parent;
        for (Element element : type.getEnclosedElements()) {
            if (!element.getSimpleName().contentEquals(memberName)) continue;
            this.sweep(element);
        }
    }

    private void sweep(Element toEl) {
        boolean notScanned;
        boolean firstUse = this.used.add(toEl);
        boolean bl = notScanned = firstUse && this.privateDeclarations.containsKey(toEl);
        if (notScanned) {
            this.scanPath(this.privateDeclarations.get(toEl));
        }
    }

    private boolean isReachable(TreePath path) {
        ClassTree c;
        VariableTree v;
        boolean isPrivate;
        Tree t = path.getLeaf();
        if (t instanceof VariableTree && (!(isPrivate = (v = (VariableTree)t).getModifiers().getFlags().contains((Object)Modifier.PRIVATE)) || this.isLocalVariable(path))) {
            return true;
        }
        if (t instanceof MethodTree) {
            boolean isEmptyConstructor;
            MethodTree m = (MethodTree)t;
            isPrivate = m.getModifiers().getFlags().contains((Object)Modifier.PRIVATE);
            boolean bl = isEmptyConstructor = m.getParameters().isEmpty() && m.getReturnType() == null;
            if (!isPrivate || isEmptyConstructor) {
                return true;
            }
        }
        if (t instanceof ClassTree && !(isPrivate = (c = (ClassTree)t).getModifiers().getFlags().contains((Object)Modifier.PRIVATE))) {
            return true;
        }
        Element el = this.trees.getElement(path);
        return this.used.contains(el);
    }

    private boolean isLocalVariable(TreePath path) {
        MethodTree method;
        Tree.Kind kind = path.getLeaf().getKind();
        if (kind != Tree.Kind.VARIABLE) {
            return false;
        }
        Tree.Kind parent = path.getParentPath().getLeaf().getKind();
        if (parent == Tree.Kind.CLASS || parent == Tree.Kind.INTERFACE) {
            return false;
        }
        return parent != Tree.Kind.METHOD || (method = (MethodTree)path.getParentPath().getLeaf()).getBody() != null;
    }

    @Override
    public Void visitVariable(VariableTree t, Void __) {
        if (this.isLocalVariable(this.path)) {
            this.foundLocalVariable();
            super.visitVariable(t, null);
        } else if (this.isReachable(this.path)) {
            super.visitVariable(t, null);
        } else {
            this.foundPrivateDeclaration();
        }
        return null;
    }

    @Override
    public Void visitMethod(MethodTree t, Void __) {
        if (this.isReachable(this.path)) {
            super.visitMethod(t, null);
        } else {
            this.foundPrivateDeclaration();
        }
        return null;
    }

    @Override
    public Void visitClass(ClassTree t, Void __) {
        if (this.isReachable(this.path)) {
            super.visitClass(t, null);
        } else {
            this.foundPrivateDeclaration();
        }
        return null;
    }

    @Override
    public Void visitIdentifier(IdentifierTree t, Void __) {
        this.foundReference();
        return (Void)super.visitIdentifier(t, null);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree t, Void __) {
        this.foundReference();
        return (Void)super.visitMemberSelect(t, null);
    }

    @Override
    public Void visitMemberReference(MemberReferenceTree t, Void __) {
        this.foundReference();
        return (Void)super.visitMemberReference(t, null);
    }

    @Override
    public Void visitNewClass(NewClassTree t, Void __) {
        this.foundReference();
        return (Void)super.visitNewClass(t, null);
    }
}

