/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.rewrite;

import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.Trees;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.javacs.CompilerProvider;
import org.javacs.ParseTask;
import org.javacs.lsp.Position;
import org.javacs.lsp.Range;
import org.javacs.lsp.TextEdit;
import org.javacs.rewrite.Rewrite;

public class AddImport
implements Rewrite {
    final Path file;
    final String className;

    public AddImport(Path file, String className) {
        this.file = file;
        this.className = className;
    }

    @Override
    public Map<Path, TextEdit[]> rewrite(CompilerProvider compiler) {
        ParseTask task = compiler.parse(this.file);
        Position point = this.insertPosition(task);
        String text = "import " + this.className + ";\n";
        TextEdit[] edits = new TextEdit[]{new TextEdit(new Range(point, point), text)};
        return Map.of(this.file, edits);
    }

    private Position insertPosition(ParseTask task) {
        List<? extends ImportTree> imports = task.root.getImports();
        for (ImportTree importTree : imports) {
            String next = importTree.getQualifiedIdentifier().toString();
            if (this.className.compareTo(next) >= 0) continue;
            return this.insertBefore(task, importTree);
        }
        if (!imports.isEmpty()) {
            ImportTree last = imports.get(imports.size() - 1);
            return this.insertAfter(task, last);
        }
        if (task.root.getPackage() != null) {
            return this.insertAfter(task, task.root.getPackage());
        }
        return new Position(0, 0);
    }

    private Position insertBefore(ParseTask task, Tree i) {
        SourcePositions pos = Trees.instance(task.task).getSourcePositions();
        long offset = pos.getStartPosition(task.root, i);
        int line = (int)task.root.getLineMap().getLineNumber(offset);
        return new Position(line - 1, 0);
    }

    private Position insertAfter(ParseTask task, Tree i) {
        SourcePositions pos = Trees.instance(task.task).getSourcePositions();
        long offset = pos.getStartPosition(task.root, i);
        int line = (int)task.root.getLineMap().getLineNumber(offset);
        return new Position(line, 0);
    }
}

