/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.rewrite;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.Trees;
import java.nio.file.Path;
import java.util.Map;
import org.javacs.CompilerProvider;
import org.javacs.ParseTask;
import org.javacs.lsp.Position;
import org.javacs.lsp.Range;
import org.javacs.lsp.TextEdit;
import org.javacs.rewrite.FindVariableAt;
import org.javacs.rewrite.Rewrite;

public class ConvertVariableToStatement
implements Rewrite {
    final Path file;
    final int position;

    public ConvertVariableToStatement(Path file, int position) {
        this.file = file;
        this.position = position;
    }

    @Override
    public Map<Path, TextEdit[]> rewrite(CompilerProvider compiler) {
        ParseTask task = compiler.parse(this.file);
        Trees trees = Trees.instance(task.task);
        SourcePositions pos = trees.getSourcePositions();
        LineMap lines = task.root.getLineMap();
        VariableTree variable = ConvertVariableToStatement.findVariable(task, this.position);
        if (variable == null) {
            return CANCELLED;
        }
        ExpressionTree expression = variable.getInitializer();
        if (expression == null) {
            return CANCELLED;
        }
        if (!ConvertVariableToStatement.isExpressionStatement(expression)) {
            return CANCELLED;
        }
        long start = pos.getStartPosition(task.root, variable);
        long end = pos.getStartPosition(task.root, expression);
        int startLine = (int)lines.getLineNumber(start);
        int startColumn = (int)lines.getColumnNumber(start);
        Position startPos = new Position(startLine - 1, startColumn - 1);
        int endLine = (int)lines.getLineNumber(end);
        int endColumn = (int)lines.getColumnNumber(end);
        Position endPos = new Position(endLine - 1, endColumn - 1);
        Range delete = new Range(startPos, endPos);
        TextEdit edit = new TextEdit(delete, "");
        TextEdit[] edits = new TextEdit[]{edit};
        return Map.of(this.file, edits);
    }

    static VariableTree findVariable(ParseTask task, int position) {
        return (VariableTree)new FindVariableAt(task.task).scan(task.root, Integer.valueOf(position));
    }

    static boolean isExpressionStatement(Tree t) {
        switch (t.getKind()) {
            case ASSIGNMENT: 
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: 
            case METHOD_INVOCATION: 
            case NEW_CLASS: {
                return true;
            }
        }
        return false;
    }
}

