/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.rewrite;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.nio.file.Path;
import java.util.Map;
import java.util.StringJoiner;
import javax.lang.model.element.Name;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.javacs.CompileTask;
import org.javacs.CompilerProvider;
import org.javacs.lsp.Position;
import org.javacs.lsp.Range;
import org.javacs.lsp.TextEdit;
import org.javacs.rewrite.EditHelper;
import org.javacs.rewrite.FindMethodCallAt;
import org.javacs.rewrite.Rewrite;

public class CreateMissingMethod
implements Rewrite {
    final Path file;
    final int position;

    public CreateMissingMethod(Path file, int position) {
        this.file = file;
        this.position = position;
    }

    @Override
    public Map<Path, TextEdit[]> rewrite(CompilerProvider compiler) {
        try (CompileTask task = compiler.compile(this.file);){
            Trees trees = Trees.instance(task.task);
            MethodInvocationTree call = (MethodInvocationTree)new FindMethodCallAt(task.task).scan(task.root(), Integer.valueOf(this.position));
            if (call == null) {
                Map map = CANCELLED;
                return map;
            }
            TreePath path = trees.getPath(task.root(), call);
            Object insertText = "\n" + this.printMethodHeader(task, call) + " {\n    // TODO\n}";
            ClassTree surroundingClass = this.surroundingClass(path);
            int indent = EditHelper.indent(task.task, task.root(), surroundingClass) + 4;
            insertText = ((String)insertText).replaceAll("\n", "\n" + " ".repeat(indent));
            insertText = (String)insertText + "\n";
            Position insertPoint = EditHelper.insertAfter(task.task, task.root(), this.surroundingMethod(path));
            TextEdit[] edits = new TextEdit[]{new TextEdit(new Range(insertPoint, insertPoint), (String)insertText)};
            Map<Path, TextEdit[]> map = Map.of(this.file, edits);
            return map;
        }
    }

    private ClassTree surroundingClass(TreePath call) {
        while (call != null) {
            if (call.getLeaf() instanceof ClassTree) {
                return (ClassTree)call.getLeaf();
            }
            call = call.getParentPath();
        }
        throw new RuntimeException("No surrounding class");
    }

    private MethodTree surroundingMethod(TreePath call) {
        while (call != null) {
            if (call.getLeaf() instanceof MethodTree) {
                return (MethodTree)call.getLeaf();
            }
            call = call.getParentPath();
        }
        throw new RuntimeException("No surrounding class");
    }

    private String printMethodHeader(CompileTask task, MethodInvocationTree call) {
        String returnType = "void";
        String methodName = this.extractMethodName(call.getMethodSelect());
        if (returnType.equals(methodName)) {
            returnType = "_";
        }
        String parameters = this.printParameters(task, call);
        return "private " + returnType + " " + methodName + "(" + parameters + ")";
    }

    private String printParameters(CompileTask task, MethodInvocationTree call) {
        Trees trees = Trees.instance(task.task);
        StringJoiner join = new StringJoiner(", ");
        for (int i = 0; i < call.getArguments().size(); ++i) {
            TypeMirror type = trees.getTypeMirror(trees.getPath(task.root(), call.getArguments().get(i)));
            String name = this.guessParameterName(call.getArguments().get(i), type);
            String printType = EditHelper.printType(type);
            join.add(printType + " " + name);
        }
        return join.toString();
    }

    private String extractMethodName(ExpressionTree method) {
        if (method instanceof IdentifierTree) {
            IdentifierTree id = (IdentifierTree)method;
            return id.getName().toString();
        }
        if (method instanceof MemberSelectTree) {
            MemberSelectTree select = (MemberSelectTree)method;
            return select.getIdentifier().toString();
        }
        return "_";
    }

    private String guessParameterName(Tree argument, TypeMirror type) {
        String fromTree = this.guessParameterNameFromTree(argument);
        if (!fromTree.isEmpty()) {
            return fromTree;
        }
        String fromType = this.guessParameterNameFromType(type);
        if (!fromType.isEmpty()) {
            return fromType;
        }
        return "_";
    }

    private String guessParameterNameFromTree(Tree argument) {
        if (argument instanceof IdentifierTree) {
            IdentifierTree id = (IdentifierTree)argument;
            return id.getName().toString();
        }
        if (argument instanceof MemberSelectTree) {
            MemberSelectTree select = (MemberSelectTree)argument;
            return select.getIdentifier().toString();
        }
        if (argument instanceof MemberReferenceTree) {
            MemberReferenceTree reference = (MemberReferenceTree)argument;
            return reference.getName().toString();
        }
        return "";
    }

    private String guessParameterNameFromType(TypeMirror type) {
        if (type instanceof DeclaredType) {
            DeclaredType declared = (DeclaredType)type;
            Name name = declared.asElement().getSimpleName();
            return Character.toLowerCase(name.charAt(0)) + String.valueOf(name.subSequence(1, name.length()));
        }
        return "";
    }
}

