/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.rewrite;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.javacs.CompileTask;
import org.javacs.CompilerProvider;
import org.javacs.lsp.Position;
import org.javacs.lsp.Range;
import org.javacs.lsp.TextEdit;
import org.javacs.rewrite.EditHelper;
import org.javacs.rewrite.Rewrite;

public class GenerateRecordConstructor
implements Rewrite {
    final String className;
    private static final Logger LOG = Logger.getLogger("main");

    public GenerateRecordConstructor(String className) {
        this.className = className;
    }

    @Override
    public Map<Path, TextEdit[]> rewrite(CompilerProvider compiler) {
        LOG.info("Generate default constructor for " + this.className + "...");
        Path file = compiler.findTypeDeclaration(this.className);
        try (CompileTask task = compiler.compile(file);){
            TypeElement typeElement = task.task.getElements().getTypeElement(this.className);
            ClassTree typeTree = Trees.instance(task.task).getTree(typeElement);
            List<VariableTree> fields = this.fieldsNeedingInitialization(typeTree);
            String parameters = this.generateParameters(task, fields);
            String initializers = this.generateInitializers(task, fields);
            StringBuffer buf = new StringBuffer();
            buf.append("\n");
            if (typeTree.getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) {
                buf.append("public ");
            }
            buf.append(this.simpleName(this.className)).append("(").append(parameters).append(") {\n    ").append(initializers).append("\n}");
            Object string = buf.toString();
            int indent = EditHelper.indent(task.task, task.root(), typeTree) + 4;
            string = ((String)string).replaceAll("\n", "\n" + " ".repeat(indent));
            string = (String)string + "\n\n";
            Position insert = this.insertPoint(task, typeTree);
            TextEdit[] edits = new TextEdit[]{new TextEdit(new Range(insert, insert), (String)string)};
            Map<Path, TextEdit[]> map = Map.of(file, edits);
            return map;
        }
    }

    private List<VariableTree> fieldsNeedingInitialization(ClassTree typeTree) {
        ArrayList<VariableTree> fields = new ArrayList<VariableTree>();
        for (Tree tree : typeTree.getMembers()) {
            Set<Modifier> flags;
            VariableTree field;
            if (!(tree instanceof VariableTree) || (field = (VariableTree)tree).getInitializer() != null || (flags = field.getModifiers().getFlags()).contains((Object)Modifier.STATIC) || !flags.contains((Object)Modifier.FINAL)) continue;
            fields.add(field);
        }
        return fields;
    }

    private String generateParameters(CompileTask task, List<VariableTree> fields) {
        StringJoiner join = new StringJoiner(", ");
        for (VariableTree f : fields) {
            join.add(String.valueOf(this.extract(task, f.getType())) + " " + String.valueOf(f.getName()));
        }
        return join.toString();
    }

    private String generateInitializers(CompileTask task, List<VariableTree> fields) {
        StringJoiner join = new StringJoiner("\n    ");
        for (VariableTree f : fields) {
            join.add("this." + String.valueOf(f.getName()) + " = " + String.valueOf(f.getName()) + ";");
        }
        return join.toString();
    }

    private CharSequence extract(CompileTask task, Tree typeTree) {
        try {
            CharSequence contents = task.root().getSourceFile().getCharContent(true);
            SourcePositions pos = Trees.instance(task.task).getSourcePositions();
            int start = (int)pos.getStartPosition(task.root(), typeTree);
            int end = (int)pos.getEndPosition(task.root(), typeTree);
            return contents.subSequence(start, end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String simpleName(String className) {
        int dot = className.lastIndexOf(46);
        if (dot != -1) {
            return className.substring(dot + 1);
        }
        return className;
    }

    private Position insertPoint(CompileTask task, ClassTree typeTree) {
        for (Tree tree : typeTree.getMembers()) {
            MethodTree method;
            if (tree.getKind() != Tree.Kind.METHOD || (method = (MethodTree)tree).getReturnType() == null) continue;
            LOG.info("...insert constructor before " + String.valueOf(method.getName()));
            return EditHelper.insertBefore(task.task, task.root(), method);
        }
        LOG.info("...insert constructor at end of class");
        return EditHelper.insertAtEndOfClass(task.task, task.root(), typeTree);
    }
}

