/*
 * Decompiled with CFR 0.152.
 */
package gameEngine;

import gameEngine.Game;
import gameEngine.GameListener;
import gameEngine.gameObject.GameObject;
import gameUI.dialogue.GameOverDialog;
import gameUI.dialogue.GameWinDialog;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public abstract class GameEngine
extends Game {
    private long delay = 3L;
    private final List<GameObject> gameObjects;
    private GameListener gameListener;
    private int width;
    private int height;
    private final Color backgroundColor;
    private Clip clip_for_gameOver;
    private Clip clip_for_gameWin;
    private Clip clip_for_gaming;
    private final String gameOverAudioPath;
    private final String gameWinAudioPath;
    private final String gameAudioPath;
    private final String gameWinIconPath;
    private final String gameOverIconPath;
    private final String fontPath;
    private NextLevelCallback nextLevelCallback;

    public GameEngine(int width, int height, Color backgroundColor, String gameOverAudioPath, String gameWinAudioPath, String gameAudioPath, String gameWinIconPath, String gameOverIconPath, String fontPath) {
        this.width = width;
        this.height = height;
        this.backgroundColor = backgroundColor;
        this.gameOverAudioPath = gameOverAudioPath;
        this.gameWinAudioPath = gameWinAudioPath;
        this.gameAudioPath = gameAudioPath;
        this.gameWinIconPath = gameWinIconPath;
        this.gameOverIconPath = gameOverIconPath;
        this.fontPath = fontPath;
        this.setVisible(true);
        this.setSize(width, height);
        this.addKeyListener(new KeyHandler());
        this.addMouseListener(new MouseHandler());
        this.addComponentListener(new ComponentHandler());
        this.gameObjects = new ArrayList<GameObject>();
        this.setFocusable(true);
        this.requestFocus();
    }

    @Override
    public void start() {
        this.requestFocus();
        Thread gameThread = new Thread(this::play);
        gameThread.start();
    }

    public void play() {
        this.initialGame();
        this.loadAudio();
        this.clip_for_gaming.setFramePosition(0);
        this.clip_for_gaming.start();
        long beforeTime = System.currentTimeMillis();
        while (true) {
            if (this.isGameWin()) {
                this.showGameWinDialog();
                this.clearCache();
                break;
            }
            if (this.isGameOver()) {
                this.showGameOverDialog();
                this.clearCache();
                break;
            }
            long timeDiff = System.currentTimeMillis() - beforeTime;
            long sleep = this.delay - timeDiff;
            if (sleep < 0L) {
                sleep = 2L;
            }
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            beforeTime = System.currentTimeMillis();
            this.repaint();
            if (this.isGameStop()) continue;
            for (GameObject gameObject : this.gameObjects) {
                gameObject.update();
            }
            this.updateGame();
            this.saveGame();
        }
    }

    protected abstract void updateGame();

    protected abstract boolean isGameWin();

    protected abstract boolean isGameOver();

    protected abstract boolean isGameStop();

    protected abstract void initialGame();

    private void showGameWinDialog() {
        this.repaint();
        this.clip_for_gaming.stop();
        this.clip_for_gameWin.start();
        if (this.nextLevelCallback != null) {
            this.nextLevelCallback.loadNextLevel();
        }
        new GameWinDialog(this, actionEvent -> {
            if (this.getHomeCallback() != null) {
                this.getHomeCallback().goToHome();
            }
        }, actionEvent -> {
            if (this.nextLevelCallback != null) {
                this.nextLevelCallback.goToNextLevel();
            }
        }, this.gameWinIconPath, this.fontPath);
    }

    private void showGameOverDialog() {
        this.repaint();
        this.clip_for_gaming.stop();
        this.clip_for_gameOver.start();
        new GameOverDialog(this, actionEvent -> this.repeatGame(), this.gameOverIconPath, this.fontPath);
    }

    private void repeatGame() {
        this.finish();
        this.start();
    }

    private void clearCache() {
    }

    private void saveGame() {
    }

    public void addGameObject(GameObject gameObject) {
        this.gameObjects.add(gameObject);
        this.repaint();
    }

    private void loadAudio() {
        try {
            AudioInputStream music_for_gaming = AudioSystem.getAudioInputStream(Objects.requireNonNull(this.getClass().getResource(this.gameAudioPath)));
            this.clip_for_gaming = AudioSystem.getClip();
            this.clip_for_gaming.open(music_for_gaming);
            this.clip_for_gaming.loop(-1);
            AudioInputStream music_for_gameOver = AudioSystem.getAudioInputStream(Objects.requireNonNull(this.getClass().getResource(this.gameOverAudioPath)));
            this.clip_for_gameOver = AudioSystem.getClip();
            this.clip_for_gameOver.open(music_for_gameOver);
            AudioInputStream music_for_gameWin = AudioSystem.getAudioInputStream(Objects.requireNonNull(this.getClass().getResource(this.gameWinAudioPath)));
            this.clip_for_gameWin = AudioSystem.getClip();
            this.clip_for_gameWin.open(music_for_gameWin);
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
    }

    protected void clear() {
        this.gameObjects.clear();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D graphics2D = (Graphics2D)g;
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (GameObject gameObject : this.gameObjects) {
            gameObject.pain(graphics2D);
        }
        Toolkit.getDefaultToolkit().sync();
    }

    public void setGameListener(GameListener gameListener) {
        this.gameListener = gameListener;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void setNextLevelCallback(NextLevelCallback nextLevelCallback) {
        this.nextLevelCallback = nextLevelCallback;
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            super.keyTyped(e);
            if (GameEngine.this.gameListener == null) {
                return;
            }
            if (e.getKeyCode() == 32) {
                GameEngine.this.gameListener.onSpaceButtonClicked();
            } else if (e.getKeyCode() == 39) {
                GameEngine.this.gameListener.onRightButtonClicked();
            } else if (e.getKeyCode() == 37) {
                GameEngine.this.gameListener.onLeftButtonClicked();
            } else if (e.getKeyCode() == 38) {
                GameEngine.this.gameListener.onUpButtonClicked();
            } else if (e.getKeyCode() == 40) {
                GameEngine.this.gameListener.onDownButtonClicked();
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (GameEngine.this.gameListener == null) {
                return;
            }
            if (e.getButton() == 1) {
                GameEngine.this.gameListener.onLeftMouseButtonClicked(e.getX(), e.getY());
            } else if (e.getButton() == 3) {
                GameEngine.this.gameListener.onRightMouseButtonClicked(e.getX(), e.getY());
            }
        }
    }

    private class ComponentHandler
    implements ComponentListener {
        private ComponentHandler() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            GameEngine.this.requestFocus();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            GameEngine.this.requestFocus();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            GameEngine.this.requestFocus();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }

    public static interface NextLevelCallback {
        public void goToNextLevel();

        public void loadNextLevel();
    }
}

