/*
 * Decompiled with CFR 0.152.
 */
package gameEngine.gameObject;

import gameEngine.Util;
import gameEngine.gameObject.GameObject;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

public abstract class Sprite
extends GameObject {
    private BufferedImage image;
    private AffineTransform transform;

    public Sprite(String imagePath) {
        try {
            this.image = ImageIO.read(this.getClass().getResource(imagePath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void pain(Graphics2D graphics2D) {
        this.transform = new AffineTransform();
        this.transform.translate((double)this.getX() + (double)this.getWidth() / 2.5, (double)this.getY() + (double)this.getWidth() / 2.5);
        this.transform.quadrantRotate(this.getAngle());
        this.transform.translate(-((float)(this.image.getWidth() / 2)), -((float)(this.image.getHeight() / 2)));
        graphics2D.drawImage(this.image, this.transform, null);
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
        this.resizeImage();
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        this.resizeImage();
    }

    private void resizeImage() {
        this.image = Util.resize(this.image, this.getWidth(), this.getHeight());
    }
}

