/*
 * Decompiled with CFR 0.152.
 */
package gameUI;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GameHome
extends JPanel {
    private BufferedImage backgroundImage;
    private int width;
    private int height;
    private Runner runner;

    public GameHome(String backgroundPath, String runIconPath, String runClickedIconPath, int width, int height) {
        this.width = width;
        this.height = height;
        try {
            this.backgroundImage = ImageIO.read(Objects.requireNonNull(this.getClass().getResource(backgroundPath)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setLayout(new GridBagLayout());
        final JLabel run = new JLabel();
        final ImageIcon icon = new ImageIcon(Objects.requireNonNull(this.getClass().getResource(runIconPath)));
        final ImageIcon clickedIcon = new ImageIcon(Objects.requireNonNull(this.getClass().getResource(runClickedIconPath)));
        run.setIcon(icon);
        run.setSize(128, 128);
        run.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                run.setIcon(clickedIcon);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                run.setIcon(icon);
                if (GameHome.this.runner != null) {
                    GameHome.this.runner.run();
                }
            }
        });
        this.add((Component)run, new GridBagConstraints());
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponents(g);
        Graphics2D graphics2D = (Graphics2D)g;
        graphics2D.drawImage(this.backgroundImage, 0, 0, this.width, this.height, null);
    }

    public void setRunner(Runner runner) {
        this.runner = runner;
    }

    static interface Runner {
        public void run();
    }
}

