/*
 * Decompiled with CFR 0.152.
 */
package gameUI.dialogue;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class Dialog
extends JFrame {
    private Font font;
    private final JButton leftButton;
    private final JButton rightButton;
    private final JPanel buttonPanel;
    private final JLabel textLabel;
    private final JPanel contentPanel;
    private Color buttonColor = new Color(49, 46, 46);
    private Color backgroundColor = new Color(56, 56, 56);
    private Color textColor = new Color(227, 227, 227);

    public Dialog(Component parent, String title, String text, int width, String iconPath, String leftButtonText, String rightButtonText, ActionListener leftListener, ActionListener rightListener, String fontPath) {
        this.loadFont(fontPath);
        this.setSize(width, 180);
        this.setDefaultCloseOperation(1);
        this.setTitle(title);
        this.setLayout(new BorderLayout());
        this.setLocationRelativeTo(parent);
        this.leftButton = new JButton(leftButtonText);
        this.rightButton = new JButton(rightButtonText);
        this.leftButton.setOpaque(true);
        this.rightButton.setOpaque(true);
        this.leftButton.setBorderPainted(false);
        this.rightButton.setBorderPainted(false);
        this.leftButton.addActionListener(leftListener);
        this.rightButton.addActionListener(rightListener);
        this.leftButton.addActionListener(actionEvent -> this.dispatchEvent(new WindowEvent(this, 201)));
        this.rightButton.addActionListener(actionEvent -> this.dispatchEvent(new WindowEvent(this, 201)));
        this.buttonPanel = new JPanel();
        GridLayout buttonsLayout = new GridLayout(1, 2);
        buttonsLayout.setHgap(10);
        this.buttonPanel.setLayout(buttonsLayout);
        this.buttonPanel.add(this.leftButton);
        this.buttonPanel.add(this.rightButton);
        this.buttonPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add((Component)this.buttonPanel, "South");
        this.textLabel = new JLabel(text);
        ImageIcon icon = new ImageIcon(Objects.requireNonNull(this.getClass().getResource(iconPath)));
        JLabel imageLabel = new JLabel();
        imageLabel.setIcon(icon);
        this.contentPanel = new JPanel();
        this.contentPanel.setBorder(new EmptyBorder(15, 15, 10, 5));
        FlowLayout contentLayout = new FlowLayout();
        contentLayout.setAlignment(0);
        contentLayout.setHgap(20);
        this.contentPanel.setLayout(contentLayout);
        this.contentPanel.add(imageLabel);
        this.contentPanel.add(this.textLabel);
        this.add((Component)this.contentPanel, "Center");
        this.changeFonts();
        this.changeComponentColors();
        this.setVisible(true);
    }

    private void changeFonts() {
        this.leftButton.setFont(this.font);
        this.rightButton.setFont(this.font);
        this.textLabel.setFont(this.font);
    }

    private void changeComponentColors() {
        this.getContentPane().setBackground(this.backgroundColor);
        this.leftButton.setForeground(this.textColor);
        this.leftButton.setBackground(this.buttonColor);
        this.rightButton.setForeground(this.textColor);
        this.rightButton.setBackground(this.buttonColor);
        this.buttonPanel.setBackground(this.backgroundColor);
        this.textLabel.setForeground(this.textColor);
        this.contentPanel.setBackground(this.backgroundColor);
    }

    private void loadFont(String fontPath) {
        try {
            this.font = Font.createFont(0, Objects.requireNonNull(this.getClass().getResourceAsStream(fontPath))).deriveFont(18.0f);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(this.font);
        }
        catch (FontFormatException | IOException e) {
            e.printStackTrace();
        }
    }

    public void setColors(Color buttonColor, Color backgroundColor, Color textColor) {
        this.backgroundColor = backgroundColor;
        this.buttonColor = buttonColor;
        this.textColor = textColor;
        this.changeComponentColors();
    }
}

