/*
 * Decompiled with CFR 0.152.
 */
package com.splitit;

import com.splitit.ApiClient;
import com.splitit.ApiException;
import com.splitit.sdk.model.AddressData;
import com.splitit.sdk.model.ConsumerData;
import com.splitit.sdk.model.InitiateInstallmentPlanRequest;
import com.splitit.sdk.model.InitiateInstallmentsPlanResponse;
import com.splitit.sdk.model.MoneyWithCurrencyCode;
import com.splitit.sdk.model.PaymentWizardData;
import com.splitit.sdk.model.PlanData;
import com.splitit.sdk.model.RedirectUrls;
import com.splitit.sdk.model.VerifyPaymentRequest;
import com.splitit.sdk.model.VerifyPaymentResponse;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.threeten.bp.OffsetDateTime;

public class FlexFields {
    private InitiateInstallmentPlanRequest activeRequest = new InitiateInstallmentPlanRequest().planData(new PlanData());
    private ApiClient apiClient;

    public FlexFields(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public FlexFields addInstallments(String installmentOptions, int defaultNumInstallments) {
        this.activeRequest.getPlanData().numberOfInstallments(defaultNumInstallments);
        if (this.activeRequest.getPaymentWizardData() == null) {
            this.activeRequest.paymentWizardData(new PaymentWizardData());
        }
        this.activeRequest.getPaymentWizardData().requestedNumberOfInstallments(installmentOptions);
        return this;
    }

    public FlexFields addBillingInformation(AddressData billingAddress, ConsumerData consumerData) {
        this.activeRequest.billingAddress(billingAddress).consumerData(consumerData);
        return this;
    }

    public String getPublicToken(BigDecimal amount, String currencyCode) throws ApiException {
        this.activeRequest.getPlanData().amount(new MoneyWithCurrencyCode().value(amount).currencyCode(currencyCode));
        InitiateInstallmentsPlanResponse resp = this.apiClient.getInstallmentPlanApi().installmentPlanInitiate(this.activeRequest);
        return resp.getPublicToken();
    }

    public boolean verifyPayment(String planNumber, BigDecimal amount) throws ApiException {
        VerifyPaymentResponse resp = this.apiClient.getInstallmentPlanApi().installmentPlanVerifyPayment(new VerifyPaymentRequest().installmentPlanNumber(planNumber));
        return resp.isIsPaid() != false && amount.setScale(3, RoundingMode.HALF_UP).compareTo(resp.getOriginalAmountPaid()) == 0;
    }

    public FlexFields add3DSecure(RedirectUrls redirectUrls) {
        this.activeRequest.getPlanData().attempt3DSecure(true);
        this.activeRequest.redirectUrls(redirectUrls);
        return this;
    }

    public FlexFields autoCapture(boolean autocapture) {
        this.activeRequest.getPlanData().autoCapture(autocapture);
        return this;
    }

    public FlexFields firstInstallmentAmount(BigDecimal amount, String currencyCode) {
        this.activeRequest.getPlanData().firstInstallmentAmount(new MoneyWithCurrencyCode().value(amount).currencyCode(currencyCode));
        return this;
    }

    public FlexFields firstChargeDate(OffsetDateTime chargeDate) {
        this.activeRequest.getPlanData().firstChargeDate(chargeDate);
        return this;
    }
}

