/*
 * Decompiled with CFR 0.152.
 */
package com.splitit.sdk.api;

import com.google.gson.reflect.TypeToken;
import com.splitit.ApiCallback;
import com.splitit.ApiClient;
import com.splitit.ApiException;
import com.splitit.ApiResponse;
import com.splitit.Configuration;
import com.splitit.Pair;
import com.splitit.ProgressRequestBody;
import com.splitit.ProgressResponseBody;
import com.splitit.sdk.model.GetResourcesRequest;
import com.splitit.sdk.model.GetResourcesResponse;
import com.splitit.sdk.model.SystemTextCategory;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class InfrastructureApi {
    protected ApiClient apiClient;

    public InfrastructureApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InfrastructureApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call infrastructureGetResourcesCall(GetResourcesRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        GetResourcesRequest localVarPostBody = request;
        String localVarPath = "/api/Infrastructure/GetResources";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/json", "text/json", "application/_*+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call infrastructureGetResourcesValidateBeforeCall(GetResourcesRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling infrastructureGetResources(Async)");
        }
        Call call = this.infrastructureGetResourcesCall(request, progressListener, progressRequestListener);
        return call;
    }

    public GetResourcesResponse infrastructureGetResources(GetResourcesRequest request) throws ApiException {
        ApiResponse<GetResourcesResponse> resp = this.infrastructureGetResourcesWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<GetResourcesResponse> infrastructureGetResourcesWithHttpInfo(GetResourcesRequest request) throws ApiException {
        this.apiClient.performAutologin(false);
        Call call = this.infrastructureGetResourcesValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<GetResourcesResponse>(){}.getType();
        try {
            return this.apiClient.execute(call, localVarReturnType);
        }
        catch (ApiException e) {
            if (e.getCode() == 704) {
                this.apiClient.performAutologin(true);
                call = this.infrastructureGetResourcesValidateBeforeCall(request, null, null);
                localVarReturnType = new TypeToken<GetResourcesResponse>(){}.getType();
                return this.apiClient.execute(call, localVarReturnType);
            }
            throw e;
        }
    }

    public Call infrastructureGetResourcesAsync(GetResourcesRequest request, final ApiCallback<GetResourcesResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.infrastructureGetResourcesValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetResourcesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call infrastructureGetResources2Call(String apiKey, String sessionId, String merchantCode, String cultureName, String touchPointCode, List<SystemTextCategory> systemTextCategories, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/Infrastructure/GetResources";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (apiKey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("apiKey", apiKey));
        }
        if (sessionId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sessionId", sessionId));
        }
        if (merchantCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("merchantCode", merchantCode));
        }
        if (cultureName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cultureName", cultureName));
        }
        if (touchPointCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("touchPointCode", touchPointCode));
        }
        if (systemTextCategories != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "systemTextCategories", systemTextCategories));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json", "text/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call infrastructureGetResources2ValidateBeforeCall(String apiKey, String sessionId, String merchantCode, String cultureName, String touchPointCode, List<SystemTextCategory> systemTextCategories, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.infrastructureGetResources2Call(apiKey, sessionId, merchantCode, cultureName, touchPointCode, systemTextCategories, progressListener, progressRequestListener);
        return call;
    }

    public GetResourcesResponse infrastructureGetResources2(String apiKey, String sessionId, String merchantCode, String cultureName, String touchPointCode, List<SystemTextCategory> systemTextCategories) throws ApiException {
        ApiResponse<GetResourcesResponse> resp = this.infrastructureGetResources2WithHttpInfo(apiKey, sessionId, merchantCode, cultureName, touchPointCode, systemTextCategories);
        return resp.getData();
    }

    public ApiResponse<GetResourcesResponse> infrastructureGetResources2WithHttpInfo(String apiKey, String sessionId, String merchantCode, String cultureName, String touchPointCode, List<SystemTextCategory> systemTextCategories) throws ApiException {
        this.apiClient.performAutologin(false);
        Call call = this.infrastructureGetResources2ValidateBeforeCall(apiKey, sessionId, merchantCode, cultureName, touchPointCode, systemTextCategories, null, null);
        Type localVarReturnType = new TypeToken<GetResourcesResponse>(){}.getType();
        try {
            return this.apiClient.execute(call, localVarReturnType);
        }
        catch (ApiException e) {
            if (e.getCode() == 704) {
                this.apiClient.performAutologin(true);
                call = this.infrastructureGetResources2ValidateBeforeCall(apiKey, sessionId, merchantCode, cultureName, touchPointCode, systemTextCategories, null, null);
                localVarReturnType = new TypeToken<GetResourcesResponse>(){}.getType();
                return this.apiClient.execute(call, localVarReturnType);
            }
            throw e;
        }
    }

    public Call infrastructureGetResources2Async(String apiKey, String sessionId, String merchantCode, String cultureName, String touchPointCode, List<SystemTextCategory> systemTextCategories, final ApiCallback<GetResourcesResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.infrastructureGetResources2ValidateBeforeCall(apiKey, sessionId, merchantCode, cultureName, touchPointCode, systemTextCategories, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetResourcesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

