/*
 * Decompiled with CFR 0.152.
 */
package org.sqlbuilder;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sqlbuilder.Builder;
import org.sqlbuilder.Logger;
import org.sqlbuilder.Module;
import org.sqlbuilder.Resources;
import org.sqlbuilder.SQLCommand;

public class AllModules
implements Module {
    protected static final String[] LOG_TABLE_KEYS = Resources.concat("LoggedException");

    @Override
    public void setup(Properties props) {
    }

    @Override
    public void init() {
    }

    @Override
    public String getName() {
        return "all";
    }

    @Override
    public String[] getTableKeys() {
        return LOG_TABLE_KEYS;
    }

    @Override
    public String[] getXTableKeys() {
        return new String[0];
    }

    public static String[] getTableKeys(String ... moduleNames) {
        if (moduleNames == null) {
            return null;
        }
        ArrayList<String> tables = new ArrayList<String>();
        for (String moduleName : moduleNames) {
            Module module = Builder.getInstance().getModule(moduleName);
            if (module == null) continue;
            String[] tableKeys = module.getTableKeys();
            tables.addAll(Arrays.asList(tableKeys));
        }
        if (tables.isEmpty()) {
            return null;
        }
        Collections.sort(tables);
        return tables.toArray(new String[0]);
    }

    public static String[] getAllTableKeys() {
        ArrayList<String> tables = new ArrayList<String>();
        for (Module module : Builder.getInstance().getModules()) {
            String[] tableKeys = module.getTableKeys();
            tables.addAll(Arrays.asList(tableKeys));
        }
        Collections.sort(tables);
        return tables.toArray(new String[0]);
    }

    public String[] getAllXTableKeys() {
        ArrayList<String> xTables = new ArrayList<String>();
        for (Module module : Builder.getInstance().getModules()) {
            String[] xTableKeys = module.getXTableKeys();
            xTables.addAll(Arrays.asList(xTableKeys));
        }
        Collections.sort(xTables);
        return xTables.toArray(new String[0]);
    }

    @Override
    public Object parseCommand(String command) {
        if (command.matches("^create all tables")) {
            return new Command<Op>(Op.CREATEALLTABLES, new String[0]);
        }
        if (command.matches("^drop all tables")) {
            return new Command<Op>(Op.DROPALLTABLES, new String[0]);
        }
        if (command.matches("^create all constraints")) {
            return new Command<Op>(Op.CREATEALLCONSTRAINTS, new String[0]);
        }
        if (command.matches("^drop all constraints")) {
            return new Command<Op>(Op.DROPALLCONSTRAINTS, new String[0]);
        }
        if (command.matches("^create all primary key constraints")) {
            return new Command<Op>(Op.CREATEALLPKCONSTRAINTS, new String[0]);
        }
        if (command.matches("^drop all primary key constraints")) {
            return new Command<Op>(Op.DROPALLPKCONSTRAINTS, new String[0]);
        }
        if (command.matches("^create all key constraints")) {
            return new Command<Op>(Op.CREATEALLKCONSTRAINTS, new String[0]);
        }
        if (command.matches("^drop all key constraints")) {
            return new Command<Op>(Op.DROPALLKCONSTRAINTS, new String[0]);
        }
        if (command.matches("^create all unique key constraints")) {
            return new Command<Op>(Op.CREATEALLUNQCONSTRAINTS, new String[0]);
        }
        if (command.matches("^drop all unique key constraints")) {
            return new Command<Op>(Op.DROPALLUNQCONSTRAINTS, new String[0]);
        }
        if (command.matches("^create all foreign key constraints")) {
            return new Command<Op>(Op.CREATEALLFKCONSTRAINTS, new String[0]);
        }
        if (command.matches("^drop all foreign key constraints")) {
            return new Command<Op>(Op.DROPALLFKCONSTRAINTS, new String[0]);
        }
        if (command.matches("^create extra tables")) {
            return new Command<Op>(Op.CREATEXTABLES, new String[0]);
        }
        if (command.matches("^create log tables")) {
            return new Command<Op>(Op.CREATELOGTABLES, new String[0]);
        }
        if (command.matches("^drop log tables")) {
            return new Command<Op>(Op.DROPLOGTABLES, new String[0]);
        }
        if (command.matches("^flush logs")) {
            return new Command<Op>(Op.FLUSHLOGS, new String[0]);
        }
        if (command.matches("^drop extra tables")) {
            return new Command<Op>(Op.DROPXTABLES, new String[0]);
        }
        if (command.matches("^create extra constraints")) {
            return new Command<Op>(Op.CREATEXCONSTRAINTS, new String[0]);
        }
        if (command.matches("^drop extra constraints")) {
            return new Command<Op>(Op.DROPXCONSTRAINTS, new String[0]);
        }
        if (command.matches("^dump creates")) {
            return new Command<Op>(Op.DUMPCREATES, new String[0]);
        }
        if (command.matches("^dump table creates")) {
            return new Command<Op>(Op.DUMPTABLECREATES, new String[0]);
        }
        String[] args = AllModules.matches("^dump ([a-z]+) table creates", command);
        if (args != null) {
            return new Command<Op>(Op.DUMPTABLECREATES, args);
        }
        args = AllModules.matches("^dump table creates ([a-z]+)", command);
        if (args != null) {
            return new Command<Op>(Op.DUMPTABLECREATES, args);
        }
        if (command.matches("^dump view creates")) {
            return new Command<Op>(Op.DUMPVIEWCREATES, new String[0]);
        }
        args = AllModules.matches("^dump ([a-z]+) view creates", command);
        if (args != null) {
            return new Command<Op>(Op.DUMPVIEWCREATES, args);
        }
        args = AllModules.matches("^dump view creates ([a-z]+)", command);
        if (args != null) {
            return new Command<Op>(Op.DUMPVIEWCREATES, args);
        }
        if (command.matches("^dump constraints")) {
            return new Command<Op>(Op.DUMPCONSTRAINTS, new String[0]);
        }
        args = AllModules.matches("^dump ([a-z]+) constraints", command);
        if (args != null) {
            return new Command<Op>(Op.DUMPCONSTRAINTS, args);
        }
        args = AllModules.matches("^dump constraints ([a-z]+)", command);
        if (args != null) {
            return new Command<Op>(Op.DUMPCONSTRAINTS, args);
        }
        if (command.matches("^dump constraint creates")) {
            return new Command<Op>(Op.DUMPCREATECONSTRAINTS, new String[0]);
        }
        args = AllModules.matches("^dump ([a-z]+) constraint creates", command);
        if (args != null) {
            return new Command<Op>(Op.DUMPCREATECONSTRAINTS, args);
        }
        args = AllModules.matches("^dump constraint creates ([a-z]+)", command);
        if (args != null) {
            return new Command<Op>(Op.DUMPCREATECONSTRAINTS, args);
        }
        if (command.matches("^dump constraint drops")) {
            return new Command<Op>(Op.DUMPDROPCONSTRAINTS, new String[0]);
        }
        args = AllModules.matches("^dump ([a-z]+) constraint drops", command);
        if (args != null) {
            return new Command<Op>(Op.DUMPDROPCONSTRAINTS, args);
        }
        args = AllModules.matches("^dump constraint drops ([a-z]+)", command);
        if (args != null) {
            return new Command<Op>(Op.DUMPDROPCONSTRAINTS, args);
        }
        if (command.matches("^dump all")) {
            return new Command<Op>(Op.DUMPALL, new String[0]);
        }
        if (command.matches("^show info")) {
            return new Command<Op>(Op.SHOWINFO, new String[0]);
        }
        if (command.matches("^show tables")) {
            return new Command<Op>(Op.SHOWTABLES, new String[0]);
        }
        if (command.matches("^list tables")) {
            return new Command<Op>(Op.LISTTABLES, new String[0]);
        }
        if (command.matches("^list views")) {
            return new Command<Op>(Op.LISTVIEWS, new String[0]);
        }
        if (command.matches("^test")) {
            return new Command<Op>(Op.TEST, new String[0]);
        }
        return null;
    }

    public static String[] matches(String regExpr, String str) {
        Pattern pattern = Pattern.compile(regExpr);
        Matcher matcher = pattern.matcher(str);
        if (matcher.matches()) {
            int n = matcher.groupCount();
            String[] results = new String[n];
            for (int i = 0; i < n; ++i) {
                String match;
                results[i] = match = matcher.group(i + 1);
            }
            return results;
        }
        return null;
    }

    @Override
    public void help() {
        System.out.println("ALL");
        System.out.println(" create all tables");
        System.out.println(" drop all tables");
        System.out.println(" create all constraints");
        System.out.println(" drop all constraints");
        System.out.println(" create all primary key constraints");
        System.out.println(" drop all primary key constraints");
        System.out.println(" create all key constraints");
        System.out.println(" drop all key constraints");
        System.out.println(" create all unique key constraints");
        System.out.println(" drop all unique key constraints");
        System.out.println(" create all foreign key constraints");
        System.out.println(" drop all foreign key constraints");
        System.out.println("ALL EXTENSIONS");
        System.out.println(" create extra tables");
        System.out.println(" drop extra tables");
        System.out.println(" create extra constraints");
        System.out.println(" drop extra constraints");
        System.out.println("LOGS");
        System.out.println(" create log tables");
        System.out.println(" drop log tables");
        System.out.println(" flush logs");
        System.out.println(" flush logs tagged <moduletag>");
        System.out.println(" dump table creates logs");
        System.out.println(" dump constraints logs");
        System.out.println("UTILITIES");
        System.out.println(" dump creates");
        System.out.println(" dump table creates");
        System.out.println(" dump <module> table creates");
        System.out.println(" dump constraints");
        System.out.println(" dump <module> constraints");
        System.out.println(" dump <module> constraint creates");
        System.out.println(" dump <module> constraint drops");
        System.out.println(" dump view creates");
        System.out.println(" dump <module> view creates");
        System.out.println(" show tables");
        System.out.println(" show views");
        System.out.println(" show all");
        System.out.println(" show info");
    }

    @Override
    public boolean build(Object object, Properties props) throws SQLException {
        if (!(object instanceof Command)) {
            return false;
        }
        Command command = (Command)object;
        Op op = (Op)((Object)command.op);
        switch (op) {
            case CREATEALLTABLES: {
                SQLCommand.create(null);
                break;
            }
            case DROPALLTABLES: {
                SQLCommand.drop(null);
                break;
            }
            case CREATEALLCONSTRAINTS: {
                SQLCommand.createConstraints(null);
                break;
            }
            case DROPALLCONSTRAINTS: {
                SQLCommand.dropConstraints(null);
                break;
            }
            case CREATEALLPKCONSTRAINTS: {
                SQLCommand.createPk(null);
                break;
            }
            case DROPALLPKCONSTRAINTS: {
                SQLCommand.dropPk(null);
                break;
            }
            case CREATEALLKCONSTRAINTS: {
                SQLCommand.createAllIndex(null);
                break;
            }
            case DROPALLKCONSTRAINTS: {
                SQLCommand.dropAllIndex(null);
                break;
            }
            case CREATEALLUNQCONSTRAINTS: {
                SQLCommand.createUniqueIndex(null);
                break;
            }
            case DROPALLUNQCONSTRAINTS: {
                SQLCommand.dropUniqueIndex(null);
                break;
            }
            case CREATEALLFKCONSTRAINTS: {
                SQLCommand.createFk(null);
                break;
            }
            case DROPALLFKCONSTRAINTS: {
                SQLCommand.dropFk(null);
                break;
            }
            case CREATEXTABLES: {
                SQLCommand.create(Resources.resources.xTableKeys);
                break;
            }
            case DROPXTABLES: {
                SQLCommand.drop(Resources.resources.xTableKeys);
                break;
            }
            case CREATEXCONSTRAINTS: {
                SQLCommand.createConstraints(Resources.resources.xTableKeys);
                break;
            }
            case DROPXCONSTRAINTS: {
                SQLCommand.dropConstraints(Resources.resources.xTableKeys);
                break;
            }
            case CREATELOGTABLES: {
                AllModules.createLogs();
                break;
            }
            case DROPLOGTABLES: {
                AllModules.dropLogs();
                break;
            }
            case FLUSHLOGS: {
                AllModules.flushLogs();
                break;
            }
            case DUMPCREATES: {
                AllModules.dumpCreates(new String[0]);
                break;
            }
            case DUMPTABLECREATES: {
                if (command.args != null && command.args.length > 0) {
                    AllModules.dumpTableCreates(AllModules.getTableKeys(command.args));
                    break;
                }
                AllModules.dumpTableCreates();
                break;
            }
            case DUMPVIEWCREATES: {
                if (command.args != null && command.args.length > 0) {
                    AllModules.dumpViewCreates(command.args[0]);
                    break;
                }
                AllModules.dumpViewCreates();
                break;
            }
            case DUMPCONSTRAINTS: {
                if (command.args != null && command.args.length > 0) {
                    AllModules.dumpConstraints(true, AllModules.getTableKeys(command.args));
                    break;
                }
                AllModules.dumpConstraints(true, AllModules.getAllTableKeys());
                break;
            }
            case DUMPCREATECONSTRAINTS: {
                if (command.args != null && command.args.length > 0) {
                    AllModules.dumpCreateConstraints(AllModules.getTableKeys(command.args));
                    break;
                }
                AllModules.dumpCreateConstraints(AllModules.getAllTableKeys());
                break;
            }
            case DUMPDROPCONSTRAINTS: {
                if (command.args != null && command.args.length > 0) {
                    AllModules.dumpDropConstraints(AllModules.getTableKeys(command.args));
                    break;
                }
                AllModules.dumpDropConstraints(AllModules.getAllTableKeys());
                break;
            }
            case DUMPALL: {
                AllModules.dumpAll();
                break;
            }
            case SHOWTABLES: {
                SQLCommand.showTables();
                break;
            }
            case LISTTABLES: {
                AllModules.listTables();
                break;
            }
            case LISTVIEWS: {
                AllModules.listViews();
                break;
            }
            case SHOWINFO: {
                AllModules.showInfo();
                break;
            }
            case TEST: {
                AllModules.test();
                break;
            }
        }
        return false;
    }

    @Override
    public ResourceBundle getResource(Module.DBType dbType) {
        String resourceName = this.getClass().getPackage().getName() + '.' + dbType.name().toLowerCase();
        return ResourceBundle.getBundle(resourceName);
    }

    private static void createLogs() throws SQLException {
        SQLCommand.makeLogs();
    }

    private static void dropLogs() throws SQLException {
        SQLCommand.drop(LOG_TABLE_KEYS);
    }

    private static void flushLogs() throws SQLException {
        SQLCommand.flush(LOG_TABLE_KEYS);
    }

    public static void listTables() {
        for (String statement : Resources.resources.getValuesWithOp("table", true)) {
            System.out.println(statement);
        }
    }

    public static void listViews() {
        for (String statement : Resources.resources.getValuesWithOp("view", true)) {
            System.out.println(statement);
        }
    }

    public static void dumpCreates(String ... tableKeys0) {
        String[] tableKeys = tableKeys0 != null ? tableKeys0 : Resources.resources.tableKeys;
        ArrayList<String> statements1 = new ArrayList<String>();
        for (String table : AllModules.sort(Resources.resources.getTables(tableKeys))) {
            statements1.add(Resources.resources.expandTableTemplate("Template.drop-table", table));
        }
        Collection<String> statements2 = AllModules.sort(Resources.resources.getValuesWithOp("create", true));
        Collection<String> statements3 = AllModules.sort(Resources.resources.getValuesWithOp("createview", true));
        ArrayList<String> statements = new ArrayList<String>();
        statements.addAll(statements1);
        statements.addAll(statements2);
        statements.addAll(statements3);
        for (String statement : statements) {
            System.out.println(statement);
        }
    }

    public static void dumpTableCreates() {
        TreeSet<String> statements = new TreeSet<String>(Resources.resources.getValuesWithOp("create", true));
        for (String statement : statements) {
            System.out.println(statement);
        }
    }

    public static void dumpTableCreates(String ... tableKeys) {
        if (tableKeys == null) {
            return;
        }
        TreeSet<String> statements = new TreeSet<String>();
        for (String tableKey : tableKeys) {
            statements.addAll(Resources.resources.getValuesWithTableKeyAndOp(tableKey, "create", true));
        }
        for (String statement : statements) {
            System.out.println(statement);
        }
    }

    public static void dumpViewCreates() {
        for (String moduleName : Builder.getInstance().getModuleNames()) {
            AllModules.dumpViewCreates(moduleName);
        }
    }

    public static void dumpViewCreates(String module) {
        TreeSet<String> statements = new TreeSet<String>();
        for (int i = 0; i <= 9; ++i) {
            statements.addAll(AllModules.sort(Resources.resources.getValuesWithTableKeyAndOp(module + i, "createview", true)));
        }
        for (String statement : statements) {
            System.out.println(statement);
        }
    }

    public static void dumpConstraints(boolean drop, String ... tableKeys) {
        if (drop) {
            AllModules.dumpDropConstraints(tableKeys);
            System.out.println();
        }
        AllModules.dumpCreateConstraints(tableKeys);
    }

    public static void dumpCreateConstraints(String ... tableKeys0) {
        if (tableKeys0 == null) {
            return;
        }
        String[] tableKeys = tableKeys0.length > 0 ? tableKeys0 : Resources.resources.tableKeys;
        for (String op : Resources.resources.keysConstraints) {
            for (String tableKey : tableKeys) {
                for (String statement : AllModules.sort(Resources.resources.getValuesWithTableKeyAndOp(tableKey, op, false))) {
                    System.out.println(statement);
                }
            }
        }
    }

    public static void dumpDropConstraints(String ... tableKeys0) {
        if (tableKeys0 == null) {
            return;
        }
        String[] tableKeys = tableKeys0.length > 0 ? tableKeys0 : Resources.resources.tableKeys;
        for (String op : Resources.resources.keysNoConstraints) {
            for (String tableKey : tableKeys) {
                for (String statement : Resources.resources.getValuesWithTableKeyAndOp(tableKey, op, false)) {
                    System.out.println(statement);
                }
            }
        }
    }

    public static void dumpAll() {
        Resources.resources.dumpAll();
    }

    public static void showInfo() throws SQLException {
        System.out.println("### KEYS");
        String[] ops = new String[]{"table", "create", "alter", "pk", "no-pk", "unq", "no-unq", "index", "no-index", "fk", "no-fk"};
        for (String op : ops) {
            System.out.println("\n###" + op);
            for (String key : AllModules.sort(Resources.resources.getKeysWithOp(op))) {
                System.out.println(key);
            }
        }
        System.out.println("### TABLES");
        for (Module module : Builder.getInstance().getModules()) {
            System.out.println("\n### " + module.getClass());
            for (String table : AllModules.sort(Resources.resources.getTables(module.getTableKeys()))) {
                System.out.println(table);
            }
        }
        System.out.println("\n### VIEWS");
        for (String view : AllModules.sort(Resources.resources.getViews())) {
            System.out.println(view);
        }
        System.out.println("\n### EXISTING TABLES");
        for (String table : SQLCommand.getExistingTables()) {
            System.out.println(table);
        }
        System.out.println("\n### EXISTING VIEWS");
        for (String view : SQLCommand.getExistingViews()) {
            System.out.println(view);
        }
    }

    private static <T extends Comparable<? super T>> Collection<T> sort(List<T> list) {
        Collections.sort(list);
        return list;
    }

    public static void test() {
        try {
            Logger.instance = new Logger("test");
            Logger.instance.println("test");
        }
        catch (Exception e) {
            Logger.instance.logUnhandledException(e);
            System.exit(1);
        }
        finally {
            if (Logger.instance != null) {
                Logger.instance.close();
            }
            Logger.instance = null;
        }
    }

    public static enum Op {
        CREATEALLTABLES,
        DROPALLTABLES,
        SHOWTABLES,
        CREATEALLCONSTRAINTS,
        CREATEALLPKCONSTRAINTS,
        CREATEALLKCONSTRAINTS,
        CREATEALLUNQCONSTRAINTS,
        CREATEALLFKCONSTRAINTS,
        DROPALLCONSTRAINTS,
        DROPALLPKCONSTRAINTS,
        DROPALLKCONSTRAINTS,
        DROPALLUNQCONSTRAINTS,
        DROPALLFKCONSTRAINTS,
        CREATEXTABLES,
        DROPXTABLES,
        CREATEXCONSTRAINTS,
        DROPXCONSTRAINTS,
        CREATELOGTABLES,
        DROPLOGTABLES,
        FLUSHLOGS,
        DUMPCREATES,
        DUMPTABLECREATES,
        DUMPVIEWCREATES,
        DUMPCONSTRAINTS,
        DUMPDROPCONSTRAINTS,
        DUMPCREATECONSTRAINTS,
        DUMPALL,
        LISTTABLES,
        LISTVIEWS,
        SHOWINFO,
        TEST;

    }

    public static class Command<O> {
        public final O op;
        public final String[] args;

        public Command(O op, String ... args) {
            this.op = op;
            this.args = args;
        }
    }
}

