/*
 * Decompiled with CFR 0.152.
 */
package org.sqlbuilder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.sqlbuilder.AllModules;
import org.sqlbuilder.Credentials;
import org.sqlbuilder.ExtendedProperties;
import org.sqlbuilder.Logger;
import org.sqlbuilder.Module;
import org.sqlbuilder.Progress;
import org.sqlbuilder.Resources;
import org.sqlbuilder.SQLCommand;
import org.sqlbuilder.SystemUtils;

public class Builder {
    private static Builder instance = null;
    private final String[] args;
    private Properties settings;
    private String[] moduleNames;
    private final List<Module> modules;

    public static Builder getInstance() {
        return instance;
    }

    public Builder(String[] args) {
        this.args = args;
        this.modules = new ArrayList<Module>();
    }

    public void init() throws Exception {
        try {
            Boolean silent;
            this.settings = Builder.getSettings(this.args);
            Boolean verbose = Builder.parseVerbose(this.args);
            if (verbose != null && (Logger.verbose = verbose.booleanValue())) {
                System.err.println(SystemUtils.systemInfo());
                System.err.println(SystemUtils.classpath());
                this.printSorted(this.settings, System.err);
            }
            if ((silent = Builder.parseSilent(this.args)) != null) {
                Logger.silent = silent;
                Progress.silent = silent;
            }
            Credentials.set(this.settings);
            Logger.set(this.settings);
            Progress.set(this.settings);
            if (!"template".equals(this.settings.getProperty("dbms"))) {
                String driverString = this.settings.getProperty("driver");
                Builder.checkDriver(driverString);
            }
            SQLCommand.init(this.settings);
            this.makeModules();
            this.registerModules();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            throw e;
        }
        if (Logger.verbose) {
            for (Object key : this.settings.keySet()) {
                System.err.println(key + " = " + this.settings.getProperty((String)key));
            }
        }
    }

    public static Properties getSettings(String[] args) throws IOException {
        ExtendedProperties[] xProps = new ExtendedProperties[3];
        String dataFile = Builder.parseData(args);
        xProps[0] = Builder.getProperties(dataFile, new Properties[0]);
        Builder.parseOverrides(args, xProps[0]);
        String configFile = Builder.parseConfig(args);
        xProps[1] = Builder.getProperties(configFile, xProps[0]);
        String todoFile = Builder.parseToDo(args);
        xProps[2] = Builder.getProperties(todoFile, xProps[0], xProps[1]);
        Properties props = new Properties();
        for (ExtendedProperties xProp : xProps) {
            for (String key : xProp.stringPropertyNames()) {
                String value = xProp.getProperty(key);
                if (!key.equals("url")) {
                    value = value.replace('/', File.separatorChar);
                }
                props.setProperty(key, value);
            }
        }
        Builder.parseOverrides(args, props);
        return props;
    }

    private static ExtendedProperties getProperties(String filename, Properties ... propsArray) throws IOException {
        File file;
        if (filename == null || filename.isEmpty()) {
            System.err.println("USAGE -jdbc:<conf file> -todo:<todo file> <command>");
            System.exit(1);
        }
        if (!(file = new File(filename)).exists() || !file.canRead()) {
            System.err.println("Can't read " + file);
            System.exit(1);
        }
        try (FileInputStream fis = new FileInputStream(file);){
            Properties defaultProps = new Properties();
            for (Properties props : propsArray) {
                defaultProps.putAll((Map<?, ?>)props);
            }
            ExtendedProperties xProps = new ExtendedProperties(defaultProps);
            xProps.load(fis);
            ExtendedProperties extendedProperties = xProps;
            return extendedProperties;
        }
    }

    public static String getCached(Properties props, String baseName) {
        String cacheHome = props.getProperty("cachehome", null);
        String target = props.getProperty("wntarget", null);
        if (cacheHome != null) {
            File cache = new File(cacheHome);
            cache.mkdirs();
            File cached = new File(cache, baseName);
            if (target != null) {
                cache = new File(cache, target);
                cache.mkdirs();
                cached = new File(cache, baseName);
            }
            return cached.getAbsolutePath();
        }
        return baseName;
    }

    private static void checkDriver(String driverString) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (driverString == null || driverString.equals("")) {
            throw new IllegalArgumentException("Unknown JDBC driver");
        }
        Class<?> driverClass = Class.forName(driverString);
        driverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static void setUpDriver(Properties props) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (!"template".equals(props.getProperty("dbms"))) {
            String driverString = props.getProperty("driver");
            Builder.checkDriver(driverString);
        }
    }

    public static void setUpModule(Module module, Properties props) {
        AllModules allModules = new AllModules();
        String dbms = props.getProperty("dbms", "template").toUpperCase();
        Resources.resources.addResource(allModules.getResource(Module.DBType.valueOf(dbms)));
        Resources.resources.addResource(module.getResource(Module.DBType.valueOf(dbms)));
        module.setup(props);
    }

    private void registerModules() {
        for (Module module : this.getModules()) {
            module.setup(this.settings);
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Module module : this.getModules()) {
            String name = module.getName();
            if (name == null || name.isEmpty()) continue;
            names.add(name);
        }
        Builder.getInstance().moduleNames = names.toArray(new String[0]);
        String string = this.settings.getProperty("dbms", "template").toUpperCase();
        for (Module module : this.getModules()) {
            Resources.resources.addResource(module.getResource(Module.DBType.valueOf(string)));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> allXTableKeys = new ArrayList<String>();
        for (Module module : this.getModules()) {
            arrayList.addAll(Arrays.asList(module.getTableKeys()));
            allXTableKeys.addAll(Arrays.asList(module.getXTableKeys()));
        }
        Resources.resources.tableKeys = arrayList.toArray(new String[0]);
        Resources.resources.xTableKeys = allXTableKeys.toArray(new String[0]);
        for (Module module : this.getModules()) {
            module.init();
        }
    }

    private void makeModules() {
        ArrayList<String> moduleNames2 = new ArrayList<String>();
        moduleNames2.add("org.sqlbuilder.wordnet.WnModule");
        String modulesProperty = this.settings.getProperty("modules");
        String[] extensionModuleNames = modulesProperty.split("\\s+");
        moduleNames2.addAll(Arrays.asList(extensionModuleNames));
        for (String moduleName2 : moduleNames2) {
            if (moduleName2.length() == 0) continue;
            try {
                Module module = Builder.makeModule(moduleName2);
                this.getModules().add(module);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                System.err.println("Module factory: " + e.toString());
            }
        }
        this.getModules().add(new AllModules());
    }

    public Module getModule(String moduleName0) {
        String moduleName = moduleName0;
        if (moduleName.equals("logs")) {
            moduleName = "all";
        }
        for (Module module : this.getModules()) {
            if (!module.getName().equals(moduleName)) continue;
            return module;
        }
        return null;
    }

    private static Module makeModule(String moduleName) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, IllegalArgumentException, SecurityException {
        Class<?> clazz = Class.forName(moduleName);
        Class[] argsClass = new Class[]{};
        Object[] args = new Object[]{};
        Constructor<?> constructor = clazz.getConstructor(argsClass);
        Object instance = constructor.newInstance(args);
        return (Module)instance;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public String[] getModuleNames() {
        return this.moduleNames;
    }

    public void run() throws SQLException, IOException {
        String argString = Builder.join(this.args);
        for (Module module : this.getModules()) {
            Object command = module.parseCommand(argString);
            if (command == null) continue;
            module.build(command, this.settings);
            return;
        }
        System.out.println("Invalid parameter:" + argString);
        System.out.println("Valid parameters are:");
        for (Module module : this.getModules()) {
            module.help();
        }
        System.exit(1);
    }

    private static boolean parseMute(String[] args) {
        for (String arg : args) {
            if (arg.equals("-mute")) {
                return true;
            }
            if (!arg.equals("-nomute")) continue;
            return false;
        }
        return false;
    }

    private static Boolean parseVerbose(String[] args) {
        for (String arg : args) {
            if (arg.equals("-verbose")) {
                return true;
            }
            if (!arg.equals("-noverbose")) continue;
            return false;
        }
        return null;
    }

    private static Boolean parseSilent(String[] args) {
        for (String arg : args) {
            if (arg.equals("-silent")) {
                return true;
            }
            if (!arg.equals("-nosilent")) continue;
            return false;
        }
        return null;
    }

    private static String parseData(String[] args) {
        for (String arg : args) {
            if (!arg.startsWith("-data:")) continue;
            return arg.substring(6);
        }
        return null;
    }

    private static String parseConfig(String[] args) {
        for (String arg : args) {
            if (!arg.startsWith("-jdbc:")) continue;
            return arg.substring(6);
        }
        return null;
    }

    private static String parseToDo(String[] args) {
        for (String arg : args) {
            if (!arg.startsWith("-todo:")) continue;
            return arg.substring(6);
        }
        return null;
    }

    private static String parseOverrides(String[] args, Properties settings) {
        for (String arg : args) {
            if (!arg.startsWith("-set:")) continue;
            String nameValue = arg.substring(5);
            String[] fields = nameValue.split("=");
            settings.setProperty(fields[0], fields[1]);
        }
        return null;
    }

    public static String join(String[] args) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String arg : args) {
            if (arg.startsWith("-")) continue;
            if (!first) {
                sb.append(' ');
            } else {
                first = false;
            }
            sb.append(arg);
        }
        return sb.toString().trim();
    }

    public static void sleep() {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            System.err.println(e.getMessage());
            Thread.currentThread().interrupt();
        }
    }

    private void printSorted(Properties settings, PrintStream out) {
        Enumeration<Object> keysEnum = settings.keys();
        ArrayList<String> keys = new ArrayList<String>();
        while (keysEnum.hasMoreElements()) {
            keys.add(keysEnum.nextElement().toString());
        }
        Collections.sort(keys);
        for (String key : keys) {
            String value = (String)settings.get(key);
            out.println(key + '=' + value);
        }
    }

    public static Properties standalone(String[] args) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Properties props = new Properties();
        try (FileReader reader = new FileReader(args[0]);){
            props.load(reader);
        }
        Builder.setUpDriver(props);
        Credentials.set(props);
        Logger.set(props);
        return props;
    }

    public static void main(String[] args) throws Exception {
        boolean mute = Builder.parseMute(args);
        String joinedArgs = Builder.join(args);
        if (!mute) {
            System.err.println(">builder " + joinedArgs);
        }
        long start = System.currentTimeMillis();
        instance = new Builder(args);
        instance.init();
        instance.run();
        long finish = System.currentTimeMillis();
        if (!mute) {
            System.err.println("<builder " + joinedArgs + " processing took " + (finish - start) / 1000L + " seconds");
        }
    }
}

