/*
 * Decompiled with CFR 0.152.
 */
package org.sqlbuilder;

import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Checker {
    public static int errors = 0;

    private Checker() {
    }

    public static void checkEmpty(Node node, String message) throws RuntimeException {
        if (!node.getNodeValue().matches(" *")) {
            ++errors;
            throw new RuntimeException("empty node " + node + "| " + (message == null ? "" : message));
        }
    }

    public static void checkSubElements(Element e, String m, String message) throws RuntimeException {
        NodeList nodes = e.getChildNodes();
        for (int j = 0; j < nodes.getLength(); ++j) {
            Node node = nodes.item(j);
            if (!(node instanceof Element)) continue;
            if (m == null) {
                ++errors;
                throw new RuntimeException(e.getNodeName() + " has element node |" + node.getNodeName() + "| " + (message == null ? "" : message));
            }
            Checker.checkElementName(node.getNodeName(), m, message);
        }
    }

    public static void checkElementName(String name, String m, String message) throws RuntimeException {
        if (!name.matches(m)) {
            ++errors;
            throw new RuntimeException("element |" + name + "| " + (message == null ? "" : message));
        }
    }

    public static void checkAttributeName(Element e, String m, String message) throws RuntimeException {
        NamedNodeMap attrs = e.getAttributes();
        if (m != null) {
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node attr = attrs.item(i);
                    String name = attr.getNodeName();
                    if (name.matches(m)) continue;
                    ++errors;
                    throw new RuntimeException("attribute in " + e.getNodeName() + " |" + name + "| " + (message == null ? "" : message));
                }
            }
        } else if (attrs.getLength() != 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < attrs.getLength(); ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                Node attr = attrs.item(i);
                sb.append(attr.getNodeName());
            }
            ++errors;
            throw new RuntimeException("attribute |" + sb + "| " + (message == null ? "" : message));
        }
    }

    public static void checkAttributeValue(String value, String m, String message) throws RuntimeException {
        String[] items;
        if (value == null || value.isEmpty()) {
            return;
        }
        for (String item : items = value.split("\\s+")) {
            if (item.matches(m)) continue;
            ++errors;
            throw new RuntimeException("attribute value |" + item + "| " + (message == null ? "" : message));
        }
    }
}

