/*
 * Decompiled with CFR 0.152.
 */
package org.sqlbuilder;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DeSerializer {
    private DeSerializer() {
    }

    public static Object deserializeFile(String name) throws IOException, ClassNotFoundException {
        try (ObjectInputStream oos = new ObjectInputStream(new FileInputStream(name));){
            Object object = oos.readObject();
            return object;
        }
    }

    public static Object deserializeZip(String archive, String name) throws IOException, ClassNotFoundException {
        block10: {
            try (ZipFile zipFile = new ZipFile(archive);){
                Object object;
                ZipEntry ze = zipFile.getEntry(name);
                if (ze == null) break block10;
                try (ObjectInputStream ois = new ObjectInputStream(zipFile.getInputStream(ze));){
                    object = ois.readObject();
                }
                return object;
            }
        }
        throw new ClassNotFoundException(name);
    }

    public static List<Object[]> deserializeZip(String archive) throws IOException, ClassNotFoundException {
        ArrayList<Object[]> tables = new ArrayList<Object[]>();
        try (ZipFile zipFile = new ZipFile(archive);){
            Enumeration<? extends ZipEntry> zei = zipFile.entries();
            while (zei.hasMoreElements()) {
                ZipEntry ze = zei.nextElement();
                try (ObjectInputStream ois = new ObjectInputStream(zipFile.getInputStream(ze));){
                    tables.add((Object[])ois.readObject());
                }
            }
        }
        return tables;
    }
}

