/*
 * Decompiled with CFR 0.152.
 */
package org.sqlbuilder;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.sqlbuilder.Insertable;
import org.sqlbuilder.Logger;
import org.sqlbuilder.Resources;

public class ExceptionLog
implements Insertable {
    private static final String SQL_INSERT = Resources.resources.getString("LoggedException.insert");
    private final String module;
    private final String tag;
    private final String subTag;
    private final String source;
    private final long location;
    private final String line;
    private final String table;
    private final String sql;
    private final String object;
    private final Throwable throwable;

    public ExceptionLog(String module, String tag, String subTag, String source, long location, String line, String table, String sql, String object, Throwable throwable) {
        this.module = module;
        this.tag = tag;
        this.subTag = subTag;
        this.source = source == null ? null : ExceptionLog.getFileName(source);
        this.location = location;
        this.line = line;
        this.table = table;
        this.sql = sql;
        this.object = object;
        this.throwable = throwable;
    }

    public ExceptionLog(String module, String tag, String subTag, String source, long location, String line, String object, Throwable throwable) {
        this(module, tag, subTag, source, location, line, null, null, object, throwable);
    }

    private static String getFileName(String filename) {
        return new File(filename).getName();
    }

    private static String getExceptionName(Throwable throwable) {
        String name = throwable.getClass().getSimpleName();
        name = name.replace("Exception", "");
        name = name.replace("MySQL", "");
        name = name.replace("PSQL", "");
        return name;
    }

    private static String getExceptionCause(Throwable throwable) {
        return throwable.getMessage();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[E] ");
        sb.append(this.module);
        sb.append('-');
        sb.append(this.tag);
        sb.append('-');
        sb.append(this.subTag);
        sb.append(">");
        if (this.source != null) {
            sb.append(this.source.substring(this.source.lastIndexOf(File.separator) + 1));
        }
        if (this.location != -1L) {
            sb.append(":");
            sb.append(this.location);
        }
        if (this.table != null) {
            sb.append(" ");
            sb.append(this.table);
        }
        if (this.sql != null) {
            sb.append(" ");
            sb.append(this.sql);
        }
        if (this.object != null) {
            sb.append(" ");
            sb.append(this.object);
        }
        sb.append(" ");
        if (this.throwable != null) {
            sb.append(Logger.getExceptionInfo(this.throwable));
        }
        return sb.toString();
    }

    @Override
    public int insert(Connection connection) {
        try (PreparedStatement statement = connection.prepareStatement(SQL_INSERT);){
            statement.setString(1, this.module);
            statement.setString(2, this.tag);
            statement.setString(3, this.subTag);
            if (this.source == null) {
                statement.setNull(4, 12);
            } else {
                statement.setString(4, this.source);
            }
            if (this.location == -1L) {
                statement.setNull(5, 4);
            } else {
                statement.setLong(5, this.location);
            }
            if (this.line == null) {
                statement.setNull(6, 12);
            } else {
                statement.setString(6, this.line);
            }
            if (this.table == null) {
                statement.setNull(7, 12);
            } else {
                statement.setString(7, this.table);
            }
            if (this.sql == null) {
                statement.setNull(8, 12);
            } else {
                statement.setString(8, this.sql);
            }
            if (this.object == null) {
                statement.setNull(9, 12);
            } else {
                statement.setString(9, this.object);
            }
            if (this.throwable == null) {
                statement.setNull(10, 12);
                statement.setNull(11, 12);
            } else {
                statement.setString(10, ExceptionLog.getExceptionName(this.throwable));
                statement.setString(11, ExceptionLog.getExceptionCause(this.throwable));
            }
            statement.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 1;
    }
}

