/*
 * Decompiled with CFR 0.152.
 */
package org.sqlbuilder;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.sqlbuilder.Credentials;
import org.sqlbuilder.ExceptionLog;
import org.sqlbuilder.NotFoundException;
import org.sqlbuilder.ParseException;
import org.sqlbuilder.Progress;
import org.sqlbuilder.SQLUpdateException;

public class Logger
extends PrintWriter {
    public static Logger instance;
    public static boolean silent;
    public static boolean verbose;
    public static final boolean dbLog = true;
    private static String logHome;

    public static void set(Properties props) {
        logHome = props.getProperty("logdir", System.getenv().get("TEMP"));
        if (!logHome.endsWith(File.separator)) {
            logHome = logHome + File.separatorChar;
        }
        new File(logHome).mkdirs();
        verbose = props.getProperty("verbose", "").compareToIgnoreCase("true") == 0;
    }

    public Logger(String LOG_TAG) throws IOException {
        super(LOG_TAG.isEmpty() ? new PrintWriter(System.err) : Logger.makeFileWriter(LOG_TAG + ".log"));
    }

    private static FileWriter makeFileWriter(String logFilename) throws IOException {
        return new FileWriter(logHome + logFilename);
    }

    private void println(String str, String color) {
        if (silent) {
            return;
        }
        super.println(str);
        Progress.traceMark();
        Progress.println(System.out, str, color);
        Progress.traceResume();
    }

    @Override
    public void println(String str) {
        if (silent) {
            return;
        }
        super.println(str);
        Progress.traceMark();
        Progress.println(str);
        Progress.traceResume();
    }

    public void info(String message) {
        this.println(message);
    }

    public void warn(String message) {
        this.println(message);
    }

    public void logUnhandledException(Exception e) {
        Progress.fatal(Logger.getExceptionInfo(e), e);
    }

    public void logXmlException(String module, String processorTag, String subTag, String source, long location, String line, String object, Exception exception) {
        ExceptionLog loggedException = new ExceptionLog(module, processorTag, subTag, source, location, line, object, exception);
        this.println(loggedException.toString(), "\u001b[31m");
        Logger.dbLog(loggedException);
    }

    public void logSQLException(String module, String processorTag, String subTag, String source, long location, String line, String object, SQLException exception) {
        ExceptionLog loggedException = new ExceptionLog(module, processorTag, subTag, source, location, line, object, exception);
        this.println(loggedException.toString(), "\u001b[33m");
        Logger.dbLog(loggedException);
    }

    public void logParseException(String module, String processorTag, String subTag, String source, long location, String line, String object, ParseException exception) {
        ExceptionLog loggedException = new ExceptionLog(module, processorTag, subTag, source, location, line, object, exception);
        this.println(loggedException.toString(), "\u001b[33m");
        Logger.dbLog(loggedException);
    }

    public void logNotFoundException(String module, String processorTag, String subTag, String source, long location, String line, String object, NotFoundException exception) {
        ExceptionLog loggedException = new ExceptionLog(module, processorTag, subTag, source, location, line, object, exception);
        this.println(loggedException.toString(), "\u001b[35m");
        Logger.dbLog(loggedException);
    }

    public void logSQLUpdateException(String module, String processorTag, String subTag, String source, long location, String line, String object, SQLUpdateException exception) {
        ExceptionLog loggedException = new ExceptionLog(module, processorTag, subTag, source, location, line, exception.getTable(), exception.getSql(), object, exception.getCause());
        this.println(loggedException.toString(), "\u001b[33m");
        Logger.dbLog(loggedException);
    }

    public void logWarn(String module, String processorTag, String subTag, String source, long location, String line, String object) {
        ExceptionLog loggedException = new ExceptionLog(module, processorTag, subTag, source, location, line, object, null);
        this.println(loggedException.toString(), "\u001b[33m");
        Logger.dbLog(loggedException);
    }

    private static void dbLog(ExceptionLog loggedException) {
        try (Connection connection = DriverManager.getConnection(Credentials.getUrl(), Credentials.getUser(), Credentials.getPassword());){
            loggedException.insert(connection);
        }
        catch (Exception e) {
            instance.logUnhandledException(e);
            System.exit(1);
        }
    }

    public static String getExceptionInfo(Throwable throwable) {
        StackTraceElement[] stackElements = throwable.getStackTrace();
        StringBuilder sb = new StringBuilder();
        sb.append("exception=[");
        sb.append(throwable.getClass().getSimpleName());
        sb.append("] ");
        if (verbose) {
            for (StackTraceElement stackElement : stackElements) {
                if (!stackElement.getClassName().contains("sqlbuilder")) continue;
                sb.append(stackElement);
                break;
            }
            sb.append(" ");
        }
        sb.append("message=[");
        sb.append(throwable.getMessage());
        sb.append("]");
        return sb.toString();
    }

    static {
        try {
            instance = new Logger("");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        silent = false;
        verbose = false;
        logHome = "";
    }
}

