/*
 * Decompiled with CFR 0.152.
 */
package org.sqlbuilder;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.sqlbuilder.Logger;
import org.sqlbuilder.Progress;
import org.sqlbuilder.Resources;
import org.sqlbuilder.SQLCommand;

public class Normalizer {
    public static final boolean PASSTHROUGH = false;
    private static final String[] SQLS_CREATE = new String[]{Resources.resources.getString("Normalizer.drop-table"), Resources.resources.getString("Normalizer.create-table"), Resources.resources.getString("Normalizer.create-unq-index")};
    private static final String[] SQLS_CREATE2 = new String[]{Resources.resources.getString("Normalizer.drop-table"), Resources.resources.getString("Normalizer.create2-table"), Resources.resources.getString("Normalizer.create-unq-index")};
    private static final String[] SQLS_INSERT = new String[]{Resources.resources.getString("Normalizer.insert")};
    private static final String[] SQLS_INSERT2 = new String[]{Resources.resources.getString("Normalizer.insert2")};
    private static final String[] SQLS_CREATE_FK_COLUMN = new String[]{Resources.resources.getString("Normalizer.add-column-fk")};
    private static final String[] SQLS_DROP_FK_COLUMN = new String[]{Resources.resources.getString("Normalizer.drop-column-fk")};
    private static final String[] SQLS_UPDATE_FK_COLUMN = new String[]{Resources.resources.getString("Normalizer.update")};
    private static final String[] SQLS_UPDATE_FK_COLUMN2 = new String[]{Resources.resources.getString("Normalizer.update2")};
    private static final String[] SQL_CLEANUP = new String[]{Resources.resources.getString("Normalizer.drop-column-data")};
    private static final String[] SQLS_SWAP_PK = new String[]{Resources.resources.getString("Normalizer.drop-auto-pk"), Resources.resources.getString("Normalizer.change-pk"), Resources.resources.getString("Normalizer.drop-pk")};
    private static final String[] SQLS_NEW_PK = new String[]{Resources.resources.getString("Normalizer.new-pk")};
    private static final String SQLS_LENGTH = Resources.resources.getString("Normalizer.length");
    private final Properties props;
    private final Collection<String> sqls = new ArrayList<String>();
    private final Collection<String> ignoreExceptionSqls = new ArrayList<String>();

    public Normalizer(String newTable, String newCol, String newIdCol) {
        this.props = new Properties();
        this.props.put("newtable", Normalizer.getTable(newTable));
        this.props.put("newcol", newCol);
        this.props.put("newidcol", newIdCol);
    }

    public Normalizer targets(String oldTable, String oldCol, String oldIdCol) {
        this.props.put("oldtable", Normalizer.getTable(oldTable));
        this.props.put("oldcol", oldCol);
        this.props.put("oldidcol", oldIdCol);
        return this;
    }

    public Normalizer create() throws SQLException {
        int collength = (int)this.getLength();
        return this.create(collength);
    }

    public Normalizer create2() throws SQLException {
        int collength = (int)this.getLength();
        return this.create2(collength);
    }

    public Normalizer create(int collength) {
        this.props.put("collength", Integer.toString(collength));
        this.sqls.addAll(this.expand(SQLS_CREATE));
        return this;
    }

    public Normalizer create2(int collength) {
        this.props.put("collength", Integer.toString(collength));
        this.sqls.addAll(this.expand(SQLS_CREATE2));
        return this;
    }

    public Normalizer insert() {
        this.sqls.addAll(this.expand(SQLS_INSERT));
        return this;
    }

    public Normalizer insert2() {
        this.sqls.addAll(this.expand(SQLS_INSERT2));
        return this;
    }

    public Normalizer reference() {
        this.ignoreExceptionSqls.addAll(this.expand(SQLS_DROP_FK_COLUMN));
        this.sqls.addAll(this.expand(SQLS_CREATE_FK_COLUMN));
        this.sqls.addAll(this.expand(SQLS_UPDATE_FK_COLUMN));
        return this;
    }

    public Normalizer referenceThrough(String ... args) {
        String meanExpr = Normalizer.joinAs("m", args);
        this.props.put("through", meanExpr);
        this.sqls.addAll(this.expand(SQLS_UPDATE_FK_COLUMN2));
        return this;
    }

    public Normalizer cleanup() {
        this.sqls.addAll(this.expand(SQL_CLEANUP));
        return this;
    }

    public Normalizer swapPk(String oldPk, String newPk) {
        this.props.put("oldpk", oldPk);
        this.props.put("newpk", newPk);
        this.sqls.addAll(this.expand(SQLS_SWAP_PK));
        return this;
    }

    public Normalizer newPk(String newPk) {
        this.props.put("newpk", newPk);
        this.sqls.addAll(this.expand(SQLS_NEW_PK));
        return this;
    }

    private static String joinAs(String as, String ... args) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; i += 2) {
            String table = args[i];
            String joinColumn = args[i + 1];
            if (i > 0) {
                sb.append(' ');
            }
            sb.append("LEFT JOIN ");
            sb.append(Normalizer.getTable(table));
            if (i + 2 >= args.length) {
                sb.append(" AS ").append(as);
            }
            sb.append(" USING(");
            sb.append(joinColumn);
            sb.append(")");
        }
        return sb.toString();
    }

    public int exec(boolean execute) throws SQLException {
        if (Logger.verbose || !execute) {
            Normalizer.dump(this.ignoreExceptionSqls);
        }
        int result = 0;
        if (execute) {
            result = SQLCommand.exec(this.ignoreExceptionSqls, true);
        }
        if (Logger.verbose || !execute) {
            Normalizer.dump(this.sqls);
        }
        if (execute) {
            result += SQLCommand.exec(this.sqls, false);
        }
        return result;
    }

    public long getLength() throws SQLException {
        String table = this.props.getProperty("oldtable");
        String column = this.props.getProperty("oldcol");
        return Normalizer.getLength(table, column);
    }

    public static long getLength(String table, String column) throws SQLException {
        Properties props = new Properties();
        props.put("oldtable", table);
        props.put("oldcol", column);
        String sqls = Resources.expand(SQLS_LENGTH, props);
        try {
            long n = SQLCommand.queryResult(sqls);
            return n == 0L ? 80L : n;
        }
        catch (SQLException e) {
            if (Logger.verbose) {
                Progress.traceExec("exception: " + Logger.getExceptionInfo(e));
            }
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("length of" + table + '.' + column);
        }
    }

    private Collection<String> expand(String[] strs) {
        return Normalizer.expand(strs, this.props);
    }

    private static Collection<String> expand(String[] strs, Properties props) {
        ArrayList<String> strs2 = new ArrayList<String>();
        for (String str : strs) {
            strs2.add(Resources.expand(str, props));
        }
        return strs2;
    }

    public void dump() {
        this.props.list(System.out);
        System.out.println("-- IGNORE EXCEPTION");
        Normalizer.dump(this.ignoreExceptionSqls);
        System.out.println("-- DO NOT IGNORE EXCEPTION");
        Normalizer.dump(this.sqls);
    }

    private static void dump(Collection<String> strs) {
        for (String str : strs) {
            System.out.println(str);
        }
    }

    private static String getTable(String tableKey) {
        return Resources.resources.getString(tableKey + ".table");
    }
}

