/*
 * Decompiled with CFR 0.152.
 */
package org.sqlbuilder;

import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Properties;

public class Progress {
    public static boolean silent = false;
    public static boolean hyperverbose = false;
    private static long count = 0L;
    private static final int PROGRESS_EVERY = 50;
    private static final String PROGRESS_SLOT = Progress.makeRepeated(50, ' ');
    private static final String COUNTER_SLOT = Progress.makeRepeated(10, ' ');
    private static final String CLEAR_PROGRESS = '\r' + PROGRESS_SLOT + '\r';
    private static final String CLEAR_LINE = '\r' + PROGRESS_SLOT + COUNTER_SLOT + '\r';
    private static final char NEWLINE = '\n';
    public static final String RED = "\u001b[31m";
    public static final String YELLOW = "\u001b[33m";
    public static final String MAGENTA = "\u001b[35m";
    public static final String CYAN = "\u001b[36m";
    public static final String BLUE = "\u001b[34m";
    private static final String RESET = "\u001b[0m";

    public static void set(Properties props) {
        hyperverbose = props.getProperty("hyperverbose", "").compareToIgnoreCase("true") == 0;
    }

    public static void println(String str) {
        System.out.println(str);
    }

    public static void println(PrintStream ps, String str, String color) {
        ps.println(color + str + RESET);
    }

    public static void info(String str) {
        Progress.println(System.out, str, BLUE);
    }

    public static void warn(String str) {
        Progress.println(System.out, str, CYAN);
    }

    public static void fatal(String message, Exception e) {
        System.err.println();
        System.err.print(RED);
        System.err.println("!!!>" + message + '\n');
        System.err.println();
        e.printStackTrace(System.err);
        System.err.print(RESET);
    }

    public static void traceHeader(String header, String filename) {
        if (silent) {
            return;
        }
        String str = header;
        if (filename != null) {
            str = str + ">" + filename.substring(filename.lastIndexOf(File.separator) + 1);
        }
        Progress.doTraceHeader(str);
    }

    public static void traceTailer(String tailer, Long l) {
        if (silent) {
            return;
        }
        Progress.doTraceTailer(tailer + "<" + (l == null ? "" : Long.toString(l)));
    }

    public static void traceTailer(String string, String string2, long count) {
        System.out.print(CLEAR_LINE + String.format("%s< %s result:%d%n", string, string2, count) + '\n');
    }

    public static void traceExec(String str) {
        if (silent) {
            return;
        }
        System.out.print(str + '\n');
    }

    public static void traceMark() {
        if (silent) {
            return;
        }
        System.out.print(CLEAR_LINE);
    }

    public static void traceResume() {
    }

    public static void trace(long count) {
        if (silent) {
            return;
        }
        System.out.print('.');
        Progress.count = count % 50L;
        if (Progress.count == 0L) {
            System.out.print(" " + count + CLEAR_PROGRESS);
        }
    }

    public static void trace(String header, String stub) {
        if (silent) {
            return;
        }
        System.out.println(header + stub);
    }

    public static void trace(String string) {
        if (silent) {
            return;
        }
        Progress.traceMark();
        System.out.println(string);
        Progress.traceResume();
    }

    public static void tracef(String format, Object ... objects) {
        if (silent) {
            return;
        }
        String str = String.format(format, objects);
        Progress.trace(str);
    }

    private static void doTraceHeader(String header) {
        System.out.print(CLEAR_LINE + header + '\n');
    }

    private static void doTraceTailer(String tailer) {
        System.out.print(CLEAR_LINE + tailer + '\n');
    }

    private static String makeRepeated(int size, char c) {
        char[] array = new char[size];
        Arrays.fill(array, c);
        return new String(array);
    }
}

