/*
 * Decompiled with CFR 0.152.
 */
package org.sqlbuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sqlbuilder.Progress;

public class Resources {
    public static final Resources resources = new Resources();
    private final Map<String, String> resourceMap = new TreeMap<String, String>();
    public String[] tableKeys = null;
    public String[] xTableKeys = null;
    public final String[] keysPKConstraints = Resources.concat("pk");
    public final String[] keysUConstraints = Resources.concat("unq");
    public final String[] keysIConstraints = Resources.concat("index");
    public final String[] keysKConstraints = Resources.concat(new String[][]{this.keysUConstraints, this.keysIConstraints});
    public final String[] keysFKConstraints = Resources.concat("fk");
    public final String[] keysConstraints = Resources.concat(new String[][]{this.keysPKConstraints, this.keysKConstraints, this.keysFKConstraints});
    public final String[] keysNoPKConstraints = Resources.concat("no-pk");
    public final String[] keysNoUConstraints = Resources.concat("no-unq");
    public final String[] keysNoIConstraints = Resources.concat("no-index");
    public final String[] keysNoKConstraints = Resources.concat(new String[][]{this.keysNoIConstraints, this.keysNoUConstraints});
    public final String[] keysNoFKConstraints = Resources.concat("no-fk");
    public final String[] keysNoConstraints = Resources.concat(new String[][]{this.keysNoFKConstraints, this.keysNoKConstraints, this.keysNoPKConstraints});

    public void addResource(ResourceBundle bundle) {
        for (String key : bundle.keySet()) {
            this.resourceMap.put(key, bundle.getString(key));
        }
    }

    public int removeKeys(String ... keys) {
        int count = 0;
        for (String key : keys) {
            String value = this.resourceMap.remove(key);
            if (value == null) continue;
            ++count;
        }
        return count;
    }

    public static String[] concat(String ... strs) {
        return strs;
    }

    public static String[] concat(String[] ... strss) {
        ArrayList result = new ArrayList();
        for (String[] strs : strss) {
            Collections.addAll(result, strs);
        }
        return result.toArray(new String[0]);
    }

    public static String join(Collection<String> strs) {
        if (strs == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(strs);
        Collections.sort(list);
        StringBuilder sb = new StringBuilder();
        for (String str : list) {
            sb.append(str);
            sb.append(' ');
        }
        return sb.toString();
    }

    public List<String> getKeysWithOp(String str) {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : this.resourceMap.keySet()) {
            String[] fields = key.split("\\.");
            String opKey = fields[fields.length - 1];
            if (!opKey.startsWith(str)) continue;
            result.add(key);
        }
        return result;
    }

    public String getValueWithKey(String key) {
        return this.resourceMap.get(key);
    }

    public List<String> getValuesWithKey(String ... keys) {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : keys) {
            String value = this.resourceMap.get(key);
            if (value == null) continue;
            result.add(this.getString(key));
        }
        return result;
    }

    public List<String> getValuesWithOp(String str, boolean strict) {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : this.resourceMap.keySet()) {
            String[] fields = key.split("\\.");
            String opKey = fields[fields.length - 1];
            if (!(strict ? opKey.equals(str) : opKey.startsWith(str))) continue;
            result.add(this.getString(key));
        }
        return result;
    }

    public List<String> getValuesWithTableKeyAndOp(String targetTableKey, String targetOpKey, boolean strict) {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : this.resourceMap.keySet()) {
            String[] fields = key.split("\\.");
            String tableKey = fields[0];
            String opKey = fields[fields.length - 1];
            if (!tableKey.equals(targetTableKey) || !(strict ? opKey.equals(targetOpKey) : opKey.startsWith(targetOpKey))) continue;
            result.add(this.getString(key));
        }
        Collections.sort(result);
        return result;
    }

    public void dumpAll() {
        for (String key : this.resourceMap.keySet()) {
            String value = this.getString(key);
            Progress.traceExec(key + " = " + value);
            if (value.indexOf(33) == -1 && value.indexOf(37) == -1) continue;
            System.out.println(key + '+' + value);
        }
    }

    public void dumpKeys(String regExp) {
        for (String key : this.resourceMap.keySet()) {
            if (!key.matches(regExp)) continue;
            String value = this.getString(key);
            Progress.traceExec(key + " = " + value);
            if (value.indexOf(33) == -1 && value.indexOf(37) == -1) continue;
            System.out.println(key + "+" + value);
        }
    }

    public void dumpRawKeys(String regExp) {
        for (Map.Entry<String, String> entry : this.resourceMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!key.matches(regExp)) continue;
            Progress.traceExec(key + " = " + value);
            if (value.indexOf(33) == -1 && value.indexOf(37) == -1) continue;
            System.out.println(key + "+" + value);
        }
    }

    public List<String> getTables() {
        return this.getValuesWithOp("table", true);
    }

    public List<String> getTables(String ... tableKeys0) {
        if (tableKeys0 == null) {
            return this.getTables();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String key : this.getKeysWithOp("table")) {
            for (String tableKey0 : tableKeys0) {
                String[] fields = key.split("\\.");
                String tableKey = fields[0];
                if (!tableKey.equals(tableKey0)) continue;
                result.add(this.getString(key));
            }
        }
        return result;
    }

    public List<String> getViews() {
        return this.getValuesWithOp("view", true);
    }

    public static Properties makeProps(String ... strs) {
        Properties props = new Properties();
        for (int i = 0; i < strs.length; i += 2) {
            String key = strs[i];
            String value = strs[i + 1];
            props.put(key, value);
        }
        return props;
    }

    public String expandTableTemplate(String key, String table) {
        String str = this.getString(key);
        return Resources.expand(str, Resources.makeProps("table", table));
    }

    public String expandViewTemplate(String key, String view) {
        String str = this.getString(key);
        return Resources.expand(str, Resources.makeProps("view", view));
    }

    public String expandTemplate(String key, Properties props) {
        String str = this.getString(key);
        return Resources.expand(str, props);
    }

    public String getString(String key) {
        try {
            String str = this.resourceMap.get(key);
            if (str == null) {
                throw new MissingResourceException(key, Resources.class.getName(), key);
            }
            str = this.expandPercent(str);
            return str;
        }
        catch (MissingResourceException e) {
            System.err.println("NO KEY:" + e.getKey());
            throw e;
        }
    }

    private String expandPercent(String str) {
        String REGEX = "%[^%]*%";
        Pattern pattern = Pattern.compile("%[^%]*%");
        int percentCount = 0;
        int p = 0;
        while ((p = str.indexOf(34, p + 1)) != -1) {
            ++percentCount;
        }
        if (percentCount % 2 != 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            String match = matcher.group();
            String key = match.substring(1, match.length() - 1);
            if (map.containsKey(key)) continue;
            String value = this.getString(key);
            map.put(key, value);
        }
        String result = str;
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            result = result.replace("%" + key + "%", value);
        }
        return result;
    }

    public static String expand(String str, String ... strs) {
        return Resources.expand(str, Resources.makeProps(strs));
    }

    public static String expand(String str, Properties props) {
        String REGEX = "\\$[^$]+\\$";
        Pattern pattern = Pattern.compile("\\$[^$]+\\$");
        String result = str;
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            String match = matcher.group();
            String key = match.substring(1, match.length() - 1);
            String value = props.getProperty(key);
            if (value == null) {
                System.err.println("[" + match + "] -> null");
                throw new NoSuchElementException(match);
            }
            result = result.replaceAll("\\$" + key + "\\$", value);
        }
        return result;
    }
}

