/*
 * Decompiled with CFR 0.152.
 */
package org.sqlbuilder;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.sqlbuilder.Credentials;
import org.sqlbuilder.Logger;
import org.sqlbuilder.Module;
import org.sqlbuilder.Progress;
import org.sqlbuilder.Resources;

public class SQLCommand {
    private static String sessionSetupSql = null;

    private SQLCommand() {
    }

    public static void init(Properties props) {
        sessionSetupSql = props.getProperty("sessionsetup");
    }

    public static long queryResult(String sql) throws SQLException {
        try (Connection connection = DriverManager.getConnection(Credentials.getUrl(), Credentials.getUser(), Credentials.getPassword());){
            try (Statement statement = connection.createStatement();){
                if (Logger.verbose) {
                    Progress.traceExec("execute>" + sql);
                }
                try (ResultSet resultSet = statement.executeQuery(sql);){
                    if (resultSet.next()) {
                        long l = resultSet.getLong(1);
                        return l;
                    }
                }
            }
            throw new IllegalArgumentException(sql);
        }
    }

    public static void query(Collection<String> sqls, boolean ignoreException) throws SQLException {
        block26: {
            try (Connection connection = DriverManager.getConnection(Credentials.getUrl(), Credentials.getUser(), Credentials.getPassword());
                 Statement statement = connection.createStatement();){
                for (String sql : sqls) {
                    Progress.traceExec("execute>" + sql);
                    try {
                        ResultSet resultSet = statement.executeQuery(sql);
                        try {
                            ResultSetMetaData metaData = resultSet.getMetaData();
                            int l = 0;
                            while (resultSet.next()) {
                                System.out.print(l++ + ">");
                                for (int k = 1; k <= metaData.getColumnCount(); ++k) {
                                    String fieldName = metaData.getColumnLabel(k);
                                    System.out.print(fieldName + "=" + resultSet.getString(k) + " ");
                                }
                                Progress.traceExec("");
                            }
                        }
                        finally {
                            if (resultSet == null) continue;
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!ignoreException) {
                            throw e;
                        }
                        if (!Logger.verbose) continue;
                        Progress.traceExec("ignored " + Logger.getExceptionInfo(e));
                    }
                }
            }
            catch (SQLException e) {
                if (!ignoreException) {
                    throw e;
                }
                if (!Logger.verbose) break block26;
                Progress.traceExec("ignored " + Logger.getExceptionInfo(e));
            }
        }
    }

    public static void query(String[] sqls, boolean ignoreException) throws SQLException {
        SQLCommand.query(SQLCommand.toList(sqls), ignoreException);
    }

    public static Set<String> getExistingTables() throws SQLException {
        try (Connection connection = DriverManager.getConnection(Credentials.getUrl(), Credentials.getUser(), Credentials.getPassword());){
            TreeSet<String> treeSet;
            block13: {
                DatabaseMetaData metaData = connection.getMetaData();
                ResultSet resultSet = metaData.getTables(null, null, null, new String[]{"TABLE"});
                try {
                    TreeSet<String> result = new TreeSet<String>();
                    while (resultSet.next()) {
                        result.add(resultSet.getString("table_name"));
                    }
                    treeSet = result;
                    if (resultSet == null) break block13;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return treeSet;
        }
    }

    public static Set<String> getExistingViews() throws SQLException {
        try (Connection connection = DriverManager.getConnection(Credentials.getUrl(), Credentials.getUser(), Credentials.getPassword());){
            TreeSet<String> treeSet;
            block13: {
                DatabaseMetaData metaData = connection.getMetaData();
                ResultSet resultSet = metaData.getTables(null, null, null, new String[]{"VIEW"});
                try {
                    TreeSet<String> result = new TreeSet<String>();
                    while (resultSet.next()) {
                        result.add(resultSet.getString("table_name"));
                    }
                    treeSet = result;
                    if (resultSet == null) break block13;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return treeSet;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static int exec(Collection<String> sqls, boolean ignoreException) throws SQLException {
        if (sqls == null || sqls.isEmpty()) {
            return 0;
        }
        boolean batchMode = false;
        try (Connection connection = DriverManager.getConnection(Credentials.getUrl(), Credentials.getUser(), Credentials.getPassword());){
            int n;
            block24: {
                Statement statement = connection.createStatement();
                try {
                    if (sessionSetupSql != null && !sessionSetupSql.isEmpty()) {
                        statement.execute(sessionSetupSql);
                    }
                    for (String sql : sqls) {
                        if (Logger.verbose) {
                            Progress.traceExec("execute>" + sql);
                        } else {
                            Progress.trace(1L);
                        }
                        try {
                            statement.execute(sql);
                        }
                        catch (SQLException e) {
                            if (!ignoreException) {
                                Progress.traceExec("sql:" + sql);
                                throw e;
                            }
                            if (!Logger.verbose) continue;
                            Progress.traceExec("ignored " + Logger.getExceptionInfo(e));
                        }
                    }
                    n = sqls.size();
                    if (statement == null) break block24;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return n;
        }
        catch (SQLException e) {
            if (!ignoreException) {
                throw e;
            }
            if (Logger.verbose) {
                Progress.traceExec("ignored " + Logger.getExceptionInfo(e));
            }
            return 0;
        }
    }

    public static int exec(String sql, boolean ignoreException) throws SQLException {
        if (sql == null || sql.isEmpty()) {
            return 0;
        }
        try (Connection connection = DriverManager.getConnection(Credentials.getUrl(), Credentials.getUser(), Credentials.getPassword());){
            int n;
            block20: {
                Progress.traceExec("execute>" + sql);
                Statement statement = connection.createStatement();
                try {
                    if (sessionSetupSql != null && !sessionSetupSql.isEmpty()) {
                        statement.execute(sessionSetupSql);
                    }
                    statement.execute(sql);
                    n = 1;
                    if (statement == null) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        if (!ignoreException) {
                            throw e;
                        }
                        if (Logger.verbose) {
                            Progress.traceExec("ignored " + Logger.getExceptionInfo(e));
                        }
                        int n2 = 0;
                        if (connection != null) {
                            connection.close();
                        }
                        return n2;
                    }
                }
                statement.close();
            }
            return n;
        }
    }

    public static int execTableKeys(String[] tablekeys, String[] opSubkeys, boolean ignoreException) throws SQLException {
        String[] tableSubkeys = tablekeys;
        if (tableSubkeys == null) {
            tableSubkeys = Resources.resources.tableKeys;
        }
        int i = 0;
        for (String tableKey : tableSubkeys) {
            for (String op : opSubkeys) {
                i += SQLCommand.exec(Resources.resources.getValuesWithTableKeyAndOp(tableKey, op, false), ignoreException);
            }
        }
        return i;
    }

    private static int execTemplateForTableKeys(String key, String[] tableKeys, boolean ignoreException) throws SQLException {
        ArrayList<String> sqls = new ArrayList<String>();
        for (String table : tableKeys == null ? Resources.resources.getTables() : Resources.resources.getTables(tableKeys)) {
            sqls.add(Resources.resources.expandTableTemplate(key, table));
        }
        return SQLCommand.exec(sqls, ignoreException);
    }

    private static int execTemplateForTableKeys(String key, String[] tableKeys, Properties props, boolean ignoreException) throws SQLException {
        ArrayList<String> sqls = new ArrayList<String>();
        for (String table : tableKeys == null ? Resources.resources.getTables() : Resources.resources.getTables(tableKeys)) {
            props.setProperty("table", table);
            String sql = Resources.resources.expandTemplate(key, props);
            sqls.add(sql);
        }
        return SQLCommand.exec(sqls, ignoreException);
    }

    public static void create(String ... tableKeys) throws SQLException {
        Progress.traceHeader("create", Resources.join(Resources.resources.getTables(tableKeys)));
        long count = SQLCommand.execTableKeys(tableKeys, Resources.concat("create", "altcreate"), false);
        Progress.traceTailer("create", count);
    }

    public static void drop(String ... tableKeys) throws SQLException {
        Progress.traceHeader("drop", Resources.join(Resources.resources.getTables(tableKeys)));
        long count = SQLCommand.execTemplateForTableKeys("Template.drop-table", tableKeys, true);
        Progress.traceTailer("drop", count);
    }

    public static void makeLogs() throws SQLException {
        SQLCommand.create("LoggedException");
    }

    public static void flush(String ... tableKeys) throws SQLException {
        Progress.traceHeader("flush", Resources.join(Resources.resources.getTables(tableKeys)));
        long count = SQLCommand.execTemplateForTableKeys("Template.truncate-table", tableKeys, true);
        Progress.traceTailer("flush", count);
    }

    private static void flushWhere(String column, String value, String ... tableKeys) throws SQLException {
        Properties props = new Properties();
        props.setProperty("col", column);
        props.setProperty("val", '\'' + value + '\'');
        Progress.traceHeader("delete", Resources.join(Resources.resources.getTables(tableKeys)));
        long count = SQLCommand.execTemplateForTableKeys("Template.truncate-table-where", tableKeys, props, true);
        Progress.traceTailer("delete", count);
    }

    public static void flushLogs(String moduleId) throws SQLException {
        SQLCommand.flushWhere("module", moduleId, "LoggedException");
    }

    public static void createViews(Module module) throws SQLException {
        ArrayList<String> views = new ArrayList<String>();
        ArrayList<String> statements = new ArrayList<String>();
        for (int i = 0; i <= 9; ++i) {
            views.addAll(Resources.resources.getValuesWithTableKeyAndOp(module.getName() + i, "view", true));
            statements.addAll(Resources.resources.getValuesWithTableKeyAndOp(module.getName() + i, "createview", true));
        }
        Progress.traceHeader("create views", SQLCommand.toString(views));
        long count = SQLCommand.exec(statements, false);
        Progress.traceTailer("create views", count);
    }

    public static void dropViews(Module module) throws SQLException {
        ArrayList<String> views = new ArrayList<String>();
        ArrayList<String> statements = new ArrayList<String>();
        for (int i = 0; i <= 9; ++i) {
            for (String view : Resources.resources.getValuesWithTableKeyAndOp(module.getName() + i, "view", true)) {
                views.add(view);
                statements.add(Resources.resources.expandViewTemplate("Template.drop-view", view));
            }
        }
        Progress.traceHeader("drop views", SQLCommand.toString(views));
        long count = SQLCommand.exec(statements, false);
        Progress.traceTailer("drop views", count);
    }

    private static int constrain(String[] keys, boolean ignoreException, String ... tableKeys) throws SQLException {
        return SQLCommand.execTableKeys(tableKeys, keys, ignoreException);
    }

    public static void createConstraints(boolean ignoreException, String ... tableKeys) throws SQLException {
        Progress.traceHeader("create constraints", Resources.join(Resources.resources.getTables(tableKeys)));
        long count = SQLCommand.constrain(Resources.resources.keysConstraints, ignoreException, tableKeys);
        Progress.traceTailer("create constraints", count);
    }

    public static void createConstraints(String ... tableKeys) throws SQLException {
        SQLCommand.createConstraints(true, tableKeys);
    }

    public static void dropConstraints(boolean ignoreException, String ... tableKeys) throws SQLException {
        Progress.traceHeader("drop constraints", Resources.join(Resources.resources.getTables(tableKeys)));
        long count = SQLCommand.constrain(Resources.resources.keysNoConstraints, ignoreException, tableKeys);
        Progress.traceTailer("drop constraints", count);
    }

    public static void dropConstraints(String ... tableKeys) throws SQLException {
        SQLCommand.dropConstraints(true, tableKeys);
    }

    public static void createFk(String ... tableKeys) throws SQLException {
        Progress.traceHeader("create fk constraint", Resources.join(Resources.resources.getTables(tableKeys)));
        long count = SQLCommand.constrain(Resources.resources.keysFKConstraints, true, tableKeys);
        Progress.traceTailer("create fk constraints", count);
    }

    public static void dropFk(String ... tableKeys) throws SQLException {
        Progress.traceHeader("drop fk constraint", Resources.join(Resources.resources.getTables(tableKeys)));
        long count = SQLCommand.constrain(Resources.resources.keysNoFKConstraints, true, tableKeys);
        Progress.traceTailer("drop fk constraints", count);
    }

    public static void createPk(String ... tableKeys) throws SQLException {
        Progress.traceHeader("create pk", Resources.join(Resources.resources.getTables(tableKeys)));
        long count = SQLCommand.constrain(Resources.resources.keysPKConstraints, true, tableKeys);
        Progress.traceTailer("create pk", count);
    }

    public static void dropPk(String ... tableKeys) throws SQLException {
        Progress.traceHeader("drop pk constraints", Resources.join(Resources.resources.getTables(tableKeys)));
        long count = SQLCommand.constrain(Resources.resources.keysNoPKConstraints, true, tableKeys);
        Progress.traceTailer("drop pk constraints", count);
    }

    public static void createAllIndex(String ... tableKeys) throws SQLException {
        Progress.traceHeader("create index", Resources.join(Resources.resources.getTables(tableKeys)));
        long count = SQLCommand.execTableKeys(tableKeys, Resources.resources.keysKConstraints, true);
        Progress.traceTailer("create index", count);
    }

    public static void dropAllIndex(String ... tableKeys) throws SQLException {
        Progress.traceHeader("drop all index", Resources.join(Resources.resources.getTables(tableKeys)));
        long count = SQLCommand.execTableKeys(tableKeys, Resources.resources.keysKConstraints, true);
        Progress.traceTailer("drop all index", count);
    }

    public static void createIndex(String ... tableKeys) throws SQLException {
        Progress.traceHeader("create index", Resources.join(Resources.resources.getTables(tableKeys)));
        long count = SQLCommand.execTableKeys(tableKeys, Resources.resources.keysIConstraints, true);
        Progress.traceTailer("create index", count);
    }

    public static void dropIndex(String ... tableKeys) throws SQLException {
        Progress.traceHeader("drop index", Resources.join(Resources.resources.getTables(tableKeys)));
        long count = SQLCommand.execTableKeys(tableKeys, Resources.resources.keysIConstraints, true);
        Progress.traceTailer("drop index", count);
    }

    public static void createUniqueIndex(String ... tableKeys) throws SQLException {
        Progress.traceHeader("create unique index", Resources.join(Resources.resources.getTables(tableKeys)));
        long count = SQLCommand.execTableKeys(tableKeys, Resources.resources.keysUConstraints, true);
        Progress.traceTailer("create index", count);
    }

    public static void dropUniqueIndex(String ... tableKeys) throws SQLException {
        Progress.traceHeader("drop unique index", Resources.join(Resources.resources.getTables(tableKeys)));
        long count = SQLCommand.execTableKeys(tableKeys, Resources.resources.keysUConstraints, true);
        Progress.traceTailer("drop index", count);
    }

    public static void showTables() throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        statements.add(Resources.resources.getString("Template.query-tables"));
        List<String> tableKeys = Resources.resources.getValuesWithOp("table", true);
        for (String tableKey : tableKeys) {
            statements.add(Resources.resources.expandTableTemplate("Template.query-table-schema", tableKey));
            statements.add(Resources.resources.expandTableTemplate("Template.query-table-constraints", tableKey));
        }
        SQLCommand.query(statements, false);
    }

    public static boolean existsTableOrView(String table) throws SQLException {
        Set<String> tables = SQLCommand.getExistingTables();
        if (tables.contains(table)) {
            return true;
        }
        Set<String> views = SQLCommand.getExistingViews();
        return views.contains(table);
    }

    private static int execTemplateForTables(String key, Collection<String> tables, boolean ignoreException) throws SQLException {
        if (tables == null) {
            return 0;
        }
        ArrayList<String> sqls = new ArrayList<String>();
        for (String table : tables) {
            sqls.add(Resources.resources.expandTableTemplate(key, table));
        }
        return SQLCommand.exec(sqls, ignoreException);
    }

    public static void dropTables(Collection<String> tables) throws SQLException {
        Progress.traceHeader("drop", Resources.join(tables));
        long count = SQLCommand.execTemplateForTables("Template.drop-table", tables, true);
        Progress.traceTailer("drop", count);
    }

    public static void flushTables(Collection<String> tables) throws SQLException {
        Progress.traceHeader("flush", Resources.join(tables));
        long count = SQLCommand.execTemplateForTables("Template.truncate-table", tables, true);
        Progress.traceTailer("flush", count);
    }

    private static Collection<String> toList(String[] strs) {
        return Arrays.asList(strs);
    }

    private static String toString(Collection<String> strs) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String str : strs) {
            if (!first) {
                sb.append(' ');
            } else {
                first = false;
            }
            sb.append(str);
        }
        return sb.toString();
    }

    public static void disableKeys(String ... tableKeys) throws SQLException {
        Progress.traceHeader("disable keys", "start");
        long count = SQLCommand.enableKeys("keys.disable", tableKeys);
        Progress.traceTailer("disable keys", count);
    }

    public static void enableKeys(String ... tableKeys) throws SQLException {
        Progress.traceHeader("enable keys", "start");
        long count = SQLCommand.enableKeys("keys.enable", tableKeys);
        Progress.traceTailer("enable keys", count);
    }

    private static int enableKeys(String alterKey, String ... tableKeys) throws SQLException {
        String alter = Resources.resources.getValueWithKey(alterKey);
        if (alter == null || alter.isEmpty()) {
            return 0;
        }
        List<String> tables = Resources.resources.getTables(tableKeys);
        ArrayList<String> statements = new ArrayList<String>();
        for (String table : tables) {
            statements.add(String.format(alter, table));
        }
        return SQLCommand.exec(statements, false);
    }
}

