/*
 * Decompiled with CFR 0.152.
 */
package org.sqlbuilder;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.sqlbuilder.Progress;

public class Serializer {
    private Serializer() {
    }

    public static void serializeFile(String name, Serializable object) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(name));){
            oos.writeObject(object);
        }
    }

    public static void serializeZip(String archive, String name, Object object) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(archive, true));){
            ZipEntry ze = new ZipEntry(name);
            zos.putNextEntry(ze);
            try (ObjectOutputStream oos = new ObjectOutputStream(zos);){
                oos.writeObject(object);
                zos.closeEntry();
            }
        }
    }

    public static void serializeZip(String archive, String[] names, Object ... objects) throws IOException {
        if (names.length > objects.length) {
            Progress.warn(String.format("Zip serializer %s with objects {%s} has length-mismatch", archive, Arrays.toString(objects)));
        } else if (names.length < objects.length) {
            Progress.warn(String.format("Zip serializer %s with objects {%s} has unnamed objects", archive, Arrays.toString(objects)));
        }
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(archive, true));){
            int max = Math.min(names.length, objects.length);
            for (int i = 0; i < max; ++i) {
                ZipEntry ze = new ZipEntry(names[i]);
                zos.putNextEntry(ze);
                try (ObjectOutputStream oos = new ObjectOutputStream(zos);){
                    oos.writeObject(objects[i]);
                    zos.flush();
                    zos.closeEntry();
                    continue;
                }
            }
        }
    }
}

